/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.swt.control.JDataChoosePage;
import org.geotools.swt.control.JDataStorePage;

public class JDataStoreWizard
extends Wizard {
    private Map<String, Object> connectionParameters;
    private DataStoreFactorySpi format;
    private JDataChoosePage dataChoosePage;
    private JDataStorePage dataStorePage;

    public JDataStoreWizard(String extension) {
        this((DataStoreFactorySpi)(extension == null ? null : FileDataStoreFinder.getDataStoreFactory(extension)));
    }

    public JDataStoreWizard(DataStoreFactorySpi format) {
        this(format, new HashMap<String, Object>());
    }

    public JDataStoreWizard(DataStoreFactorySpi format, Map<String, Object> params) {
        this.setWindowTitle(format == null ? "Connect" : (format == null ? "" : format.getDisplayName()));
        this.connectionParameters = params == null ? new HashMap<String, Object>() : params;
        if (format == null) {
            this.dataChoosePage = new JDataChoosePage();
        }
        this.fillInDefaults(format, params);
        this.format = format;
        this.dataStorePage = new JDataStorePage(format, this.connectionParameters);
        this.dataStorePage.setLevel("user");
        if (this.countParamsAtLevel(format, "advanced") != 0) {
            this.dataStorePage = new JDataStorePage(format, this.connectionParameters);
            this.dataStorePage.setLevel("advanced");
        }
    }

    public void addPages() {
        super.addPages();
        if (this.dataChoosePage != null) {
            this.addPage((IWizardPage)this.dataChoosePage);
        }
        this.addPage((IWizardPage)this.dataStorePage);
    }

    public boolean performFinish() {
        return true;
    }

    private void fillInDefaults(DataStoreFactorySpi format, Map<String, Object> params) {
        if (format == null) {
            return;
        }
        for (DataAccessFactory.Param param : format.getParametersInfo()) {
            if (!param.required || !"program".equals(param.getLevel()) || params.containsKey(param.key)) continue;
            params.put(param.key, param.sample);
        }
    }

    private int countParamsAtLevel(DataStoreFactorySpi format, String level) {
        if (format == null) {
            return 0;
        }
        int count = 0;
        DataAccessFactory.Param[] parametersInfo = format.getParametersInfo();
        if (level == null) {
            return parametersInfo.length;
        }
        for (DataAccessFactory.Param param : parametersInfo) {
            String check = param.getLevel();
            if (!level.equals(check)) continue;
            ++count;
        }
        return count;
    }

    public Map<String, Object> getConnectionParameters() {
        return this.connectionParameters;
    }

    public File getFile() {
        URL url = (URL)this.connectionParameters.get("url");
        return DataUtilities.urlToFile(url);
    }

    public void setFormat(DataStoreFactorySpi format) {
        if (this.format == format) {
            return;
        }
        if (this.connectionParameters.isEmpty()) {
            this.fillInDefaults(format, this.connectionParameters);
        }
        if (this.dataStorePage != null) {
            this.dataStorePage.setFormat(format);
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        JDataStoreWizard wizard = new JDataStoreWizard(".shp");
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.open();
    }
}

