/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.swt.control.ParamField;

public class JDataStorePage
extends WizardPage {
    public static final String ID = "org.geotools.swt.data.DataStorePage";
    protected DataStoreFactorySpi format;
    private Map<DataAccessFactory.Param, ParamField> fields = new HashMap<DataAccessFactory.Param, ParamField>();
    protected Map<String, Object> connectionParameters;
    private String level = null;

    public JDataStorePage(DataStoreFactorySpi format) {
        this(format, null);
    }

    public JDataStorePage(DataStoreFactorySpi format, Map<String, Object> params) {
        super(ID);
        this.setTitle(format.getDisplayName());
        this.setDescription(format.getDescription());
        this.format = format;
        if (params == null) {
            params = new HashMap<String, Object>();
            if (format != null) {
                for (DataAccessFactory.Param param : format.getParametersInfo()) {
                    params.put(param.key, (Serializable)param.sample);
                }
            }
        }
        this.connectionParameters = params;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.preDisplayPanel();
        } else {
            this.preClosePanel();
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        mainComposite.setLayout((Layout)gridLayout);
        for (DataAccessFactory.Param param : this.format.getParametersInfo()) {
            if (this.level != null) {
                String check;
                String string = check = param.metadata == null ? "user" : (String)param.metadata.get("level");
                if (check == null) {
                    check = "user";
                }
                if (!this.level.equals(check)) continue;
            }
            String txt = param.title.toString();
            if (param.required) {
                txt = txt + "*";
            }
            Label label = new Label(mainComposite, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(txt);
            ParamField field = ParamField.create(mainComposite, param);
            field.doLayout();
            this.fields.put(param, field);
        }
        this.setControl((Control)mainComposite);
    }

    private void preDisplayPanel() {
        for (Map.Entry<DataAccessFactory.Param, ParamField> entry : this.fields.entrySet()) {
            DataAccessFactory.Param param = entry.getKey();
            ParamField field = entry.getValue();
            Object value = null;
            try {
                value = param.lookUp(this.connectionParameters);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (value == null && param.required) {
                value = param.sample;
            }
            field.setValue(value);
        }
    }

    private void preClosePanel() {
        for (Map.Entry<DataAccessFactory.Param, ParamField> entry : this.fields.entrySet()) {
            DataAccessFactory.Param param = entry.getKey();
            ParamField field = entry.getValue();
            Object value = field.getValue();
            this.connectionParameters.put(param.key, (Serializable)value);
            field.setValue(value);
        }
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setFormat(DataStoreFactorySpi format) {
        if (this.format != format) {
            this.format = format;
        }
    }

    public boolean isValid() {
        for (Map.Entry<DataAccessFactory.Param, ParamField> entry : this.fields.entrySet()) {
            if (!entry.getValue().validate()) {
                return false;
            }
            if (entry.getKey().required && entry.getValue().getValue() != null) continue;
        }
        return true;
    }
}

