/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;

public class JDataChoosePage
extends WizardPage
implements ISelectionChangedListener {
    public static final String ID = "org.geotools.swt.data.DataChoosePage";
    private DataStoreFactorySpi selectedFactory;
    private boolean canFlip;

    public JDataChoosePage() {
        super(ID);
        this.setTitle("Choose DataStore");
        this.setDescription("Available DataStores on your classpath");
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        mainComposite.setLayout((Layout)gridLayout);
        ArrayList<DataStoreFactorySpi> factoryList = new ArrayList<DataStoreFactorySpi>();
        Iterator<DataStoreFactorySpi> iter = DataStoreFinder.getAvailableDataStores();
        while (iter.hasNext()) {
            factoryList.add(iter.next());
        }
        TableViewer viewer = new TableViewer(mainComposite);
        GridData viewerGD = new GridData(4, 4, true, false);
        viewer.getTable().setLayoutData((Object)viewerGD);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof DataStoreFactorySpi) {
                    DataStoreFactorySpi factory = (DataStoreFactorySpi)element;
                    return factory.getDisplayName();
                }
                return super.getText(element);
            }
        });
        viewer.setInput((Object)factoryList.toArray());
        this.setControl((Control)mainComposite);
        this.canFlip = false;
    }

    public boolean canFlipToNextPage() {
        return this.canFlip;
    }

    public DataStoreFactorySpi getSelectedFactory() {
        return this.selectedFactory;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection sel;
        Object selObj;
        ISelection selection = event.getSelection();
        if (selection instanceof StructuredSelection && (selObj = (sel = (StructuredSelection)selection).getFirstElement()) instanceof DataStoreFactorySpi) {
            this.selectedFactory = (DataStoreFactorySpi)selObj;
        }
        if (this.selectedFactory != null) {
            this.canFlip = true;
        }
        this.getWizard().getContainer().updateButtons();
    }
}

