/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.swt.control.CRSChooser;
import org.geotools.swt.control.Controller;
import org.geotools.swt.utils.Messages;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSChooserDialog
extends Dialog {
    private final CRSChooser chooser = new CRSChooser();
    private final CoordinateReferenceSystem initialValue;
    private CoordinateReferenceSystem result;

    public CRSChooserDialog(Shell parentShell, CoordinateReferenceSystem initialValue) {
        super(parentShell);
        this.initialValue = initialValue;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.getString("CRSChooserDialog_title"));
        this.chooser.setController(new Controller(){

            @Override
            public void handleClose() {
                CRSChooserDialog.this.close();
            }

            @Override
            public void handleOk() {
                CRSChooserDialog.this.result = CRSChooserDialog.this.chooser.getCRS();
            }
        });
        Control control = this.chooser.createControl(parent, this.initialValue);
        this.chooser.setFocus();
        return control;
    }

    public boolean close() {
        this.result = this.chooser.getCRS();
        return super.close();
    }

    public CoordinateReferenceSystem getResult() {
        return this.result;
    }

    public static void main(String[] args) {
        CRSChooserDialog dialog = new CRSChooserDialog(new Shell(Display.getDefault()), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        dialog.setBlockOnOpen(true);
        dialog.open();
        CoordinateReferenceSystem crs = dialog.getResult();
        System.out.println(crs);
    }
}

