/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.action;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.map.FeatureLayer;
import org.geotools.map.MapContent;
import org.geotools.styling.Style;
import org.geotools.swt.action.MapAction;
import org.geotools.swt.control.JFileDataStoreChooser;
import org.geotools.swt.utils.ImageCache;
import org.geotools.swt.utils.Utils;

public class OpenShapefileAction
extends MapAction
implements ISelectionChangedListener {
    public OpenShapefileAction() {
        super("Open Shapefile", "Load a shapefile into the viewer.", ImageCache.getInstance().getImage("/icons/open.gif"));
    }

    @Override
    public void run() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        File openFile = JFileDataStoreChooser.showOpenFile(new String[]{"*.shp"}, shell);
        try {
            if (openFile != null && openFile.exists()) {
                MapContent mapContent = this.mapPane.getMapContent();
                FileDataStore store = FileDataStoreFinder.getDataStore(openFile);
                SimpleFeatureSource featureSource = store.getFeatureSource();
                Style style = Utils.createStyle(openFile, featureSource);
                FeatureLayer featureLayer = new FeatureLayer((FeatureSource)featureSource, style);
                mapContent.addLayer(featureLayer);
                this.mapPane.redraw();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
    }
}

