/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.action;

import java.io.File;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.MapContent;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactoryImpl;
import org.geotools.styling.Symbolizer;
import org.geotools.swt.action.MapAction;
import org.geotools.swt.control.JFileImageChooser;
import org.geotools.swt.utils.ImageCache;

public class OpenGeotiffAction
extends MapAction
implements ISelectionChangedListener {
    public OpenGeotiffAction() {
        super("Open Image", "Load an image file into the viewer.", ImageCache.getInstance().getImage("/icons/open.gif"));
    }

    @Override
    public void run() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        File openFile = JFileImageChooser.showOpenFile(shell);
        if (openFile != null && openFile.exists()) {
            AbstractGridFormat format = GridFormatFinder.findFormat((Object)openFile);
            AbstractGridCoverage2DReader tiffReader = format.getReader((Object)openFile);
            StyleFactoryImpl sf = new StyleFactoryImpl();
            RasterSymbolizer symbolizer = sf.getDefaultRasterSymbolizer();
            Style defaultStyle = SLD.wrapSymbolizers(new Symbolizer[]{symbolizer});
            MapContent mapContent = this.mapPane.getMapContent();
            GridReaderLayer layer = new GridReaderLayer((GridCoverage2DReader)tiffReader, defaultStyle);
            layer.setTitle(openFile.getName());
            mapContent.addLayer(layer);
            this.mapPane.redraw();
        }
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
    }
}

