/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.action;

import java.awt.geom.AffineTransform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.event.MapBoundsEvent;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.swt.action.MapAction;
import org.geotools.swt.tool.InfoTool;
import org.geotools.swt.utils.ImageCache;

public class DrawShapeAction
extends MapAction
implements MapBoundsListener {
    private static boolean odd = true;
    private static boolean first = true;

    public DrawShapeAction() {
        super("Drawshape@D", InfoTool.TOOL_TIP, ImageCache.getInstance().getImage("/icons/info_mode.gif"));
    }

    @Override
    public void run() {
        if (first) {
            this.getMapPane().getMapContent().addMapBoundsListener(this);
            first = false;
        }
        Rectangle visibleRect = this.getMapPane().getVisibleRect();
        ReferencedEnvelope displayArea = this.getMapPane().getDisplayArea();
        this.drawShapes(visibleRect, displayArea, false);
    }

    private void drawShapes(Rectangle visibleRect, ReferencedEnvelope areaOfInterest, boolean boundsChanged) {
        Display display = Display.getDefault();
        Color white = display.getSystemColor(1);
        PaletteData palette = new PaletteData(new RGB[]{white.getRGB()});
        ImageData sourceData = new ImageData(visibleRect.width, visibleRect.height, 1, palette);
        sourceData.transparentPixel = 0;
        Image img = new Image((Device)display, sourceData);
        GC gc = new GC((Drawable)img);
        gc.setAntialias(1);
        double[] worldCoords = odd ? new double[]{10.0, 40.0, 11.2, 43.3, 11.3, 45.2, 11.4, 46.5} : new double[]{11.0, 41.0, 12.2, 44.3, 11.3, 45.2, 11.4, 46.5};
        odd = !odd;
        double[] screenCoords = new double[8];
        AffineTransform worldToScreenTransform = this.getMapPane().getWorldToScreenTransform();
        worldToScreenTransform.transform(worldCoords, 0, screenCoords, 0, worldCoords.length / 2);
        gc.setForeground(display.getSystemColor(11));
        gc.setLineWidth(2);
        gc.drawLine((int)screenCoords[0], (int)screenCoords[1], (int)screenCoords[2], (int)screenCoords[3]);
        gc.drawLine((int)screenCoords[2], (int)screenCoords[3], (int)screenCoords[4], (int)screenCoords[5]);
        int size = 10;
        gc.setBackground(display.getSystemColor(3));
        gc.fillOval((int)screenCoords[0] - size / 2, (int)screenCoords[1] - size / 2, size, size);
        gc.fillOval((int)screenCoords[2] - size / 2, (int)screenCoords[3] - size / 2, size, size);
        gc.fillOval((int)screenCoords[4] - size / 2, (int)screenCoords[5] - size / 2, size, size);
        gc.setForeground(display.getSystemColor(2));
        gc.drawOval((int)screenCoords[0] - size / 2, (int)screenCoords[1] - size / 2, size, size);
        gc.drawOval((int)screenCoords[2] - size / 2, (int)screenCoords[3] - size / 2, size, size);
        gc.drawOval((int)screenCoords[4] - size / 2, (int)screenCoords[5] - size / 2, size, size);
        gc.setAntialias(0);
        gc.dispose();
        this.getMapPane().setOverlay(img, areaOfInterest, false, boundsChanged);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    @Override
    public void mapBoundsChanged(MapBoundsEvent event) {
        ReferencedEnvelope newAreaOfInterest = event.getNewAreaOfInterest();
        Rectangle visibleRect = this.getMapPane().getVisibleRect();
        this.drawShapes(visibleRect, newAreaOfInterest, true);
    }
}

