/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.event.MapBoundsEvent;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.map.event.MapLayerListEvent;
import org.geotools.map.event.MapLayerListListener;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.swt.MapLayerComposite;
import org.geotools.swt.event.MapMouseListener;
import org.geotools.swt.event.MapPaneEvent;
import org.geotools.swt.event.MapPaneListener;
import org.geotools.swt.tool.CursorTool;
import org.geotools.swt.tool.MapToolManager;
import org.geotools.swt.utils.CursorManager;
import org.geotools.swt.utils.Messages;
import org.geotools.swt.utils.Utils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class SwtMapPane
extends Canvas
implements Listener,
MapLayerListListener,
MapBoundsListener {
    private static final PaletteData PALETTE_DATA = new PaletteData(0xFF0000, 65280, 255);
    private static final int TRANSPARENT_COLOR = 1193046;
    public static final int DEFAULT_RESIZING_PAINT_DELAY = 500;
    private int resizingPaintDelay;
    private boolean acceptRepaintRequests;
    private ReferencedEnvelope fullExtent;
    private MapContent content;
    private GTRenderer renderer;
    private LabelCache labelCache;
    private MapToolManager toolManager;
    private MapLayerComposite layerTable;
    private Set<MapPaneListener> listeners = new HashSet<MapPaneListener>();
    private AffineTransform worldToScreen;
    private AffineTransform screenToWorld;
    private org.eclipse.swt.graphics.Rectangle curPaintArea;
    private BufferedImage baseImage;
    private Point imageOrigin;
    private boolean redrawBaseImage;
    private boolean clearLabelCache;
    private boolean toolCanDraw;
    private boolean toolCanMove;
    private Image swtImage;
    private GC gc;
    private boolean mouseDown = false;
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private boolean isDragging = false;
    private Image overlayImage;
    private ReferencedEnvelope overlayEnvelope;
    private boolean overlayDoXor;
    private int alpha = 255;
    private Color white = this.getDisplay().getSystemColor(1);
    private Color yellow = this.getDisplay().getSystemColor(7);
    private Color cursorToolColor;
    private int cursorToolLineWidth;
    private int cursorToolLineStyle;

    public SwtMapPane(Composite parent, int style) {
        this(parent, style, null, null);
    }

    public SwtMapPane(Composite parent, int style, GTRenderer renderer, MapContent content) {
        super(parent, style);
        this.addListener(9, this);
        this.addListener(3, this);
        this.addListener(4, this);
        this.imageOrigin = new Point(0, 0);
        this.acceptRepaintRequests = true;
        this.redrawBaseImage = true;
        this.clearLabelCache = false;
        this.setRenderer(renderer);
        this.setMapContent(content);
        this.toolManager = new MapToolManager(this);
        this.addMouseListener(this.toolManager);
        this.addMouseMoveListener(this.toolManager);
        this.addMouseWheelListener(this.toolManager);
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                if (SwtMapPane.this.mouseDown) {
                    SwtMapPane.this.endX = event.x;
                    SwtMapPane.this.endY = event.y;
                    SwtMapPane.this.isDragging = true;
                    if (!SwtMapPane.this.isDisposed()) {
                        SwtMapPane.this.redraw();
                    }
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SwtMapPane.this.curPaintArea = SwtMapPane.this.getVisibleRect();
                SwtMapPane.this.doSetDisplayArea((org.opengis.geometry.Envelope)SwtMapPane.this.content.getViewport().getBounds());
            }
        });
        this.cursorToolColor = this.getDisplay().getSystemColor(7);
        this.cursorToolLineWidth = 2;
        this.cursorToolLineStyle = 1;
    }

    public void setCursorTool(CursorTool tool) {
        if (tool == null) {
            this.toolManager.setNoCursorTool();
            this.setCursor(CursorManager.getInstance().getArrowCursor());
            this.toolCanDraw = false;
            this.toolCanMove = false;
        } else {
            this.setCursor(tool.getCursor());
            this.toolManager.setCursorTool(tool);
            this.toolCanDraw = tool.canDraw();
            this.toolCanMove = tool.canMove();
        }
    }

    public void addMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Messages.getString("arg_null_error"));
        }
        this.toolManager.addMouseListener(listener);
    }

    public void removeMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Messages.getString("arg_null_error"));
        }
        this.toolManager.removeMouseListener(listener);
    }

    public void addMapPaneListener(MapPaneListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Messages.getString("arg_null_error"));
        }
        this.listeners.add(listener);
    }

    public void setMapLayerTable(MapLayerComposite layerTable) {
        if (layerTable == null) {
            throw new IllegalArgumentException(Messages.getString("arg_null_error"));
        }
        this.layerTable = layerTable;
    }

    public GTRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(GTRenderer renderer) {
        if (renderer != null && renderer instanceof StreamingRenderer) {
            Map<Object, Object> hints = renderer.getRendererHints();
            if (hints == null) {
                hints = new HashMap<Object, Object>();
            }
            if (hints.containsKey("labelCache")) {
                this.labelCache = (LabelCache)hints.get("labelCache");
            } else {
                this.labelCache = new LabelCacheImpl();
                hints.put("labelCache", this.labelCache);
            }
            renderer.setRendererHints(hints);
            if (this.content != null) {
                renderer.setMapContent(this.content);
            }
        }
        this.renderer = renderer;
    }

    public MapContent getMapContent() {
        return this.content;
    }

    public void setMapContent(MapContent content) {
        if (this.content != content) {
            if (this.content != null) {
                this.content.removeMapLayerListListener(this);
            }
            this.content = content;
            if (content != null) {
                this.content.addMapLayerListListener(this);
                this.content.addMapBoundsListener(this);
                for (Layer layer : content.layers()) {
                    layer.setSelected(true);
                }
                this.setFullExtent();
            }
            if (this.renderer != null) {
                this.renderer.setMapContent(this.content);
            }
            MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.NEW_CONTEXT);
            this.publishEvent(ev);
        }
    }

    public ReferencedEnvelope getDisplayArea() {
        ReferencedEnvelope aoi = null;
        if (this.curPaintArea != null && this.screenToWorld != null) {
            Rectangle awtRectangle = Utils.toAwtRectangle(this.curPaintArea);
            Point2D.Double p0 = new Point2D.Double(awtRectangle.getMinX(), awtRectangle.getMinY());
            Point2D.Double p1 = new Point2D.Double(awtRectangle.getMaxX(), awtRectangle.getMaxY());
            this.screenToWorld.transform(p0, p0);
            this.screenToWorld.transform(p1, p1);
            aoi = new ReferencedEnvelope(Math.min(((Point2D)p0).getX(), ((Point2D)p1).getX()), Math.max(((Point2D)p0).getX(), ((Point2D)p1).getX()), Math.min(((Point2D)p0).getY(), ((Point2D)p1).getY()), Math.max(((Point2D)p0).getY(), ((Point2D)p1).getY()), this.content.getCoordinateReferenceSystem());
        }
        return aoi;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        try {
            ReferencedEnvelope rEnv = this.getDisplayArea();
            CoordinateReferenceSystem sourceCRS = rEnv.getCoordinateReferenceSystem();
            CoordinateReferenceSystem targetCRS = crs;
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            Envelope newJtsEnv = JTS.transform((Envelope)rEnv, (MathTransform)transform);
            ReferencedEnvelope newEnvelope = new ReferencedEnvelope(newJtsEnv, targetCRS);
            this.content.getViewport().setBounds(newEnvelope);
            this.fullExtent = null;
            this.doSetDisplayArea((org.opengis.geometry.Envelope)newEnvelope);
            this.getDisplayArea();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDisplayArea(org.opengis.geometry.Envelope envelope) {
        if (this.content != null) {
            if (this.curPaintArea == null || this.curPaintArea.isEmpty()) {
                return;
            }
            this.doSetDisplayArea(envelope);
            this.clearLabelCache = true;
            if (!this.isDisposed()) {
                this.redraw();
            }
        } else {
            throw new IllegalStateException("Map context must be set before setting the display area");
        }
    }

    private void doSetDisplayArea(org.opengis.geometry.Envelope envelope) {
        assert (this.content != null && this.curPaintArea != null && !this.curPaintArea.isEmpty());
        if (this.equalsFullExtent(envelope)) {
            this.setTransforms((org.opengis.geometry.Envelope)this.fullExtent, this.curPaintArea);
        } else {
            this.setTransforms(envelope, this.curPaintArea);
        }
        ReferencedEnvelope adjustedEnvelope = this.getDisplayArea();
        this.content.getViewport().setBounds(adjustedEnvelope);
        MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.DISPLAY_AREA_CHANGED);
        this.publishEvent(ev);
    }

    private boolean equalsFullExtent(org.opengis.geometry.Envelope envelope) {
        if (this.fullExtent == null || envelope == null) {
            return false;
        }
        double TOL = 1.0E-6 * (this.fullExtent.getWidth() + this.fullExtent.getHeight());
        boolean touch = false;
        if (Math.abs(envelope.getMinimum(0) - this.fullExtent.getMinimum(0)) < TOL) {
            touch = true;
        }
        if (Math.abs(envelope.getMaximum(0) - this.fullExtent.getMaximum(0)) < TOL && touch) {
            return true;
        }
        if (Math.abs(envelope.getMinimum(1) - this.fullExtent.getMinimum(1)) < TOL) {
            touch = true;
        }
        return Math.abs(envelope.getMaximum(1) - this.fullExtent.getMaximum(1)) < TOL && touch;
    }

    public void reset() {
        if (this.fullExtent == null) {
            this.setFullExtent();
        }
        try {
            this.fullExtent = new ReferencedEnvelope((org.opengis.geometry.Envelope)CRS.transform((org.opengis.geometry.Envelope)this.fullExtent, (CoordinateReferenceSystem)this.content.getCoordinateReferenceSystem()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDisplayArea((org.opengis.geometry.Envelope)this.fullExtent);
    }

    public void setRepaint(boolean repaint) {
        this.acceptRepaintRequests = repaint;
    }

    public boolean isAcceptingRepaints() {
        return this.acceptRepaintRequests;
    }

    public RenderedImage getBaseImage() {
        return this.baseImage;
    }

    public int getResizeDelay() {
        return this.resizingPaintDelay;
    }

    public void setResizeDelay(int delay) {
        this.resizingPaintDelay = delay < 0 ? 500 : delay;
    }

    public AffineTransform getScreenToWorldTransform() {
        if (this.screenToWorld != null) {
            return new AffineTransform(this.screenToWorld);
        }
        return null;
    }

    public AffineTransform getWorldToScreenTransform() {
        if (this.worldToScreen != null) {
            return new AffineTransform(this.worldToScreen);
        }
        return null;
    }

    public void moveImage(int dx, int dy) {
        this.imageOrigin.translate(dx, dy);
        this.redrawBaseImage = false;
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public void onRenderingCompleted() {
        if (this.clearLabelCache) {
            this.labelCache.clear();
        }
        this.clearLabelCache = false;
        MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.RENDERING_STOPPED);
        this.publishEvent(ev);
    }

    public void onRenderingCancelled() {
        MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.RENDERING_STOPPED);
        this.publishEvent(ev);
    }

    public void onRenderingFailed() {
        MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.RENDERING_STOPPED);
        this.publishEvent(ev);
    }

    public void onRenderingRejected() {
    }

    private void afterImageMove() {
        ReferencedEnvelope env = this.content.getViewport().getBounds();
        if (env == null) {
            return;
        }
        int dx = this.imageOrigin.x;
        int dy = this.imageOrigin.y;
        DirectPosition2D newPos = new DirectPosition2D((double)dx, (double)dy);
        this.screenToWorld.transform((Point2D)newPos, (Point2D)newPos);
        env.translate(env.getMinimum(0) - newPos.x, env.getMaximum(1) - newPos.y);
        this.doSetDisplayArea((org.opengis.geometry.Envelope)env);
        this.imageOrigin.setLocation(0, 0);
        this.redrawBaseImage = true;
    }

    @Override
    public void layerAdded(MapLayerListEvent event) {
        boolean firstLayer;
        Layer layer = event.getElement();
        if (this.layerTable != null) {
            this.layerTable.onAddLayer(layer);
        }
        layer.setSelected(true);
        this.redrawBaseImage = true;
        boolean atFullExtent = this.equalsFullExtent((org.opengis.geometry.Envelope)this.getDisplayArea());
        boolean bl = firstLayer = this.content.layers().size() == 1;
        if (firstLayer || atFullExtent) {
            this.reset();
            if (firstLayer) {
                this.setCrs(layer.getBounds().getCoordinateReferenceSystem());
                return;
            }
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    @Override
    public void layerRemoved(MapLayerListEvent event) {
        Layer layer = event.getElement();
        if (this.layerTable != null) {
            this.layerTable.onRemoveLayer(layer);
        }
        this.redrawBaseImage = true;
        if (this.content.layers().size() == 0) {
            this.clearFields();
        } else {
            this.setFullExtent();
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    @Override
    public void layerChanged(MapLayerListEvent event) {
        if (this.layerTable != null) {
            this.layerTable.repaint(event.getElement());
        }
        this.redrawBaseImage = true;
        int reason = event.getMapLayerEvent().getReason();
        if (reason == 3) {
            this.setFullExtent();
        }
        if (reason != 6 && !this.isDisposed()) {
            this.redraw();
        }
    }

    @Override
    public void layerMoved(MapLayerListEvent event) {
        this.redrawBaseImage = true;
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    @Override
    public void mapBoundsChanged(MapBoundsEvent event) {
        this.redrawBaseImage = true;
        int type = event.getType();
        if ((type & 2) != 0) {
            this.setFullExtent();
            this.reset();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setFullExtent() {
        if (this.content != null && this.content.layers().size() > 0) {
            try {
                this.fullExtent = this.content.getMaxBounds();
                if (this.fullExtent != null) return;
                this.fullExtent = this.worldEnvelope();
                return;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            this.fullExtent = null;
        }
    }

    private void setTransforms(org.opengis.geometry.Envelope envelope, org.eclipse.swt.graphics.Rectangle paintArea) {
        ReferencedEnvelope refEnv = null;
        refEnv = envelope != null ? new ReferencedEnvelope(envelope) : this.worldEnvelope();
        Rectangle awtPaintArea = Utils.toAwtRectangle(paintArea);
        double xscale = awtPaintArea.getWidth() / refEnv.getWidth();
        double yscale = awtPaintArea.getHeight() / refEnv.getHeight();
        double scale = Math.min(xscale, yscale);
        double xoff = refEnv.getMedian(0) * scale - awtPaintArea.getCenterX();
        double yoff = refEnv.getMedian(1) * scale + awtPaintArea.getCenterY();
        this.worldToScreen = new AffineTransform(scale, 0.0, 0.0, -scale, -xoff, yoff);
        try {
            this.screenToWorld = this.worldToScreen.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
    }

    private ReferencedEnvelope worldEnvelope() {
        return new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    private void publishEvent(MapPaneEvent ev) {
        for (MapPaneListener listener : this.listeners) {
            switch (ev.getType()) {
                case NEW_CONTEXT: {
                    listener.onNewContext(ev);
                    break;
                }
                case NEW_RENDERER: {
                    listener.onNewRenderer(ev);
                    break;
                }
                case PANE_RESIZED: {
                    listener.onResized(ev);
                    break;
                }
                case DISPLAY_AREA_CHANGED: {
                    listener.onDisplayAreaChanged(ev);
                    break;
                }
                case RENDERING_STARTED: {
                    listener.onRenderingStarted(ev);
                    break;
                }
                case RENDERING_STOPPED: {
                    listener.onRenderingStopped(ev);
                    break;
                }
                case RENDERING_PROGRESS: {
                    listener.onRenderingProgress(ev);
                }
            }
        }
    }

    private void clearFields() {
        this.fullExtent = null;
        this.worldToScreen = null;
        this.screenToWorld = null;
    }

    public org.eclipse.swt.graphics.Rectangle getVisibleRect() {
        return this.getClientArea();
    }

    public void setOverlay(Image overlayImage, ReferencedEnvelope overlayEnvelope, boolean overlayDoXor, boolean boundsChanged) {
        if (this.overlayImage != null) {
            this.overlayImage.dispose();
        }
        this.overlayImage = overlayImage;
        this.overlayEnvelope = overlayEnvelope;
        this.overlayDoXor = overlayDoXor;
        this.redrawBaseImage = boundsChanged || this.swtImage == null;
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public void setBaseImageAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void handleEvent(Event event) {
        this.curPaintArea = this.getVisibleRect();
        if (event.type == 3) {
            this.startX = event.x;
            this.startY = event.y;
            this.mouseDown = true;
        } else if (event.type == 4) {
            boolean mouseWasMoved;
            this.endX = event.x;
            this.endY = event.y;
            boolean bl = mouseWasMoved = this.startX != this.endX || this.startY != this.endY;
            if (this.toolCanMove && mouseWasMoved) {
                this.afterImageMove();
            }
            this.mouseDown = false;
            this.isDragging = false;
        } else if (event.type == 9 && this.acceptRepaintRequests) {
            MapPaneEvent ev;
            ReferencedEnvelope mapAOI;
            this.gc = event.gc;
            if (this.toolCanMove && this.isDragging) {
                if (this.gc != null && !this.gc.isDisposed() && this.swtImage != null) {
                    Image tmpImage = new Image((Device)this.getDisplay(), this.curPaintArea.width, this.curPaintArea.height);
                    GC tmpGc = new GC((Drawable)tmpImage);
                    tmpGc.setBackground(this.white);
                    tmpGc.fillRectangle(0, 0, this.curPaintArea.width, this.curPaintArea.height);
                    tmpGc.drawImage(this.swtImage, this.imageOrigin.x, this.imageOrigin.y);
                    this.gc.drawImage(tmpImage, 0, 0);
                    tmpImage.dispose();
                }
                return;
            }
            if (this.toolCanDraw && this.toolManager.getCursorTool().isDrawing() && this.isDragging) {
                if (this.swtImage != null) {
                    this.drawFinalImage(this.swtImage);
                }
                this.gc.setXORMode(true);
                Color fC = this.gc.getForeground();
                this.gc.setLineStyle(this.cursorToolLineStyle);
                this.gc.setLineWidth(this.cursorToolLineWidth);
                this.gc.setForeground(this.cursorToolColor);
                this.gc.drawRectangle(this.startX, this.startY, this.endX - this.startX, this.endY - this.startY);
                this.gc.setForeground(fC);
                this.gc.setXORMode(false);
                return;
            }
            if (!this.toolCanDraw && !this.toolCanMove && this.isDragging) {
                return;
            }
            if (this.curPaintArea == null || this.content == null || this.renderer == null) {
                return;
            }
            if (this.content.layers().size() == 0) {
                this.gc.setForeground(this.yellow);
                this.gc.fillRectangle(0, 0, this.curPaintArea.width + 1, this.curPaintArea.height + 1);
                if (this.overlayImage == null) {
                    return;
                }
            }
            if ((mapAOI = this.content.getViewport().getBounds()) == null) {
                return;
            }
            if (this.redrawBaseImage) {
                ev = new MapPaneEvent(this, MapPaneEvent.Type.RENDERING_STARTED);
                this.publishEvent(ev);
                this.baseImage = new BufferedImage(this.curPaintArea.width + 1, this.curPaintArea.height + 1, 2);
                Graphics2D g2d = this.baseImage.createGraphics();
                g2d.fillRect(0, 0, this.curPaintArea.width + 1, this.curPaintArea.height + 1);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle awtRectangle = Utils.toAwtRectangle(this.curPaintArea);
                this.renderer.paint(g2d, awtRectangle, mapAOI, this.getWorldToScreenTransform());
                if (this.swtImage != null && !this.swtImage.isDisposed()) {
                    this.swtImage.dispose();
                    this.swtImage = null;
                }
                this.swtImage = new Image((Device)this.getDisplay(), this.awtToSwt(this.baseImage, this.curPaintArea.width + 1, this.curPaintArea.height + 1));
            }
            if (this.swtImage != null) {
                this.drawFinalImage(this.swtImage);
            }
            ev = new MapPaneEvent(this, MapPaneEvent.Type.RENDERING_STOPPED);
            this.publishEvent(ev);
            this.clearLabelCache = true;
            this.onRenderingCompleted();
            this.redrawBaseImage = false;
        }
    }

    private void drawFinalImage(Image swtImage) {
        Display display = this.getDisplay();
        Image tmpImage = new Image((Device)display, this.curPaintArea.width, this.curPaintArea.height);
        GC tmpGc = new GC((Drawable)tmpImage);
        tmpGc.setBackground(this.white);
        tmpGc.fillRectangle(0, 0, this.curPaintArea.width, this.curPaintArea.height);
        if (swtImage != null) {
            tmpGc.setAlpha(this.alpha);
            tmpGc.drawImage(swtImage, this.imageOrigin.x, this.imageOrigin.y);
            tmpGc.setAlpha(255);
        }
        if (this.overlayImage != null) {
            this.doOverlayImage(tmpGc);
        }
        if (this.gc != null && !this.gc.isDisposed()) {
            this.gc.drawImage(tmpImage, this.imageOrigin.x, this.imageOrigin.y);
        }
        if (tmpImage != null && !tmpImage.isDisposed()) {
            tmpImage.dispose();
            tmpImage = null;
        }
        if (tmpGc != null && !tmpGc.isDisposed()) {
            tmpGc.dispose();
            tmpGc = null;
        }
    }

    private void doOverlayImage(GC gc) {
        Point2D.Double lowerLeft = new Point2D.Double(this.overlayEnvelope.getMinX(), this.overlayEnvelope.getMinY());
        this.worldToScreen.transform(lowerLeft, lowerLeft);
        Point2D.Double upperRight = new Point2D.Double(this.overlayEnvelope.getMaxX(), this.overlayEnvelope.getMaxY());
        this.worldToScreen.transform(upperRight, upperRight);
        org.eclipse.swt.graphics.Rectangle bounds = this.overlayImage.getBounds();
        if (this.overlayDoXor) {
            gc.setXORMode(true);
        }
        gc.drawImage(this.overlayImage, 0, 0, bounds.width, bounds.height, (int)((Point2D)lowerLeft).getX(), (int)((Point2D)upperRight).getY(), (int)(((Point2D)upperRight).getX() - ((Point2D)lowerLeft).getX()), (int)Math.abs(((Point2D)upperRight).getY() - ((Point2D)lowerLeft).getY()));
        if (this.overlayDoXor) {
            gc.setXORMode(false);
        }
    }

    private ImageData awtToSwt(BufferedImage bufferedImage, int width, int height) {
        int[] awtPixels = new int[width * height];
        ImageData swtImageData = new ImageData(width, height, 24, PALETTE_DATA);
        swtImageData.transparentPixel = 1193046;
        int step = swtImageData.depth / 8;
        byte[] data = swtImageData.data;
        bufferedImage.getRGB(0, 0, width, height, awtPixels, 0, width);
        for (int i = 0; i < height; ++i) {
            int idx = (0 + i) * swtImageData.bytesPerLine + 0 * step;
            for (int j = 0; j < width; ++j) {
                int rgb = awtPixels[j + i * width];
                for (int k = swtImageData.depth - 8; k >= 0; k -= 8) {
                    data[idx++] = (byte)(rgb >> k & 0xFF);
                }
            }
        }
        return swtImageData;
    }

    @Override
    public void layerPreDispose(MapLayerListEvent event) {
    }

    public Color getCursorToolColor() {
        return this.cursorToolColor;
    }

    public void setCursorToolColor(Color color) {
        this.cursorToolColor = color;
    }

    public int getCursorToolLineWidth() {
        return this.cursorToolLineWidth;
    }

    public void setCursorToolLineWidth(int lineWidth) {
        this.cursorToolLineWidth = lineWidth;
    }

    public int getCursorToolLineStyle() {
        return this.cursorToolLineStyle;
    }

    public void setCursorToolLineStyle(int lineStyle) {
        this.cursorToolLineStyle = lineStyle;
    }
}

