/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt;

import java.util.EnumSet;
import java.util.HashSet;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.swt.MapLayerComposite;
import org.geotools.swt.SwtMapPane;
import org.geotools.swt.action.InfoAction;
import org.geotools.swt.action.OpenGeotiffAction;
import org.geotools.swt.action.OpenShapefileAction;
import org.geotools.swt.action.PanAction;
import org.geotools.swt.action.ResetAction;
import org.geotools.swt.action.ZoomInAction;
import org.geotools.swt.action.ZoomOutAction;
import org.geotools.swt.utils.CrsStatusBarButton;
import org.geotools.swt.utils.StatusBarNotifier;

public class SwtMapFrame
extends ApplicationWindow {
    private SwtMapPane mapPane;
    private HashSet<Tool> toolSet;
    private final boolean showLayerTable;
    private final MapContent content;
    private final GTRenderer renderer;
    private InfoAction infoAction;
    private PanAction panAction;
    private ResetAction resetAction;
    private ZoomInAction zoominAction;
    private ZoomOutAction zoomoutAction;
    private OpenShapefileAction openShapeAction;
    private OpenGeotiffAction openCoverageAction;

    public static void showMap(MapContent content) {
        SwtMapFrame frame = new SwtMapFrame(true, true, true, true, content);
        frame.setBlockOnOpen(true);
        frame.open();
    }

    public SwtMapFrame(boolean showMenu, boolean showToolBar, boolean showStatusBar, boolean showLayerTable) {
        this(showMenu, showToolBar, showStatusBar, showLayerTable, null);
    }

    public SwtMapFrame(boolean showMenu, boolean showToolBar, boolean showStatusBar, boolean showLayerTable, MapContent content) {
        this(showMenu, showToolBar, showStatusBar, showLayerTable, content, new StreamingRenderer());
    }

    public SwtMapFrame(boolean showMenu, boolean showToolBar, boolean showStatusBar, boolean showLayerTable, MapContent content, GTRenderer renderer) {
        super(null);
        this.showLayerTable = showLayerTable;
        this.content = content;
        this.renderer = renderer;
        this.infoAction = new InfoAction();
        this.panAction = new PanAction();
        this.resetAction = new ResetAction();
        this.zoominAction = new ZoomInAction();
        this.zoomoutAction = new ZoomOutAction();
        this.openShapeAction = new OpenShapefileAction();
        this.openCoverageAction = new OpenGeotiffAction();
        this.toolSet = new HashSet();
        this.toolSet.addAll(EnumSet.allOf(Tool.class));
        if (showToolBar) {
            this.addToolBar(0x800040);
        }
        if (showStatusBar) {
            this.addStatusLine();
        }
        if (showMenu) {
            this.addMenuBar();
        }
    }

    public void enableTool(Tool ... tool) {
        for (Tool t : tool) {
            this.toolSet.add(t);
        }
    }

    protected Control createContents(Composite parent) {
        String title = this.content.getTitle();
        this.content.layers();
        if (title != null) {
            this.getShell().setText(title);
        }
        Composite mainComposite = null;
        if (this.showLayerTable) {
            SashForm sashForm = new SashForm(parent, 256);
            mainComposite = sashForm;
            MapLayerComposite mapLayerTable = new MapLayerComposite(mainComposite, 2048);
            this.mapPane = new SwtMapPane(mainComposite, 264192);
            this.mapPane.setMapContent(this.content);
            mapLayerTable.setMapPane(this.mapPane);
            sashForm.setWeights(new int[]{1, 3});
        } else {
            mainComposite = parent;
            this.mapPane = new SwtMapPane(mainComposite, 264192);
            this.mapPane.setMapContent(this.content);
        }
        this.mapPane.setBackground(Display.getCurrent().getSystemColor(1));
        this.mapPane.setRenderer(this.renderer);
        this.infoAction.setMapPane(this.mapPane);
        this.panAction.setMapPane(this.mapPane);
        this.resetAction.setMapPane(this.mapPane);
        this.zoominAction.setMapPane(this.mapPane);
        this.zoomoutAction.setMapPane(this.mapPane);
        this.openShapeAction.setMapPane(this.mapPane);
        this.openCoverageAction.setMapPane(this.mapPane);
        StatusLineManager statusLineManager = this.getStatusLineManager();
        if (statusLineManager != null) {
            ControlContribution filler = new ControlContribution("org.geotools.swt.SwtMapFrame.ID"){

                protected Control createControl(Composite parent) {
                    Label almostParent = new Label(parent, 0);
                    StatusLineLayoutData statusLineLayoutData = new StatusLineLayoutData();
                    statusLineLayoutData.widthHint = 1;
                    statusLineLayoutData.heightHint = 45;
                    almostParent.setLayoutData((Object)statusLineLayoutData);
                    return almostParent;
                }
            };
            CrsStatusBarButton crsButton = new CrsStatusBarButton(this.mapPane);
            statusLineManager.add((IContributionItem)filler);
            statusLineManager.add((IContributionItem)crsButton);
            statusLineManager.update(true);
            new StatusBarNotifier(this, this.mapPane);
        }
        return mainComposite;
    }

    protected ToolBarManager createToolBarManager(int style) {
        ToolBarManager tool_bar_manager = new ToolBarManager(style);
        tool_bar_manager.add((IAction)this.infoAction);
        tool_bar_manager.add((IAction)this.panAction);
        tool_bar_manager.add((IAction)this.resetAction);
        tool_bar_manager.add((IAction)this.zoominAction);
        tool_bar_manager.add((IAction)this.zoomoutAction);
        return tool_bar_manager;
    }

    protected MenuManager createMenuManager() {
        MenuManager bar_menu = new MenuManager("");
        MenuManager file_menu = new MenuManager("&File");
        file_menu.add((IAction)this.openShapeAction);
        file_menu.add((IAction)this.openCoverageAction);
        MenuManager navigation_menu = new MenuManager("&Navigation");
        bar_menu.add((IContributionItem)file_menu);
        bar_menu.add((IContributionItem)navigation_menu);
        navigation_menu.add((IAction)this.infoAction);
        navigation_menu.add((IAction)this.panAction);
        navigation_menu.add((IAction)this.resetAction);
        navigation_menu.add((IAction)this.zoominAction);
        navigation_menu.add((IAction)this.zoomoutAction);
        return bar_menu;
    }

    public MapContent getMapContent() {
        return this.mapPane.getMapContent();
    }

    public void setMapContent(MapContent content) {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        this.mapPane.setMapContent(content);
    }

    public GTRenderer getRenderer() {
        return this.mapPane.getRenderer();
    }

    public void setRenderer(GTRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("renderer must not be null");
        }
        this.mapPane.setRenderer(renderer);
    }

    public SwtMapPane getMapPane() {
        return this.mapPane;
    }

    public static enum Tool {
        NONE,
        INFO,
        PAN,
        RESET,
        ZOOM;

    }
}

