/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt;

import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.swt.SwtMapPane;
import org.geotools.swt.control.MaplayerTableViewer;
import org.geotools.swt.utils.ImageCache;
import org.geotools.swt.utils.Messages;

public class MapLayerComposite
extends Composite {
    private SwtMapPane pane;
    private MaplayerTableViewer mapLayerTableViewer;

    public MapLayerComposite(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public void setMapPane(SwtMapPane pane) {
        this.pane = pane;
        this.mapLayerTableViewer.clear();
        pane.setMapLayerTable(this);
        this.mapLayerTableViewer.setPane(pane);
        MapContent mapContent = pane.getMapContent();
        List<Layer> layers = mapContent.layers();
        for (Layer mapLayer : layers) {
            this.mapLayerTableViewer.addLayer(mapLayer);
        }
    }

    public void onAddLayer(Layer layer) {
        this.mapLayerTableViewer.addLayer(layer);
    }

    public void onRemoveLayer(Layer layer) {
        this.mapLayerTableViewer.removeLayer(layer);
    }

    public void repaint(Layer layer) {
        this.mapLayerTableViewer.refresh(layer, true);
    }

    private void init() {
        this.setLayout((Layout)new GridLayout(1, false));
        Group mapLayersGroup = new Group((Composite)this, 0);
        mapLayersGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        mapLayersGroup.setLayout((Layout)new GridLayout(1, false));
        mapLayersGroup.setText(Messages.getString("layers_list_title"));
        this.mapLayerTableViewer = new MaplayerTableViewer((Composite)mapLayersGroup, 67584);
        GridData listGD = new GridData(4, 4, true, true);
        this.mapLayerTableViewer.getTable().setLayoutData((Object)listGD);
        Composite buttonComposite = new Composite((Composite)mapLayersGroup, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        buttonComposite.setLayout((Layout)new GridLayout(5, true));
        Button removeLayerButton = new Button(buttonComposite, 8);
        removeLayerButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        removeLayerButton.setToolTipText(Messages.getString("remove_layer"));
        removeLayerButton.setImage(ImageCache.getInstance().getImage("/icons/remove_layer.gif"));
        removeLayerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Layer selectedMapLayer = MapLayerComposite.this.mapLayerTableViewer.getSelectedMapLayer();
                if (selectedMapLayer == null) {
                    return;
                }
                MapContent mapContext = MapLayerComposite.this.pane.getMapContent();
                mapContext.removeLayer(selectedMapLayer);
                MapLayerComposite.this.mapLayerTableViewer.selectionChanged(null);
            }
        });
        Button showLayersButton = new Button(buttonComposite, 8);
        showLayersButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        showLayersButton.setToolTipText(Messages.getString("show_all_layers"));
        showLayersButton.setImage(ImageCache.getInstance().getImage("/icons/checked.gif"));
        showLayersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapLayerComposite.this.onShowAllLayers();
            }
        });
        Button hideLayersButton = new Button(buttonComposite, 8);
        hideLayersButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        hideLayersButton.setToolTipText(Messages.getString("hide_all_layers"));
        hideLayersButton.setImage(ImageCache.getInstance().getImage("/icons/unchecked.gif"));
        hideLayersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapLayerComposite.this.onHideAllLayers();
            }
        });
        Button layerUpButton = new Button(buttonComposite, 8);
        layerUpButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        layerUpButton.setToolTipText(Messages.getString("layer_up"));
        layerUpButton.setImage(ImageCache.getInstance().getImage("/icons/up.gif"));
        layerUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapLayerComposite.this.moveLayer(-1);
            }
        });
        Button layerDownButton = new Button(buttonComposite, 8);
        layerDownButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        layerDownButton.setToolTipText(Messages.getString("layer_down"));
        layerDownButton.setImage(ImageCache.getInstance().getImage("/icons/down.gif"));
        layerDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapLayerComposite.this.moveLayer(1);
            }
        });
    }

    private void moveLayer(int delta) {
        Layer selectedMapLayer = this.mapLayerTableViewer.getSelectedMapLayer();
        if (selectedMapLayer == null) {
            return;
        }
        List<Layer> layersList = this.mapLayerTableViewer.getLayersList();
        MapContent mapContent = this.pane.getMapContent();
        int contextIndex = mapContent.layers().indexOf(selectedMapLayer);
        int viewerIndex = layersList.indexOf(selectedMapLayer);
        int newViewerIndex = viewerIndex + delta;
        if (newViewerIndex < 0 || newViewerIndex > layersList.size() - 1) {
            return;
        }
        int newContextIndex = contextIndex - delta;
        if (newContextIndex < 0 || newContextIndex > mapContent.layers().size() - 1) {
            return;
        }
        if (contextIndex != newContextIndex) {
            mapContent.moveLayer(contextIndex, newContextIndex);
            this.pane.redraw();
            Collections.swap(layersList, viewerIndex, newViewerIndex);
            this.mapLayerTableViewer.refresh();
        }
    }

    private void onShowAllLayers() {
        if (this.pane != null && this.pane.getMapContent() != null) {
            for (Layer layer : this.pane.getMapContent().layers()) {
                if (layer.isVisible()) continue;
                layer.setVisible(true);
            }
            this.mapLayerTableViewer.refresh();
            this.pane.redraw();
        }
    }

    private void onHideAllLayers() {
        if (this.pane != null && this.pane.getMapContent() != null) {
            for (Layer layer : this.pane.getMapContent().layers()) {
                if (!layer.isVisible()) continue;
                layer.setVisible(false);
            }
            this.mapLayerTableViewer.refresh();
            this.pane.redraw();
        }
    }
}

