/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.builder.AbstractStyleBuilder;
import org.geotools.styling.builder.StrokeBuilder;
import org.geotools.styling.builder.StyleBuilder;
import org.geotools.styling.builder.SymbolizerBuilder;
import org.opengis.filter.expression.Expression;

public class LineSymbolizerBuilder
extends SymbolizerBuilder<LineSymbolizer> {
    StrokeBuilder strokeBuilder = new StrokeBuilder(this);
    Expression geometry = null;
    Unit<Length> uom = null;

    public LineSymbolizerBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    LineSymbolizerBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public LineSymbolizerBuilder geometry(Expression geometry) {
        this.geometry = geometry;
        return this;
    }

    public LineSymbolizerBuilder geometry(String cqlExpression) {
        return this.geometry(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder stroke() {
        this.unset = false;
        return this.strokeBuilder;
    }

    public LineSymbolizerBuilder uom(Unit<Length> uom) {
        this.unset = false;
        this.uom = uom;
        return this;
    }

    @Override
    public LineSymbolizer build() {
        if (this.unset) {
            return null;
        }
        Stroke stroke = this.strokeBuilder.build();
        if (stroke == null) {
            stroke = Stroke.DEFAULT;
        }
        LineSymbolizer ls = this.sf.createLineSymbolizer(stroke, null);
        if (this.geometry != null) {
            ls.setGeometry(this.geometry);
        }
        if (this.uom != null) {
            ls.setUnitOfMeasure(this.uom);
        }
        ls.getOptions().putAll(this.options);
        if (this.parent == null) {
            this.reset();
        }
        return ls;
    }

    public LineSymbolizerBuilder reset() {
        this.strokeBuilder.reset();
        this.geometry = null;
        this.unset = false;
        this.uom = null;
        return this;
    }

    public LineSymbolizerBuilder reset(LineSymbolizer original) {
        if (original == null) {
            return this.unset();
        }
        this.geometry = original.getGeometry();
        this.strokeBuilder.reset(original.getStroke());
        this.uom = original.getUnitOfMeasure();
        return this;
    }

    public LineSymbolizerBuilder reset(org.opengis.style.LineSymbolizer original) {
        if (original instanceof LineSymbolizer) {
            return this.reset((LineSymbolizer)original);
        }
        if (original == null) {
            return this.unset();
        }
        this.geometry = this.property(original.getGeometryPropertyName());
        this.strokeBuilder.reset(original.getStroke());
        this.uom = original.getUnitOfMeasure();
        return this;
    }

    @Override
    public LineSymbolizerBuilder unset() {
        return (LineSymbolizerBuilder)super.unset();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().line().init(this);
    }
}

