/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.List;
import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterBuilder;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.Identifier;

public class AndBuilder<P>
implements Builder<And> {
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory2(null);
    protected P parent;
    protected List<FilterBuilder> list;
    private List<Identifier> ids = new ArrayList<Identifier>();

    public AndBuilder() {
        this.reset();
    }

    public AndBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    @Override
    public And build() {
        if (this.list == null) {
            return null;
        }
        ArrayList<Filter> filters = new ArrayList<Filter>(this.list.size());
        for (FilterBuilder build : this.list) {
            Filter filter = build.build();
            if (filter == null) continue;
            filters.add(filter);
        }
        if (this.parent == null) {
            this.list.clear();
        }
        return this.ff.and(filters);
    }

    public AndBuilder<P> fid(String fid) {
        this.ids.add((Identifier)this.ff.featureId(fid));
        return this;
    }

    public AndBuilder<P> and(Filter filter) {
        this.list.add(new FilterBuilder().reset(filter));
        return this;
    }

    public AndBuilder<P> fid(List<String> fids) {
        for (String fid : fids) {
            this.ids.add((Identifier)this.ff.featureId(fid));
        }
        return this;
    }

    public P end() {
        return this.parent;
    }

    @Override
    public AndBuilder<P> reset() {
        this.list = new ArrayList<FilterBuilder>();
        return this;
    }

    @Override
    public AndBuilder<P> reset(And filter) {
        if (filter == null) {
            return this.unset();
        }
        this.list = new ArrayList<FilterBuilder>();
        if (filter.getChildren() != null) {
            for (Filter child : filter.getChildren()) {
                this.list.add(new FilterBuilder().reset(child));
            }
        }
        return this;
    }

    @Override
    public AndBuilder<P> unset() {
        this.list = null;
        return this;
    }
}

