/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.util;

import it.geosolutions.util.Kdu_sysout_message;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageWriteParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import kdu_jni.KduException;
import kdu_jni.Kdu_global;
import kdu_jni.Kdu_message;
import kdu_jni.Kdu_message_formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KakaduUtilities {
    public static final double DOUBLE_TOLERANCE = 1.0E-6;
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.util");
    private static boolean available;
    private static boolean init;
    public static final double BIT_TO_BYTE_FACTOR = 0.125;

    private KakaduUtilities() {
    }

    public static int[] findOptimalResolutionInfo(int sourceDWTLevels, int newSubSamplingFactor) {
        int levels = sourceDWTLevels;
        int optimalSubSamplingFactor = 1;
        int discardLevels = 0;
        for (int level = 0; level < levels + 1; ++level) {
            if (optimalSubSamplingFactor < newSubSamplingFactor) {
                optimalSubSamplingFactor = 1 << level;
                continue;
            }
            if (optimalSubSamplingFactor > newSubSamplingFactor) {
                optimalSubSamplingFactor >>= 1;
                break;
            }
            if (optimalSubSamplingFactor == newSubSamplingFactor) break;
        }
        int decreasingSSF = optimalSubSamplingFactor;
        for (discardLevels = 0; discardLevels < levels && decreasingSSF > 1; decreasingSSF >>= 1, ++discardLevels) {
        }
        return new int[]{optimalSubSamplingFactor, discardLevels};
    }

    public static void initializeKakaduMessagesManagement() {
        try {
            Kdu_sysout_message sysout = new Kdu_sysout_message(false);
            Kdu_sysout_message syserr = new Kdu_sysout_message(true);
            Kdu_message_formatter pretty_sysout = new Kdu_message_formatter((Kdu_message)sysout);
            Kdu_message_formatter pretty_syserr = new Kdu_message_formatter((Kdu_message)syserr);
            Kdu_global.Kdu_customize_warnings((Kdu_message)pretty_sysout);
            Kdu_global.Kdu_customize_errors((Kdu_message)pretty_syserr);
        }
        catch (KduException e) {
            throw new RuntimeException("Error caused by a Kakadu exception during creation of key objects! ", e);
        }
    }

    public static List<ImageReaderWriterSpi> getJDKImageReaderWriterSPI(ServiceRegistry registry, String formatName, boolean isReader) {
        if (registry == null || !(registry instanceof IIORegistry)) {
            throw new IllegalArgumentException("Illegal registry provided");
        }
        IIORegistry iioRegistry = (IIORegistry)registry;
        Class spiClass = isReader ? ImageReaderSpi.class : ImageWriterSpi.class;
        Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, true);
        ArrayList<ImageReaderWriterSpi> list = new ArrayList<ImageReaderWriterSpi>();
        block0: while (iter.hasNext()) {
            ImageReaderWriterSpi provider = iter.next();
            String[] formatNames = provider.getFormatNames();
            for (int i = 0; i < formatNames.length; ++i) {
                if (!formatNames[i].equalsIgnoreCase(formatName)) continue;
                list.add(provider);
                continue block0;
            }
        }
        return list;
    }

    public static BufferedImage subsampleImage(ColorModel cm, BufferedImage bi, int destinationWidth, int destinationHeight, int interpolationType) {
        WritableRaster raster = cm.createCompatibleWritableRaster(destinationWidth, destinationHeight);
        BufferedImage finalImage = new BufferedImage(cm, raster, false, null);
        Graphics2D gc2D = finalImage.createGraphics();
        gc2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        gc2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        gc2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        gc2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolationType == 1 ? RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR : RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        gc2D.drawImage(bi, 0, 0, destinationWidth, destinationHeight, 0, 0, bi.getWidth(), bi.getHeight(), null);
        gc2D.dispose();
        bi.flush();
        bi = null;
        return finalImage;
    }

    public static boolean isKakaduAvailable() {
        KakaduUtilities.loadKakadu();
        return available;
    }

    public static synchronized void loadKakadu() {
        if (init) {
            return;
        }
        init = true;
        try {
            System.loadLibrary("kdu_jni");
            available = true;
        }
        catch (UnsatisfiedLinkError e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Failed to load the Kakadu native libs. This is not a problem unless you need to use the Kakadu plugin: it won't be enabled. " + e.toString());
            }
            available = false;
        }
    }

    public static void computeRegions(Rectangle sourceBounds, Dimension destSize, ImageWriteParam param) {
        int periodX = 1;
        int periodY = 1;
        if (param != null) {
            int[] sourceBands = param.getSourceBands();
            if (sourceBands != null && (sourceBands.length != 1 || sourceBands[0] != 0)) {
                throw new IllegalArgumentException("Cannot sub-band image!");
            }
            Rectangle sourceRegion = param.getSourceRegion();
            if (sourceRegion != null) {
                sourceRegion = sourceRegion.intersection(sourceBounds);
                sourceBounds.setBounds(sourceRegion);
            }
            periodX = param.getSourceXSubsampling();
            periodY = param.getSourceYSubsampling();
            int gridX = param.getSubsamplingXOffset();
            int gridY = param.getSubsamplingYOffset();
            sourceBounds.x += gridX;
            sourceBounds.y += gridY;
            sourceBounds.width -= gridX;
            sourceBounds.height -= gridY;
        }
        destSize.setSize((sourceBounds.width + periodX - 1) / periodX, (sourceBounds.height + periodY - 1) / periodY);
        if (destSize.width <= 0 || destSize.height <= 0) {
            throw new IllegalArgumentException("Empty source region!");
        }
    }

    public static boolean notEqual(double value, double reference) {
        return Math.abs(value - reference) > 1.0E-6;
    }

    static {
        init = false;
    }
}

