/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.DefaultJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.XMLBoxMetadataNode;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLBox
extends DefaultJP2KBox {
    private static final long serialVersionUID = -4532323245580784842L;
    public static final int BOX_TYPE = 2020437024;
    public static final String NAME = "xml ";
    public static final String JP2K_MD_NAME = "JP2KXMLBox";
    private static String[] elementNames = new String[]{"Content"};

    public static String[] getElementNames() {
        return elementNames;
    }

    public XMLBox(byte[] data) {
        super(8 + data.length, 2020437024, data);
    }

    public XMLBox(Node node) throws IIOInvalidTreeException {
        this(XMLBox.extractData(node));
    }

    private static byte[] extractData(Node node) {
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (!"Content".equals(name)) continue;
            String value = child.getNodeValue();
            if (value != null) {
                return value.getBytes();
            }
            if (!(child instanceof IIOMetadataNode) || (value = (String)((IIOMetadataNode)child).getUserObject()) == null) continue;
            return value.getBytes();
        }
        return null;
    }

    public IIOMetadataNode getNativeNode() {
        return new XMLBoxMetadataNode(this);
    }
}

