/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import it.geosolutions.imageio.plugins.jp2k.box.UUIDBoxMetadataNode;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UUIDBox
extends BaseJP2KBox {
    public static final int BOX_TYPE = 1970628964;
    public static final String NAME = "uuid";
    public static final String JP2K_MD_NAME = "JP2KUUIDBox";
    private static String[] elementNames = new String[]{"UUID", "Data"};
    private byte[] uuid;
    private byte[] udata;
    private byte[] localData;

    public static String[] getElementNames() {
        return elementNames;
    }

    public UUIDBox(byte[] data) {
        super(8 + data.length, 1970628964, data);
    }

    public UUIDBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("UUID".equals(name)) {
                this.uuid = BoxUtilities.getByteArrayElementValue(child);
            }
            if (!"Data".equals(name)) continue;
            this.udata = BoxUtilities.getByteArrayElementValue(child);
        }
    }

    protected void parse(byte[] data) {
        this.uuid = new byte[16];
        System.arraycopy(data, 0, this.uuid, 0, 16);
        this.udata = new byte[data.length - 16];
        System.arraycopy(data, 16, this.udata, 0, this.udata.length);
    }

    public byte[] getUUID() {
        return this.uuid;
    }

    public byte[] getData() {
        return this.udata;
    }

    public IIOMetadataNode getNativeNode() {
        return new UUIDBoxMetadataNode(this);
    }

    protected synchronized byte[] compose() {
        if (this.localData != null) {
            return this.localData;
        }
        this.localData = new byte[16 + this.udata.length];
        System.arraycopy(this.uuid, 0, this.localData, 0, 16);
        System.arraycopy(this.udata, 0, this.localData, 16, this.udata.length);
        return this.localData;
    }
}

