/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBox;
import javax.imageio.metadata.IIOInvalidTreeException;
import org.w3c.dom.Node;

public class ReaderRequirementsBox
extends BaseJP2KBox {
    public static final int BOX_TYPE = 1920099697;
    public static final String NAME = "rreq";
    public static final String JP2K_MD_NAME = "JP2KReaderRequirementsBox";
    private byte maskLength;
    private int numberOfStandardFlags;
    private int numberOfVendorFlags;
    private int[] standardFlags;
    private long[] standardMasks;
    private long fullyUnderstandAspectMask;
    private long decodeCompletelyMask;

    public ReaderRequirementsBox(int length, int type, byte[] data) {
        super(length, type, data);
    }

    public ReaderRequirementsBox(int length, int type, long extraLength, byte[] data) {
        super(length, type, extraLength, data);
    }

    public ReaderRequirementsBox(byte[] data) {
        super(8 + data.length, 1920099697, data);
    }

    public ReaderRequirementsBox(Node node) throws IIOInvalidTreeException {
        super(node);
    }

    protected byte[] compose() {
        return null;
    }

    protected void parse(byte[] data) {
        this.maskLength = data[0];
        int nsfIndex = 1 + this.maskLength * 2;
        this.numberOfStandardFlags = (data[nsfIndex] & 0xFF) << 8 | data[nsfIndex + 1] & 0xFF;
        this.standardFlags = new int[this.numberOfStandardFlags];
        this.standardMasks = new long[this.numberOfStandardFlags];
        switch (this.maskLength) {
            case 1: 
            case 2: {
                int i;
                this.fullyUnderstandAspectMask = (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                this.decodeCompletelyMask = (data[3] & 0xFF) << 8 | data[4] & 0xFF;
                nsfIndex += 2;
                for (i = 0; i < this.numberOfStandardFlags; ++i) {
                    this.standardFlags[i] = (data[nsfIndex + i * 2] & 0xFF) << 8 | data[nsfIndex + i * 2 + 1] & 0xFF;
                }
                nsfIndex += this.numberOfStandardFlags * 2;
                for (i = 0; i < this.numberOfStandardFlags; ++i) {
                    this.standardMasks[i] = (data[nsfIndex + i * 2] & 0xFF) << 8 | data[nsfIndex + i * 2 + 1] & 0xFF;
                }
                this.numberOfVendorFlags = (data[nsfIndex += this.numberOfStandardFlags * this.maskLength] & 0xFF) << 8 | data[nsfIndex + 1] & 0xFF;
                break;
            }
        }
    }
}

