/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import it.geosolutions.imageio.plugins.jp2k.box.ImageHeaderBoxMetadataNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.imageio.metadata.IIOMetadataNode;

public class ImageHeaderBox
extends BaseJP2KBox {
    public static final int BOX_TYPE = 1768449138;
    public static final String NAME = "ihdr";
    public static final String JP2K_MD_NAME = "JP2KImageHeaderBox";
    public static final int COMPRESSION_TYPE = 7;
    private static final List<String> elementNames = Collections.unmodifiableList(Arrays.asList("Height", "Width", "NumComponents", "BitDepth", "CompressionType", "UnknownColorspace", "IntellectualProperty"));
    private int width;
    private int height;
    private short numComp;
    private byte bitDepth;
    private byte bitDepthInterpretation;
    private byte compressionType;
    private byte unknownColor;
    private byte intelProp;
    private byte[] localData;

    public static String[] getElementNames() {
        return (String[])elementNames.toArray();
    }

    public ImageHeaderBox(int height, int width, int numComp, int bitDepth, int compressionType, int unknownColor, int intelProp) {
        super(22, 1768449138, null);
        this.height = height;
        this.width = width;
        this.numComp = (short)numComp;
        this.bitDepth = (byte)bitDepth;
        this.compressionType = (byte)compressionType;
        this.unknownColor = (byte)unknownColor;
        this.intelProp = (byte)intelProp;
    }

    public ImageHeaderBox(byte[] data) {
        super(8 + data.length, 1768449138, data);
    }

    protected void parse(byte[] data) {
        this.height = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        this.width = (data[4] & 0xFF) << 24 | (data[5] & 0xFF) << 16 | (data[6] & 0xFF) << 8 | data[7] & 0xFF;
        this.numComp = (short)((data[8] & 0xFF) << 8 | data[9] & 0xFF);
        this.bitDepth = data[10];
        this.bitDepthInterpretation = (byte)(1 + (this.bitDepth & 0x7F));
        this.compressionType = data[11];
        if (this.compressionType != 7) {
            throw new IllegalArgumentException("Illegal value for compression type.");
        }
        this.unknownColor = data[12];
        this.intelProp = data[13];
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public short getNumComponents() {
        return this.numComp;
    }

    public byte getCompressionType() {
        return this.compressionType;
    }

    public byte getBitDepth() {
        return this.bitDepth;
    }

    public byte getUnknownColorspace() {
        return this.unknownColor;
    }

    public byte getIntellectualProperty() {
        return this.intelProp;
    }

    public IIOMetadataNode getNativeNode() {
        return new ImageHeaderBoxMetadataNode(this);
    }

    protected synchronized byte[] compose() {
        if (this.localData != null) {
            return this.localData;
        }
        this.localData = new byte[14];
        BoxUtilities.copyInt(this.localData, 0, this.height);
        BoxUtilities.copyInt(this.localData, 4, this.width);
        this.localData[8] = (byte)(this.numComp >> 8);
        this.localData[9] = (byte)(this.numComp & 0xFF);
        this.localData[10] = this.bitDepth;
        this.localData[11] = this.compressionType;
        this.localData[12] = this.unknownColor;
        this.localData[13] = this.intelProp;
        return this.localData;
    }

    public int getLength() {
        return 22;
    }

    public void setLength(int length) {
        if (length != 22) {
            throw new IllegalArgumentException("length for the ImageHeader JP2 box is fixed at 22");
        }
        super.setLength(length);
    }

    public byte getBitDepthInterpretation() {
        return this.bitDepthInterpretation;
    }
}

