/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import it.geosolutions.imageio.plugins.jp2k.box.FileTypeBoxMetadataNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.imageio.metadata.IIOMetadataNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTypeBox
extends BaseJP2KBox {
    private static final int TYPE_JP2 = 1785737760;
    private static final int TYPE_JPX = 1785755680;
    private static final int TYPE_JPXB = 1785755746;
    public static final int BOX_TYPE = 1718909296;
    public static final String NAME = "ftyp";
    public static final String JP2K_MD_NAME = "JP2KFileTypeBox";
    private static final List<String> elementNames = Collections.unmodifiableList(Arrays.asList("Brand", "MinorVersion", "CompatibilitySet"));
    private JPEG2000FileType brand;
    private int minorVersion;
    private Set<JPEG2000FileType> compatibility;
    private byte[] localData;

    public static String[] getElementNames() {
        return (String[])elementNames.toArray();
    }

    public FileTypeBox(int br, int minorVersion, int[] comp) {
        super(16 + (comp == null ? 0 : comp.length << 2), 1718909296, null);
        this.brand = JPEG2000FileType.valueOf(br);
        this.minorVersion = minorVersion;
        for (int c : comp) {
            this.compatibility.add(JPEG2000FileType.valueOf(c));
        }
    }

    public FileTypeBox(byte[] data) {
        super(8 + data.length, 1718909296, data);
    }

    public JPEG2000FileType getBrand() {
        return this.brand;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public Set<JPEG2000FileType> getCompatibilitySet() {
        return new HashSet<JPEG2000FileType>(this.compatibility);
    }

    public boolean isCompatibleWith(JPEG2000FileType c) {
        return this.compatibility.contains((Object)c);
    }

    @Override
    public IIOMetadataNode getNativeNode() {
        return new FileTypeBoxMetadataNode(this);
    }

    @Override
    protected synchronized void parse(byte[] data) {
        if (data == null) {
            return;
        }
        this.compatibility = new HashSet<JPEG2000FileType>();
        this.brand = JPEG2000FileType.valueOf((data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF);
        this.minorVersion = (data[4] & 0xFF) << 24 | (data[5] & 0xFF) << 16 | (data[6] & 0xFF) << 8 | data[7] & 0xFF;
        int len = (data.length - 8) / 4;
        if (len > 0) {
            int i = 0;
            int j = 8;
            while (i < len) {
                this.compatibility.add(JPEG2000FileType.valueOf((data[j] & 0xFF) << 24 | (data[j + 1] & 0xFF) << 16 | (data[j + 2] & 0xFF) << 8 | data[j + 3] & 0xFF));
                ++i;
                j += 4;
            }
        }
    }

    @Override
    protected byte[] compose() {
        assert (Thread.holdsLock(this));
        if (this.localData != null) {
            return this.localData;
        }
        this.localData = new byte[8 + (this.compatibility != null ? this.compatibility.size() << 2 : 0)];
        BoxUtilities.copyInt(this.localData, 0, this.brand.toInt());
        BoxUtilities.copyInt(this.localData, 4, this.minorVersion);
        int i = 0;
        for (JPEG2000FileType c : this.compatibility) {
            this.localData[i++] = (byte)(c.toInt() & 0xFF);
        }
        return this.localData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JPEG2000FileType {
        JP2,
        JPX,
        JPXB,
        UNSPECIFIED;


        public static JPEG2000FileType valueOf(int compatibility) {
            switch (compatibility) {
                case 1785737760: {
                    return JP2;
                }
                case 1785755680: {
                    return JPX;
                }
                case 1785755746: {
                    return JPXB;
                }
            }
            return UNSPECIFIED;
        }

        public int toInt() {
            switch (this) {
                case JP2: {
                    return 1785737760;
                }
                case JPX: {
                    return 1785755680;
                }
                case JPXB: {
                    return 1785755746;
                }
            }
            return -1;
        }
    }
}

