/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataEntryURLBox
extends BaseJP2KBox {
    public static final int BOX_TYPE = 1970433056;
    public static final String NAME = "url ";
    public static final String JP2K_MD_NAME = "JP2KDataEntryURLBox";
    private static String[] elementNames = new String[]{"Version", "Flags", "URL"};
    private byte version;
    private byte[] flags;
    private String url;
    private byte[] localData;

    public static String[] getElementNames() {
        return elementNames;
    }

    public DataEntryURLBox(byte[] data) {
        super(8 + data.length, 1970433056, data);
    }

    public DataEntryURLBox(byte version, byte[] flags, String url) {
        super(12 + url.length(), 1970433056, null);
        this.version = version;
        this.flags = flags;
        this.url = url;
    }

    public DataEntryURLBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("Version".equals(name)) {
                this.version = BoxUtilities.getByteElementValue(child);
            }
            if ("Flags".equals(name)) {
                this.flags = BoxUtilities.getByteArrayElementValue(child);
            }
            if (!"URL".equals(name)) continue;
            this.url = BoxUtilities.getStringElementValue(child);
        }
    }

    protected void parse(byte[] data) {
        this.version = data[0];
        this.flags = new byte[3];
        this.flags[0] = data[1];
        this.flags[1] = data[2];
        this.flags[2] = data[3];
        this.url = new String(data, 4, data.length - 4);
    }

    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    public byte getVersion() {
        return this.version;
    }

    public byte[] getFlags() {
        return this.flags;
    }

    public String getURL() {
        return this.url;
    }

    protected byte[] compose() {
        if (this.localData != null) {
            return this.localData;
        }
        this.localData = new byte[4 + this.url.length()];
        this.localData[0] = this.version;
        this.localData[1] = this.flags[0];
        this.localData[2] = this.flags[1];
        this.localData[3] = this.flags[2];
        System.arraycopy(this.url.getBytes(), 0, this.localData, 4, this.url.length());
        return this.localData;
    }
}

