/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import it.geosolutions.imageio.plugins.jp2k.box.ComponentMappingBoxMetadataNode;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentMappingBox
extends BaseJP2KBox {
    public static final int BOX_TYPE = 1668112752;
    public static final String NAME = "cmap";
    public static final String JP2K_MD_NAME = "JP2KComponentMappingBox";
    private short[] components;
    private byte[] type;
    private byte[] map;
    private byte[] localData;

    public ComponentMappingBox(byte[] data) {
        super(8 + data.length, 1668112752, data);
    }

    public ComponentMappingBox(short[] comp, byte[] t, byte[] m) {
        super(8 + (comp.length << 2), 1668112752, null);
        this.components = comp;
        this.type = t;
        this.map = m;
    }

    public ComponentMappingBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList children = node.getChildNodes();
        int len = children.getLength() / 3;
        this.components = new short[len];
        this.type = new byte[len];
        this.map = new byte[len];
        len *= 3;
        int index = 0;
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("Component".equals(name)) {
                this.components[index] = BoxUtilities.getShortElementValue(child);
            }
            if ("ComponentType".equals(name)) {
                this.type[index] = BoxUtilities.getByteElementValue(child);
            }
            if (!"ComponentAssociation".equals(name)) continue;
            this.map[index++] = BoxUtilities.getByteElementValue(child);
        }
    }

    protected void parse(byte[] data) {
        int len = data.length / 4;
        this.components = new short[len];
        this.type = new byte[len];
        this.map = new byte[len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            this.components[i] = (short)((data[j++] & 0xFF) << 8 | data[j++] & 0xFF);
            this.type[i] = data[j++];
            this.map[i] = data[j++];
        }
    }

    public IIOMetadataNode getNativeNode() {
        return new ComponentMappingBoxMetadataNode(this);
    }

    public short[] getComponent() {
        return this.components;
    }

    public byte[] getComponentType() {
        return this.type;
    }

    public byte[] getComponentAssociation() {
        return this.map;
    }

    protected synchronized byte[] compose() {
        if (this.localData != null) {
            return this.localData;
        }
        this.localData = new byte[this.type.length << 2];
        int j = 0;
        for (int i = 0; i < this.type.length; ++i) {
            this.localData[j++] = (byte)(this.components[i] >> 8);
            this.localData[j++] = (byte)(this.components[i] & 0xFF);
            this.localData[j++] = this.type[i];
            this.localData[j++] = this.map[i];
        }
        return this.localData;
    }
}

