/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import java.awt.color.ICC_Profile;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ColorSpecificationBox
extends BaseJP2KBox {
    public static final int BOX_TYPE = 1668246642;
    public static final String NAME = "colr";
    public static final String JP2K_MD_NAME = "JP2KColourSpecificationBox";
    public static final int ECS_sRGB = 16;
    public static final int ECS_GRAY = 17;
    public static final int ECS_YCC = 18;
    private static String[] elementNames = new String[]{"Method", "Precedence", "ApproximationAccuracy", "EnumeratedColorSpace", "ICCProfile"};
    private byte method;
    private byte precedence;
    private byte approximation;
    private int ecs;
    private ICC_Profile profile;
    private byte[] localData;

    public static String[] getElementNames() {
        return elementNames;
    }

    private static int computeLength(byte m, ICC_Profile profile) {
        int ret = 15;
        if (m == 2 && profile != null) {
            ret += profile.getData().length;
        }
        return ret;
    }

    public ColorSpecificationBox(byte m, byte p, byte a, int ecs, ICC_Profile profile) {
        super(ColorSpecificationBox.computeLength(m, profile), 1668246642, null);
        this.method = m;
        this.precedence = p;
        this.approximation = a;
        this.ecs = ecs;
        this.profile = profile;
    }

    public ColorSpecificationBox(byte[] data) {
        super(8 + data.length, 1668246642, data);
    }

    public ColorSpecificationBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("Method".equals(name)) {
                this.method = BoxUtilities.getByteElementValue(child);
            }
            if ("Precedence".equals(name)) {
                this.precedence = BoxUtilities.getByteElementValue(child);
            }
            if ("ApproximationAccuracy".equals(name)) {
                this.approximation = BoxUtilities.getByteElementValue(child);
            }
            if ("EnumeratedColorSpace".equals(name)) {
                this.ecs = BoxUtilities.getIntElementValue(child);
            }
            if (!"ICCProfile".equals(name)) continue;
            if (child instanceof IIOMetadataNode) {
                this.profile = (ICC_Profile)((IIOMetadataNode)child).getUserObject();
                continue;
            }
            String value = node.getNodeValue();
            if (value == null) continue;
            this.profile = ICC_Profile.getInstance(BoxUtilities.parseByteArray(value));
        }
    }

    public byte getMethod() {
        return this.method;
    }

    public byte getPrecedence() {
        return this.precedence;
    }

    public byte getApproximationAccuracy() {
        return this.approximation;
    }

    public int getEnumeratedColorSpace() {
        return this.ecs;
    }

    public ICC_Profile getICCProfile() {
        return this.profile;
    }

    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    protected void parse(byte[] data) {
        this.method = data[0];
        this.precedence = data[1];
        this.approximation = data[2];
        if (this.method == 2) {
            byte[] proData = new byte[data.length - 3];
            System.arraycopy(data, 3, proData, 0, data.length - 3);
            this.profile = ICC_Profile.getInstance(proData);
        } else {
            this.ecs = (data[3] & 0xFF) << 24 | (data[4] & 0xFF) << 16 | (data[5] & 0xFF) << 8 | data[6] & 0xFF;
        }
    }

    protected synchronized byte[] compose() {
        if (this.localData != null) {
            return this.localData;
        }
        int len = 7;
        byte[] profileData = null;
        if (this.profile != null) {
            profileData = this.profile.getData();
            len += profileData.length;
        }
        this.localData = new byte[len];
        this.localData[0] = this.method;
        this.localData[1] = this.precedence;
        this.localData[2] = this.approximation;
        BoxUtilities.copyInt(this.localData, 3, this.ecs);
        if (this.profile != null) {
            System.arraycopy(profileData, 0, this.localData, 7, len - 7);
        }
        return this.localData;
    }
}

