/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import com.sun.media.imageioimpl.common.ImageUtil;
import it.geosolutions.imageio.plugins.jp2k.JP2KBoxMetadata;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import java.lang.reflect.Method;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseJP2KBox
extends DefaultMutableTreeNode
implements JP2KBoxMetadata {
    private byte[] data;
    private long extraLength;
    private int length;
    private int type;

    public BaseJP2KBox(int length, int type, byte[] data) {
        this.type = type;
        this.setLength(length);
        this.setContent(data);
    }

    public BaseJP2KBox(int length, int type, long extraLength, byte[] data) {
        this.type = type;
        this.setLength(length);
        this.setContent(data);
    }

    public BaseJP2KBox(Node node) throws IIOInvalidTreeException {
        NodeList children = node.getChildNodes();
        String value = (String)BoxUtilities.getAttribute(node, "Type");
        this.type = BoxUtilities.getTypeInt(value);
        if (value == null || BoxUtilities.names.get(new Integer(this.type)) == null) {
            throw new IIOInvalidTreeException("Type is not defined", node);
        }
        value = (String)BoxUtilities.getAttribute(node, "Length");
        if (value != null) {
            this.length = new Integer(value);
        }
        if ((value = (String)BoxUtilities.getAttribute(node, "ExtraLength")) != null) {
            this.extraLength = new Long(value);
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"Content".equals(child.getNodeName())) continue;
            if (child instanceof IIOMetadataNode) {
                IIOMetadataNode cnode = (IIOMetadataNode)child;
                try {
                    this.data = (byte[])cnode.getUserObject();
                }
                catch (Exception e) {}
            } else {
                this.data = BoxUtilities.getByteArrayElementValue(child);
            }
            if (this.data != null || (value = node.getNodeValue()) == null) continue;
            this.data = value.getBytes();
        }
    }

    protected IIOMetadataNode getNativeNodeForSimpleBox() {
        try {
            Method m = this.getClass().getMethod("getElementNames", null);
            String[] elementNames = (String[])m.invoke(null, (Object[])null);
            IIOMetadataNode node = new IIOMetadataNode(BoxUtilities.getName(this.getType()));
            this.setDefaultAttributes(node);
            for (int i = 0; i < elementNames.length; ++i) {
                IIOMetadataNode child = new IIOMetadataNode(elementNames[i]);
                m = this.getClass().getMethod("get" + elementNames[i], null);
                Object obj = m.invoke((Object)this, (Object[])null);
                child.setUserObject(obj);
                child.setNodeValue(ImageUtil.convertObjectToString((Object)obj));
                node.appendChild(child);
            }
            return node;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Box0");
        }
    }

    public synchronized byte[] getContent() {
        if (this.data == null) {
            this.data = this.compose();
        }
        return this.data;
    }

    private void setContent(byte[] data) {
        if (data != null && (this.length == 1 && this.extraLength - 16L != (long)data.length || this.length != 1 && this.length - 8 != data.length)) {
            throw new IllegalArgumentException("Box2");
        }
        this.data = data;
        if (data != null) {
            this.parse(data);
        }
    }

    protected abstract void parse(byte[] var1);

    protected abstract byte[] compose();

    public IIOMetadataNode getNativeNode() {
        String name = BoxUtilities.getName(this.getType());
        if (name == null) {
            name = "unknown";
        }
        IIOMetadataNode node = new IIOMetadataNode(name);
        this.setDefaultAttributes(node);
        IIOMetadataNode child = new IIOMetadataNode("Content");
        child.setUserObject(this.data);
        child.setNodeValue(ImageUtil.convertObjectToString((Object)this.data));
        node.appendChild(child);
        return node;
    }

    public long getExtraLength() {
        return this.extraLength;
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    protected void setDefaultAttributes(IIOMetadataNode node) {
        node.setAttribute("Length", Integer.toString(this.length));
        node.setAttribute("Type", BoxUtilities.getTypeString(this.type));
        if (this.length == 1) {
            node.setAttribute("ExtraLength", Long.toString(this.extraLength));
        }
    }

    public void setExtraLength(long extraLength) {
        if (this.length != 1) {
            throw new IllegalArgumentException("Box1");
        }
        this.extraLength = extraLength;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String toString() {
        String superString = super.toString();
        StringBuilder builder = new StringBuilder(superString != null ? superString : "");
        builder.append("\n");
        builder.append("type:").append(this.type).append("\n");
        builder.append("box class:").append(BoxUtilities.getBoxClass(this.type)).append("\n");
        builder.append("type hex:").append(Integer.toHexString(this.type).toUpperCase()).append("\n");
        builder.append("box name:").append(BoxUtilities.getBoxName(this.type)).append("\n");
        builder.append("length:").append(this.length).append("\n");
        builder.append("extralength:").append(this.extraLength).append("\n");
        return builder.toString();
    }

    public Object clone() {
        return BoxUtilities.createBox(this.type, this.data);
    }
}

