/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k;

import it.geosolutions.imageio.plugins.jp2k.JP2KBox;
import it.geosolutions.imageio.plugins.jp2k.JP2KBoxMetadata;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.tree.DefaultMutableTreeNode;
import kdu_jni.Jp2_family_src;
import kdu_jni.Jp2_input_box;
import kdu_jni.Jp2_locator;
import kdu_jni.KduException;

class LazyJP2KBox
extends DefaultMutableTreeNode
implements JP2KBoxMetadata {
    private static final long serialVersionUID = -3905954214836933636L;
    private static final Logger LOGGER = Logger.getLogger("LazyJP2Box");
    private final Jp2_locator locator;
    private int type;
    private SoftReference<? extends JP2KBox> boxRef;
    private String filename;

    public String toString() {
        String superString = super.toString();
        StringBuilder builder = new StringBuilder(superString != null ? superString : "");
        builder.append("\n");
        builder.append("type:").append(this.type).append("\n");
        builder.append("box class:").append(BoxUtilities.getBoxClass(this.type)).append("\n");
        builder.append("type hex:").append(Integer.toHexString(this.type).toUpperCase()).append("\n");
        builder.append("box name:").append(BoxUtilities.getBoxName(this.type)).append("\n");
        return builder.toString();
    }

    LazyJP2KBox(String filename, int type, Jp2_locator locator) {
        this.filename = filename;
        this.locator = locator;
        this.type = type;
    }

    public byte[] getContent() {
        if (!this.isLeaf()) {
            return null;
        }
        if (BoxUtilities.SUPERBOX_NAMES.contains(BoxUtilities.getTypeString(this.type))) {
            return null;
        }
        JP2KBox originalBox = this.loadBox();
        return originalBox.getContent();
    }

    private synchronized JP2KBox loadBox() {
        JP2KBox retVal;
        JP2KBox jP2KBox = retVal = this.boxRef == null ? null : this.boxRef.get();
        if (retVal == null) {
            Jp2_family_src familySource = new Jp2_family_src();
            Jp2_input_box box = new Jp2_input_box();
            try {
                familySource.Open(this.filename);
                box.Open(familySource, this.locator);
                retVal = BoxUtilities.createBox(this.type, BoxUtilities.getContent(box));
                this.boxRef = new SoftReference<JP2KBox>(retVal);
            }
            catch (KduException e) {
                throw new RuntimeException("Error caused by a Kakadu exception during Box management! ", e);
            }
            finally {
                block17: {
                    block16: {
                        try {
                            familySource.Close();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block16;
                            LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    try {
                        if (box != null) {
                            box.Close();
                        }
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block17;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        return retVal;
    }

    public long getExtraLength() {
        JP2KBox originalBox = this.loadBox();
        return originalBox.getExtraLength();
    }

    public int getLength() {
        JP2KBox originalBox = this.loadBox();
        return originalBox.getLength();
    }

    public int getType() {
        return this.type;
    }

    JP2KBox getOriginalBox() {
        return this.loadBox();
    }

    public IIOMetadataNode getNativeNode() {
        return ((JP2KBoxMetadata)this.getOriginalBox()).getNativeNode();
    }

    static JP2KBox getAsOriginalBox(JP2KBox box) {
        JP2KBox returnedBox = null;
        if (box instanceof LazyJP2KBox) {
            returnedBox = ((LazyJP2KBox)box).getOriginalBox();
        } else if (box instanceof JP2KBox) {
            returnedBox = box;
        } else {
            throw new IllegalArgumentException("Not a valid JP2Box");
        }
        return returnedBox;
    }

    public Object clone() {
        Jp2_locator locator = new Jp2_locator();
        try {
            long filePos = this.locator.Get_file_pos();
            locator.Set_file_pos(filePos);
            return new LazyJP2KBox(this.filename, this.type, locator);
        }
        catch (KduException e) {
            throw new RuntimeException("Error caused by a Kakadu exception during Box management! ", e);
        }
    }
}

