/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k;

import it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageWriteParam;
import it.geosolutions.imageio.stream.output.FileImageOutputStreamExt;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.util.KakaduUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import kdu_jni.Jp2_channels;
import kdu_jni.Jp2_colour;
import kdu_jni.Jp2_dimensions;
import kdu_jni.Jp2_family_tgt;
import kdu_jni.Jp2_palette;
import kdu_jni.Jp2_target;
import kdu_jni.KduException;
import kdu_jni.Kdu_codestream;
import kdu_jni.Kdu_compressed_target;
import kdu_jni.Kdu_params;
import kdu_jni.Kdu_simple_file_target;
import kdu_jni.Kdu_stripe_compressor;
import kdu_jni.Siz_params;

public class JP2KKakaduImageWriter
extends ImageWriter {
    private static final short[] GEOJP2_UUID;
    private static final int[] POWERS_2;
    private static final Logger LOGGER;
    public static final String MAX_BUFFER_SIZE_KEY = "it.geosolutions.maxBufferSize";
    public static final String TEMP_BUFFER_SIZE_KEY = "it.geosolutions.tempBufferSize";
    public static final String ADD_COMMENT_MARKER_KEY = "it.geosolutions.addCommentMarker";
    private static final int DEFAULT_MAX_BUFFER_SIZE = 0x2000000;
    private static final int DEFAULT_TEMP_BUFFER_SIZE = 65536;
    private static final boolean ADD_COMMENT_MARKER;
    private static int TEMP_BUFFER_SIZE;
    private static final int MAX_BUFFER_SIZE;
    private static final int MIN_BUFFER_SIZE = 0x100000;
    private ImageOutputStream outputStream = null;
    private static final double SINGLE_PUSH_THRESHOLD_RATIO = 0.95;
    private File outputFile;

    public ImageWriteParam getDefaultWriteParam() {
        return new JP2KKakaduImageWriteParam();
    }

    private static int parseSize(String sizeValue) {
        int size = 0;
        int length = sizeValue.length();
        String value = sizeValue.substring(0, length - 1);
        String suffix = sizeValue.substring(length - 1, length);
        if (suffix.equalsIgnoreCase("M") || suffix.equalsIgnoreCase("K")) {
            try {
                int val = Integer.parseInt(value);
                val = suffix.equalsIgnoreCase("M") ? (val *= 0x100000) : (val *= 1024);
                size = val;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return size;
    }

    public JP2KKakaduImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public void setOutput(Object output) {
        super.setOutput(output);
        if (output instanceof File) {
            this.outputFile = (File)output;
        } else if (output instanceof FileImageOutputStreamExt) {
            this.outputFile = ((FileImageOutputStreamExt)output).getFile();
        } else if (output instanceof URL) {
            URL tempURL = (URL)output;
            if (tempURL.getProtocol().equalsIgnoreCase("file")) {
                this.outputFile = ImageIOUtilities.urlToFile((URL)tempURL);
            }
        } else if (output instanceof ImageOutputStream) {
            try {
                this.outputStream = (ImageOutputStream)output;
                this.outputFile = File.createTempFile("buffer", ".j2c");
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create a temp file", e);
            }
        }
    }

    /*
     * Loose catch block
     */
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        block69: {
            Jp2_family_tgt familyTarget;
            Jp2_target target;
            Kdu_simple_file_target outputTarget;
            boolean writeCodeStreamOnly;
            block68: {
                block63: {
                    boolean cycc;
                    boolean orgGen_plt;
                    int cLevels;
                    double quality;
                    String fileName = this.outputFile.getAbsolutePath();
                    int cLayers = 1;
                    byte[] geoJp2 = null;
                    int orgGen_tlm = -1;
                    int qGuard = -1;
                    String orgT_parts = null;
                    String cPrecincts = null;
                    boolean setTiling = false;
                    int tileW = Integer.MIN_VALUE;
                    int tileH = Integer.MIN_VALUE;
                    JP2KKakaduImageWriteParam.ProgressionOrder cOrder = null;
                    double[] bitRates = null;
                    boolean addCommentMarker = ADD_COMMENT_MARKER;
                    int sProfile = 2;
                    JP2KKakaduImageWriteParam.Compression compression = JP2KKakaduImageWriteParam.Compression.UNDEFINED;
                    if (param == null) {
                        param = this.getDefaultWriteParam();
                    }
                    if (param instanceof JP2KKakaduImageWriteParam) {
                        JP2KKakaduImageWriteParam jp2Kparam = (JP2KKakaduImageWriteParam)param;
                        writeCodeStreamOnly = jp2Kparam.isWriteCodeStreamOnly();
                        bitRates = jp2Kparam.getQualityLayersBitRates();
                        double q = jp2Kparam.getQuality();
                        if (q < 0.01) {
                            q = 0.01;
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Quality level should be in the range 0.01 - 1. /n Reassigning it to 0.01");
                            }
                        }
                        quality = q;
                        geoJp2 = jp2Kparam.getGeoJp2();
                        boolean bl = setTiling = jp2Kparam.getTilingMode() == 2;
                        if (setTiling) {
                            tileH = jp2Kparam.getTileHeight();
                            tileW = jp2Kparam.getTileWidth();
                        }
                        cOrder = jp2Kparam.getcOrder();
                        cPrecincts = jp2Kparam.getcPrecincts();
                        cLevels = jp2Kparam.getCLevels();
                        cLayers = jp2Kparam.getQualityLayers();
                        orgGen_plt = jp2Kparam.isOrgGen_plt();
                        orgGen_tlm = jp2Kparam.getOrgGen_tlm();
                        orgT_parts = jp2Kparam.getOrgT_parts();
                        qGuard = jp2Kparam.getqGuard();
                        addCommentMarker &= jp2Kparam.isAddCommentMarker();
                        sProfile = jp2Kparam.getsProfile();
                        compression = jp2Kparam.getCompression();
                        if (bitRates != null && bitRates.length != cLayers) {
                            throw new IllegalArgumentException(" Specified bitRates parameter's length " + bitRates.length + " should match the quality layers parameter " + "(cLayers): " + cLayers);
                        }
                        if (compression != null) {
                            switch (compression) {
                                case LOSSY: {
                                    if (bitRates != null) {
                                        if (!LOGGER.isLoggable(Level.FINE)) break;
                                        LOGGER.fine("Applying lossy compression leveraging on provided quality bit rates");
                                        break;
                                    }
                                    if (!LOGGER.isLoggable(Level.FINE)) break;
                                    LOGGER.fine("Applying lossy compression leveraging on quality factor");
                                    break;
                                }
                                case NUMERICALLY_LOSSLESS: {
                                    if (bitRates != null) {
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.fine("Applying numerically lossless compression leveraging on provided quality bit rates");
                                        }
                                        if (!KakaduUtilities.notEqual(bitRates[bitRates.length - 1], 0.0)) break;
                                        throw new IllegalArgumentException("Asking for a Numerically Lossless but the last quality layer's bit rate should be 0  instead of " + bitRates[bitRates.length - 1]);
                                    }
                                    if (!LOGGER.isLoggable(Level.FINE)) break;
                                    LOGGER.fine("Applying numerically lossless compression");
                                }
                            }
                        } else {
                            compression = JP2KKakaduImageWriteParam.Compression.UNDEFINED;
                        }
                    } else {
                        orgGen_plt = false;
                        writeCodeStreamOnly = true;
                        quality = 1.0;
                        cLevels = 5;
                    }
                    RenderedImage inputRenderedImage = image.getRenderedImage();
                    int sourceWidth = inputRenderedImage.getWidth();
                    int sourceHeight = inputRenderedImage.getHeight();
                    int sourceMinX = inputRenderedImage.getMinX();
                    int sourceMinY = inputRenderedImage.getMinY();
                    SampleModel sm = inputRenderedImage.getSampleModel();
                    int dataType = sm.getDataType();
                    boolean isDataSigned = dataType != 1 && dataType != 0;
                    ColorModel colorModel = inputRenderedImage.getColorModel();
                    boolean hasPalette = colorModel instanceof IndexColorModel;
                    int[] numberOfBits = colorModel.getComponentSize();
                    int bytesOverHead = 0;
                    int bits = numberOfBits[0];
                    int nComponents = sm.getNumBands();
                    byte[] reds = null;
                    byte[] greens = null;
                    byte[] blues = null;
                    if (hasPalette) {
                        cycc = false;
                        cLevels = 1;
                        IndexColorModel icm = (IndexColorModel)colorModel;
                        int lutSize = icm.getMapSize();
                        int numColorComponents = colorModel.getNumColorComponents();
                        if (writeCodeStreamOnly) {
                            nComponents = numColorComponents;
                            reds = new byte[lutSize];
                            blues = new byte[lutSize];
                            greens = new byte[lutSize];
                            icm.getReds(reds);
                            icm.getGreens(greens);
                            icm.getBlues(blues);
                        } else {
                            bytesOverHead += 6 + numColorComponents + 1;
                            bytesOverHead += lutSize * numColorComponents + 4;
                            bytesOverHead += 20;
                        }
                    } else {
                        cycc = quality != 1.0;
                    }
                    int xSubsamplingFactor = param.getSourceXSubsampling();
                    int ySubsamplingFactor = param.getSourceYSubsampling();
                    Rectangle originalBounds = new Rectangle(sourceMinX, sourceMinY, sourceWidth, sourceHeight);
                    Rectangle imageBounds = (Rectangle)originalBounds.clone();
                    Dimension destSize = new Dimension();
                    KakaduUtilities.computeRegions(imageBounds, destSize, param);
                    boolean resampleInputImage = false;
                    if (xSubsamplingFactor != 1 || ySubsamplingFactor != 1 || !imageBounds.equals(originalBounds)) {
                        resampleInputImage = true;
                    }
                    int destinationWidth = destSize.width;
                    int destinationHeight = destSize.height;
                    int rowSize = destinationWidth * nComponents;
                    int bandSize = destinationHeight * destinationWidth;
                    int imageSize = bandSize * nComponents;
                    outputTarget = null;
                    target = null;
                    familyTarget = null;
                    cLevels = this.setDecompositionLevels(cLevels, destinationWidth);
                    if (writeCodeStreamOnly) {
                        outputTarget = new Kdu_simple_file_target();
                        outputTarget.Open(fileName);
                        int extensionIndex = fileName.lastIndexOf(".");
                        String suffix = fileName.substring(extensionIndex, fileName.length());
                        if (suffix.equalsIgnoreCase(".jp2") && LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("When writing codestreams, the \".j2c\" file suffix is suggested instead of \".jp2\"");
                        }
                    } else {
                        familyTarget = new Jp2_family_tgt();
                        familyTarget.Open(fileName);
                        target = new Jp2_target();
                        target.Open(familyTarget);
                        bytesOverHead += 84;
                        if (geoJp2 != null) {
                            bytesOverHead += geoJp2.length;
                        }
                    }
                    if ((bytesOverHead += this.addMarkerBytes(nComponents, destinationWidth, destinationHeight, tileW, tileH, orgGen_tlm, addCommentMarker)) >= imageSize) {
                        bytesOverHead = 0;
                    }
                    long qualityLayersSize = bitRates != null ? (long)imageSize : (long)((double)(imageSize - bytesOverHead) * quality * (double)bits * 0.125);
                    Kdu_codestream codeStream = new Kdu_codestream();
                    Siz_params params = new Siz_params();
                    this.initializeParams(params, destinationWidth, destinationHeight, bits, nComponents, isDataSigned, tileW, tileH, sProfile);
                    if (writeCodeStreamOnly) {
                        codeStream.Create(params, (Kdu_compressed_target)outputTarget, null);
                    } else {
                        codeStream.Create(params, (Kdu_compressed_target)target, null);
                    }
                    if (!this.initializeCodestream(codeStream, cycc, cLevels, quality, cLayers, colorModel, writeCodeStreamOnly, dataType, target, geoJp2, orgGen_plt, orgGen_tlm, orgT_parts, qGuard, cOrder, cPrecincts, compression)) {
                        throw new IOException("Unable to initialize the codestream due to a missing Jp2_target object");
                    }
                    Kdu_stripe_compressor compressor = new Kdu_stripe_compressor();
                    int[] stripeHeights = new int[nComponents];
                    int[] sampleGaps = new int[nComponents];
                    int[] rowGaps = new int[nComponents];
                    int[] sampleOffsets = new int[nComponents];
                    int[] precisions = new int[nComponents];
                    this.initializeStripeCompressor(compressor, codeStream, quality, cLayers, qualityLayersSize, bitRates, compression, rowSize, destinationHeight, destinationWidth, nComponents, stripeHeights, sampleGaps, rowGaps, sampleOffsets, precisions, numberOfBits, addCommentMarker);
                    this.pushStripes(compressor, inputRenderedImage, imageBounds, originalBounds, isDataSigned, resampleInputImage, writeCodeStreamOnly, hasPalette, nComponents, bits, destinationWidth, destinationHeight, xSubsamplingFactor, ySubsamplingFactor, stripeHeights, sampleGaps, rowGaps, sampleOffsets, precisions, reds, greens, blues);
                    compressor.Finish();
                    compressor.Native_destroy();
                    codeStream.Destroy();
                    Object var68_71 = null;
                    if (writeCodeStreamOnly || target == null) break block63;
                    try {
                        if (target.Exists()) {
                            target.Close();
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        target.Native_destroy();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (familyTarget != null) {
                        try {
                            if (familyTarget.Exists()) {
                                familyTarget.Close();
                            }
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        try {
                            familyTarget.Native_destroy();
                        }
                        catch (Throwable e) {}
                    }
                    break block68;
                }
                if (writeCodeStreamOnly && outputTarget != null) {
                    try {
                        outputTarget.Close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        outputTarget.Native_destroy();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            if (this.outputStream != null) {
                this.writeOnStream();
            }
            break block69;
            {
                catch (KduException e) {
                    throw (IOException)new IOException("Error caused by a Kakadu exception during write operation").initCause(e);
                }
            }
            catch (Throwable throwable) {
                Object var68_72 = null;
                if (!writeCodeStreamOnly && target != null) {
                    try {
                        if (target.Exists()) {
                            target.Close();
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        target.Native_destroy();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (familyTarget != null) {
                        try {
                            if (familyTarget.Exists()) {
                                familyTarget.Close();
                            }
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        try {
                            familyTarget.Native_destroy();
                        }
                        catch (Throwable e) {}
                    }
                } else if (writeCodeStreamOnly && outputTarget != null) {
                    try {
                        outputTarget.Close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        outputTarget.Native_destroy();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (this.outputStream != null) {
                    this.writeOnStream();
                }
                throw throwable;
            }
        }
    }

    private void writeOnStream() throws IOException {
        FileInputStream fis = new FileInputStream(this.outputFile);
        byte[] buff = new byte[TEMP_BUFFER_SIZE];
        int bytesRead = 0;
        while ((bytesRead = fis.read(buff)) != -1) {
            this.outputStream.write(buff, 0, bytesRead);
        }
        this.outputStream.close();
        fis.close();
        this.outputFile.delete();
    }

    private void pushStripes(Kdu_stripe_compressor compressor, RenderedImage inputRenderedImage, Rectangle imageBounds, Rectangle originalBounds, boolean isDataSigned, boolean resampleInputImage, boolean writeCodeStreamOnly, boolean hasPalette, int nComponents, int bits, int destinationWidth, int destinationHeight, int xSubsamplingFactor, int ySubsamplingFactor, int[] stripeHeights, int[] sampleGaps, int[] rowGaps, int[] sampleOffsets, int[] precisions, byte[] reds, byte[] greens, byte[] blues) throws KduException {
        boolean goOn = true;
        int rowSize = destinationWidth * nComponents;
        int stripeSize = rowSize * stripeHeights[0];
        if (bits <= 8) {
            byte[] bufferValues = new byte[stripeSize];
            int y = 0;
            if (!resampleInputImage) {
                Raster rasterData = null;
                while (goOn) {
                    if (destinationHeight - y < stripeHeights[0]) {
                        for (int i = 0; i < nComponents; ++i) {
                            stripeHeights[i] = destinationHeight - y;
                        }
                        bufferValues = new byte[rowSize * stripeHeights[0]];
                    }
                    rasterData = inputRenderedImage.getData(new Rectangle(0, y, destinationWidth, stripeHeights[0]));
                    if (hasPalette && writeCodeStreamOnly) {
                        DataBuffer buff = rasterData.getDataBuffer();
                        int loopLength = buff.getSize();
                        for (int l = 0; l < loopLength; ++l) {
                            int pixel = buff.getElem(l);
                            bufferValues[l * 3] = reds[pixel];
                            bufferValues[l * 3 + 1] = greens[pixel];
                            bufferValues[l * 3 + 2] = blues[pixel];
                        }
                    } else {
                        rasterData.getDataElements(0, y, destinationWidth, stripeHeights[0], bufferValues);
                    }
                    goOn = compressor.Push_stripe(bufferValues, stripeHeights, sampleOffsets, sampleGaps, rowGaps, precisions, 0);
                    y += stripeHeights[0];
                    rasterData = null;
                }
            } else {
                int lastY = imageBounds.y;
                int lastX = imageBounds.x + imageBounds.width;
                ByteBuffer buffer = ByteBuffer.allocate(stripeSize);
                while (goOn) {
                    if (destinationHeight - y < stripeHeights[0]) {
                        for (int i = 0; i < nComponents; ++i) {
                            stripeHeights[i] = destinationHeight - y;
                        }
                        buffer = ByteBuffer.allocate(rowSize * stripeHeights[0]);
                    }
                    Rectangle rect = new Rectangle(imageBounds.x, lastY, imageBounds.width, stripeHeights[0] * ySubsamplingFactor);
                    rect = rect.intersection(originalBounds);
                    Raster rasterData = inputRenderedImage.getData(rect);
                    lastY = rect.y + rect.height;
                    this.readSubSampled(rect, originalBounds, lastX, lastY, xSubsamplingFactor, ySubsamplingFactor, rasterData, buffer, nComponents);
                    ByteBuffer data = buffer;
                    if (hasPalette && writeCodeStreamOnly) {
                        ByteBuffer bb = ByteBuffer.allocate(rowSize * stripeHeights[0]);
                        bufferValues = bb.array();
                        int loopLength = buffer.capacity();
                        for (int l = 0; l < loopLength; ++l) {
                            byte pixel = buffer.get();
                            bufferValues[l * 3] = reds[pixel];
                            bufferValues[l * 3 + 1] = greens[pixel];
                            bufferValues[l * 3 + 2] = blues[pixel];
                        }
                        data = bb;
                    }
                    goOn = compressor.Push_stripe(data.array(), stripeHeights, sampleOffsets, sampleGaps, rowGaps, precisions, 0);
                    y += stripeHeights[0];
                    buffer.clear();
                    data = null;
                    rasterData = null;
                }
            }
            bufferValues = null;
        } else if (bits > 8 && bits <= 16) {
            boolean[] isSigned = new boolean[nComponents];
            for (int i = 0; i < isSigned.length; ++i) {
                isSigned[i] = isDataSigned;
            }
            short[] bufferValues = new short[stripeSize];
            int y = 0;
            if (!resampleInputImage) {
                while (goOn) {
                    if (destinationHeight - y < stripeHeights[0]) {
                        for (int i = 0; i < nComponents; ++i) {
                            stripeHeights[i] = destinationHeight - y;
                        }
                        bufferValues = new short[rowSize * stripeHeights[0]];
                    }
                    Raster rasterData = inputRenderedImage.getData(new Rectangle(0, y, destinationWidth, stripeHeights[0]));
                    rasterData.getDataElements(0, y, destinationWidth, stripeHeights[0], bufferValues);
                    goOn = compressor.Push_stripe(bufferValues, stripeHeights, sampleOffsets, sampleGaps, rowGaps, precisions, isSigned, 0);
                    y += stripeHeights[0];
                    rasterData = null;
                }
            } else {
                int lastX = imageBounds.x + imageBounds.width;
                int lastY = imageBounds.y;
                ShortBuffer buffer = ShortBuffer.allocate(stripeSize);
                while (goOn) {
                    if (destinationHeight - y < stripeHeights[0]) {
                        for (int i = 0; i < nComponents; ++i) {
                            stripeHeights[i] = destinationHeight - y;
                        }
                        buffer = ShortBuffer.allocate(rowSize * stripeHeights[0]);
                    }
                    Rectangle rect = new Rectangle(imageBounds.x, lastY, imageBounds.width, stripeHeights[0] * ySubsamplingFactor);
                    rect = rect.intersection(originalBounds);
                    Raster rasterData = inputRenderedImage.getData(rect);
                    lastY = rect.y + rect.height;
                    this.readSubSampled(rect, originalBounds, lastX, lastY, xSubsamplingFactor, ySubsamplingFactor, rasterData, buffer, nComponents);
                    goOn = compressor.Push_stripe(buffer.array(), stripeHeights, sampleOffsets, sampleGaps, rowGaps, precisions, isSigned, 0);
                    y += stripeHeights[0];
                    buffer.clear();
                    rasterData = null;
                }
            }
            bufferValues = null;
        } else if (bits > 16 && bits <= 32) {
            int[] bufferValues = new int[stripeSize];
            int y = 0;
            while (goOn) {
                if (!resampleInputImage) {
                    if (destinationHeight - y < stripeHeights[0]) {
                        for (int i = 0; i < nComponents; ++i) {
                            stripeHeights[i] = destinationHeight - y;
                        }
                        bufferValues = new int[rowSize * stripeHeights[0]];
                    }
                    Raster rasterData = inputRenderedImage.getData(new Rectangle(0, y, destinationWidth, stripeHeights[0]));
                    rasterData.getDataElements(0, y, destinationWidth, stripeHeights[0], bufferValues);
                    goOn = compressor.Push_stripe(bufferValues, stripeHeights, sampleOffsets, sampleGaps, rowGaps, precisions);
                    y += stripeHeights[0];
                    rasterData = null;
                } else {
                    int lastY = imageBounds.y;
                    int lastX = imageBounds.x + imageBounds.width;
                    IntBuffer buffer = IntBuffer.allocate(stripeSize);
                    while (goOn) {
                        if (destinationHeight - y < stripeHeights[0]) {
                            for (int i = 0; i < nComponents; ++i) {
                                stripeHeights[i] = destinationHeight - y;
                            }
                            buffer = IntBuffer.allocate(rowSize * stripeHeights[0]);
                        }
                        Rectangle rect = new Rectangle(imageBounds.x, lastY, imageBounds.width, stripeHeights[0] * ySubsamplingFactor);
                        rect = rect.intersection(originalBounds);
                        Raster rasterData = inputRenderedImage.getData(rect);
                        lastY = rect.y + rect.height;
                        this.readSubSampled(rect, originalBounds, lastX, lastY, xSubsamplingFactor, ySubsamplingFactor, rasterData, buffer, nComponents);
                        goOn = compressor.Push_stripe(buffer.array(), stripeHeights, sampleOffsets, sampleGaps, rowGaps, precisions);
                        y += stripeHeights[0];
                        buffer.clear();
                        rasterData = null;
                    }
                }
                bufferValues = null;
            }
        }
    }

    private int setDecompositionLevels(int cLevels, int destinationWidth) {
        int power = POWERS_2[cLevels];
        int levels = cLevels;
        if ((double)destinationWidth / (double)power < 20.0) {
            double division;
            int i;
            for (i = 0; i < POWERS_2.length && !((division = (double)destinationWidth / (double)POWERS_2[i]) < 20.0); ++i) {
            }
            levels = i > 1 ? i - 1 : 1;
        }
        return levels;
    }

    private int addMarkerBytes(int components, int destinationWidth, int destinationHeight, int tileW, int tileH, int orgGen_tlm, boolean addComment) {
        int bytesOverhead = 0;
        int siz_size = 38 + components * 3 + 2;
        bytesOverhead += 2 + siz_size + 14 + 40 + (addComment ? 108 : 17) + 12 + 2 + 2;
        if (tileW != Integer.MIN_VALUE && tileH != Integer.MIN_VALUE && tileW != 0 && tileH != 0 && orgGen_tlm != -1) {
            int nTileX = (int)Math.ceil((double)destinationWidth / (double)tileW);
            int nTileY = (int)Math.ceil((double)destinationHeight / (double)tileH);
            int overhead_TLM = nTileX * nTileY * 6;
            bytesOverhead += overhead_TLM + 8;
        }
        return bytesOverhead;
    }

    private boolean initializeCodestream(Kdu_codestream codeStream, boolean ycc, int cLevels, double quality, int qualityLayers, ColorModel colorModel, boolean writeCodeStreamOnly, int dataType, Jp2_target target, byte[] geoJp2, boolean orgGen_plt, int orgGen_tlm, String orgT_parts, int qGuard, JP2KKakaduImageWriteParam.ProgressionOrder cOrder, String cPrecincts, JP2KKakaduImageWriteParam.Compression compression) throws KduException {
        Siz_params params = codeStream.Access_siz();
        if (compression != null && compression == JP2KKakaduImageWriteParam.Compression.LOSSY) {
            params.Parse_string("Creversible=no");
        } else if (quality == 1.0 || colorModel instanceof IndexColorModel) {
            params.Parse_string("Creversible=yes");
        } else {
            params.Parse_string("Creversible=no");
        }
        if (cPrecincts != null && cPrecincts.trim().length() > 0) {
            params.Parse_string("Cuse_precincts=yes");
            params.Parse_string("Cprecincts=" + cPrecincts);
        }
        params.Parse_string("Cycc=" + (ycc ? "yes" : "no"));
        params.Parse_string("Clevels=" + cLevels);
        params.Parse_string("Clayers=" + qualityLayers);
        if (dataType == 2 || dataType == 1) {
            params.Parse_string("Qstep=0.0000152588");
        }
        if (qGuard > 0) {
            params.Parse_string("Qguard=" + qGuard);
        }
        Kdu_params org = params.Access_cluster("ORG");
        if (orgGen_plt) {
            org.Set("ORGgen_plt", 0, 0, true);
        }
        if (orgGen_tlm != -1) {
            org.Set("ORGgen_tlm", 0, 0, orgGen_tlm);
        }
        if (orgT_parts != null && orgT_parts.length() > 0) {
            org.Parse_string("ORGt_parts=" + orgT_parts);
        }
        Kdu_params cod = params.Access_cluster("COD");
        if (cOrder != null) {
            cod.Set("Corder", 0, 0, cOrder.getValue());
        }
        params.Finalize_all();
        if (!writeCodeStreamOnly) {
            if (target == null) {
                return false;
            }
            this.initializeHeader(target, params, colorModel);
            if (geoJp2 != null && geoJp2.length > 0) {
                target.Open_next(1970628964L);
                byte[] outByte = new byte[GEOJP2_UUID.length];
                for (int i = 0; i < GEOJP2_UUID.length; ++i) {
                    outByte[i] = (byte)GEOJP2_UUID[i];
                }
                target.Write(outByte, GEOJP2_UUID.length);
                target.Write(geoJp2, geoJp2.length);
                target.Close();
            }
            target.Open_codestream();
        }
        return true;
    }

    private void initializeStripeCompressor(Kdu_stripe_compressor compressor, Kdu_codestream codeStream, double quality, int qualityLayers, long qualityLayersSize, double[] bitRates, JP2KKakaduImageWriteParam.Compression compression, int rowSize, int destinationHeight, int destinationWidth, int nComponents, int[] stripeHeights, int[] sampleGaps, int[] rowGaps, int[] sampleOffsets, int[] precisions, int[] numberOfBits, boolean addCommentMarker) throws KduException {
        Object cumulativeQualityLayerSizes;
        switch (compression) {
            case LOSSY: {
                cumulativeQualityLayerSizes = this.computeQualityLayers(qualityLayers, qualityLayersSize, bitRates);
                break;
            }
            default: {
                cumulativeQualityLayerSizes = KakaduUtilities.notEqual(quality, 1.0) || bitRates != null ? this.computeQualityLayers(qualityLayers, qualityLayersSize, bitRates) : null;
            }
        }
        int maxStripeHeight = MAX_BUFFER_SIZE / rowSize;
        if (maxStripeHeight > destinationHeight) {
            maxStripeHeight = destinationHeight;
        } else {
            double ratio = (double)maxStripeHeight / (double)destinationHeight;
            if (ratio > 0.95) {
                maxStripeHeight = destinationHeight;
            }
        }
        int minStripeHeight = 0x100000 / rowSize;
        if (minStripeHeight < 1) {
            minStripeHeight = 1;
        } else if (minStripeHeight > destinationHeight) {
            minStripeHeight = destinationHeight;
        }
        for (int component = 0; component < nComponents; ++component) {
            stripeHeights[component] = maxStripeHeight;
            sampleGaps[component] = nComponents;
            rowGaps[component] = destinationWidth * nComponents;
            sampleOffsets[component] = component;
            precisions[component] = numberOfBits[component];
        }
        compressor.Start(codeStream, qualityLayers, cumulativeQualityLayerSizes, null, 0, false, false, addCommentMarker, 0.0, nComponents, false);
        boolean useRecommendations = compressor.Get_recommended_stripe_heights(minStripeHeight, maxStripeHeight, stripeHeights, null);
        if (!useRecommendations) {
            for (int i = 0; i < nComponents; ++i) {
                stripeHeights[i] = maxStripeHeight;
            }
        }
    }

    private long[] computeQualityLayers(int qualityLayers, long referenceSize, double[] bitRates) {
        long[] cumulativeQualityLayerSizes = new long[qualityLayers];
        if (bitRates != null) {
            for (int i = 0; i < qualityLayers; ++i) {
                cumulativeQualityLayerSizes[i] = (long)Math.floor(bitRates[i] * 0.125 * (double)referenceSize);
            }
        } else if (qualityLayers > 1) {
            long[] qualityLayerSizes = new long[qualityLayers];
            int[] multipliers = new int[qualityLayers];
            int multi = 1;
            int totals = 0;
            for (int i = 0; i < qualityLayers; ++i) {
                multi = i != 0 ? multi * 2 : multi;
                totals += multi;
                multipliers[i] = multi;
            }
            double qualityStep = Math.floor(referenceSize) / (double)totals;
            for (int i = 0; i < qualityLayers - 1; ++i) {
                long step = i != 0 ? qualityLayerSizes[i - 1] : 0L;
                qualityLayerSizes[i] = (long)Math.floor(qualityStep * (double)multipliers[i]);
                cumulativeQualityLayerSizes[i] = qualityLayerSizes[i] + step;
            }
            cumulativeQualityLayerSizes[qualityLayers - 1] = referenceSize;
        } else {
            cumulativeQualityLayerSizes[0] = referenceSize;
        }
        return cumulativeQualityLayerSizes;
    }

    private void initializeHeader(Jp2_target target, Siz_params sizParams, ColorModel colorModel) throws KduException {
        Jp2_dimensions dims = target.Access_dimensions();
        dims.Init(sizParams);
        Jp2_colour colour = target.Access_colour();
        int cs = colorModel.getColorSpace().getType();
        if (cs == 5) {
            colour.Init(16);
        } else if (cs == 6) {
            colour.Init(17);
        }
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)colorModel;
            int bitDepth = icm.getComponentSize(0);
            int lutSize = icm.getMapSize();
            int[] reds = new int[lutSize];
            int[] blues = new int[lutSize];
            int[] greens = new int[lutSize];
            for (int i = 0; i < lutSize; ++i) {
                reds[i] = icm.getRed(i);
                greens[i] = icm.getGreen(i);
                blues[i] = icm.getBlue(i);
            }
            Jp2_palette palette = target.Access_palette();
            palette.Init(3, lutSize);
            palette.Set_lut(0, reds, bitDepth, false);
            palette.Set_lut(1, greens, bitDepth, false);
            palette.Set_lut(2, blues, bitDepth, false);
            Jp2_channels channels = target.Access_channels();
            channels.Init(3);
            channels.Set_colour_mapping(0, 0, 0);
            channels.Set_colour_mapping(1, 0, 1);
            channels.Set_colour_mapping(2, 0, 2);
        }
        target.Write_header();
    }

    private void readSubSampled(Rectangle region, Rectangle originalBounds, int lastX, int lastY, int xSubsamplingFactor, int ySubsamplingFactor, Raster rasterData, Buffer dataBuffer, int nComponents) {
        if (dataBuffer instanceof ByteBuffer) {
            byte[] data = new byte[nComponents];
            ByteBuffer buffer = (ByteBuffer)dataBuffer;
            for (int j = region.y; j < lastY; ++j) {
                if ((j - originalBounds.y) % ySubsamplingFactor != 0) continue;
                for (int i = region.x; i < lastX; ++i) {
                    if ((i - originalBounds.x) % xSubsamplingFactor != 0) continue;
                    rasterData.getDataElements(i, j, data);
                    buffer.put(data, 0, nComponents);
                }
            }
        } else if (dataBuffer instanceof ShortBuffer) {
            short[] data = new short[nComponents];
            ShortBuffer buffer = (ShortBuffer)dataBuffer;
            for (int j = region.y; j < lastY; ++j) {
                if ((j - originalBounds.y) % ySubsamplingFactor != 0) continue;
                for (int i = region.x; i < lastX; ++i) {
                    if ((i - originalBounds.x) % xSubsamplingFactor != 0) continue;
                    rasterData.getDataElements(i, j, data);
                    buffer.put(data, 0, nComponents);
                }
            }
        } else if (dataBuffer instanceof IntBuffer) {
            IntBuffer buffer = (IntBuffer)dataBuffer;
            int[] data = new int[nComponents];
            for (int j = region.y; j < lastY; ++j) {
                if ((j - originalBounds.y) % ySubsamplingFactor != 0) continue;
                for (int i = region.x; i < lastX; ++i) {
                    if ((i - originalBounds.x) % xSubsamplingFactor != 0) continue;
                    rasterData.getDataElements(i, j, data);
                    buffer.put(data, 0, nComponents);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported buffer type");
        }
    }

    private void initializeParams(Siz_params params, int width, int height, int precision, int components, boolean isSigned, int tileW, int tileH, int sProfile) throws KduException {
        params.Set("Ssize", 0, 0, height);
        params.Set("Ssize", 0, 1, width);
        params.Set("Sprofile", 0, 0, sProfile);
        params.Set("Sorigin", 0, 0, 0);
        params.Set("Sorigin", 0, 1, 0);
        params.Set("Scomponents", 0, 0, components);
        params.Set("Sprecision", 0, 0, precision);
        params.Set("Sdims", 0, 0, height);
        params.Set("Sdims", 0, 1, width);
        params.Set("Ssigned", 0, 0, isSigned);
        if (tileH != Integer.MIN_VALUE && tileW != Integer.MIN_VALUE) {
            params.Set("Stiles", 0, 0, tileH);
            params.Set("Stiles", 0, 1, tileW);
        }
        params.Finalize();
    }

    static {
        Boolean addComment;
        GEOJP2_UUID = new short[]{177, 75, 248, 189, 8, 61, 75, 67, 165, 174, 140, 215, 213, 166, 206, 3};
        POWERS_2 = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000};
        LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.jp2k");
        TEMP_BUFFER_SIZE = 65536;
        int size = 0x2000000;
        int buffer = 65536;
        Integer maxSize = Integer.getInteger(MAX_BUFFER_SIZE_KEY);
        Integer bufferSize = Integer.getInteger(TEMP_BUFFER_SIZE_KEY);
        String marker = System.getProperty(ADD_COMMENT_MARKER_KEY);
        ADD_COMMENT_MARKER = marker != null ? ((addComment = Boolean.valueOf(Boolean.parseBoolean(ADD_COMMENT_MARKER_KEY))) != null ? addComment : true) : true;
        if (maxSize != null) {
            size = maxSize;
        } else {
            String maxSizes = System.getProperty(MAX_BUFFER_SIZE_KEY);
            if (maxSizes != null) {
                size = JP2KKakaduImageWriter.parseSize(maxSizes);
            }
        }
        if (bufferSize != null) {
            buffer = bufferSize;
        } else {
            String bufferSizes = System.getProperty(TEMP_BUFFER_SIZE_KEY);
            if (bufferSizes != null) {
                buffer = JP2KKakaduImageWriter.parseSize(bufferSizes);
            }
        }
        TEMP_BUFFER_SIZE = buffer;
        MAX_BUFFER_SIZE = size;
    }

    private static final class MarkerSize {
        static final int SOC = 2;
        static final int COD = 14;
        static final int SOT = 12;
        static final int EOC = 2;
        static final int SOD = 2;
        static final int COM = 108;
        static final int TLM = 8;
        static final int COM_KAKADUV = 17;
        static final int QCD_ESTIMATE = 40;

        private MarkerSize() {
        }
    }
}

