/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k;

import com.sun.media.imageioimpl.common.ImageUtil;
import it.geosolutions.imageio.plugins.jp2k.JP2KBox;
import it.geosolutions.imageio.plugins.jp2k.JP2KCodestreamProperties;
import it.geosolutions.imageio.plugins.jp2k.JP2KFileWalker;
import it.geosolutions.imageio.plugins.jp2k.JP2KImageMetadata;
import it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReadParam;
import it.geosolutions.imageio.plugins.jp2k.JP2KStreamMetadata;
import it.geosolutions.imageio.plugins.jp2k.LazyJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BitsPerComponentBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import it.geosolutions.imageio.plugins.jp2k.box.ChannelDefinitionBox;
import it.geosolutions.imageio.plugins.jp2k.box.ColorSpecificationBox;
import it.geosolutions.imageio.plugins.jp2k.box.ComponentMappingBox;
import it.geosolutions.imageio.plugins.jp2k.box.ImageHeaderBox;
import it.geosolutions.imageio.plugins.jp2k.box.PaletteBox;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import it.geosolutions.imageio.utilities.Utilities;
import it.geosolutions.util.KakaduUtilities;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOParam;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import kdu_jni.Jp2_family_src;
import kdu_jni.Jpx_codestream_source;
import kdu_jni.Jpx_input_box;
import kdu_jni.Jpx_source;
import kdu_jni.KduException;
import kdu_jni.Kdu_codestream;
import kdu_jni.Kdu_compressed_source;
import kdu_jni.Kdu_coords;
import kdu_jni.Kdu_dims;
import kdu_jni.Kdu_simple_file_source;
import kdu_jni.Kdu_stripe_decompressor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JP2KKakaduImageReader
extends ImageReader {
    private static Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.jp2k");
    private static final int TEMP_BUFFER_SIZE = 65536;
    private boolean deleteInputFile;
    private File inputFile = null;
    private String fileName = null;
    private boolean isRawSource;
    private JP2KFileWalker fileWalker;
    private final List<JP2KCodestreamProperties> multipleCodestreams = new ArrayList<JP2KCodestreamProperties>();
    private int numImages = 1;

    protected JP2KKakaduImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
        KakaduUtilities.initializeKakaduMessagesManagement();
    }

    protected void checkImageIndex(int imageIndex) {
        if (imageIndex < 0 || imageIndex > this.numImages) {
            StringBuffer sb = new StringBuffer("Illegal imageIndex specified = ").append(imageIndex).append(", while the valid imageIndex");
            if (this.numImages > 1) {
                sb.append(" range should be [0,").append(this.numImages - 1).append("]!");
            } else {
                sb.append(" should be 0!");
            }
            throw new IndexOutOfBoundsException(sb.toString());
        }
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.multipleCodestreams.get(imageIndex).getHeight();
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.multipleCodestreams.get(imageIndex).getWidth();
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return new JP2KImageMetadata(this.multipleCodestreams.get(imageIndex));
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        if (this.isRawSource) {
            throw new UnsupportedOperationException("Raw source detected. Actually, unable to get stream metadata");
        }
        return new JP2KStreamMetadata(this.fileWalker.getJP2KBoxesTree(), this.numImages);
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        JP2KCodestreamProperties codestreamP = this.multipleCodestreams.get(imageIndex);
        if (codestreamP.getColorModel() == null || codestreamP.getSampleModel() == null) {
            try {
                this.initializeSampleModelAndColorModel(codestreamP);
            }
            catch (KduException kdue) {
                throw new RuntimeException("Error while setting sample and color model", kdue);
            }
        }
        ImageTypeSpecifier imageType = new ImageTypeSpecifier(codestreamP.getColorModel(), codestreamP.getSampleModel());
        l.add(imageType);
        return l.iterator();
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return this.numImages;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkImageIndex(imageIndex);
        JP2KCodestreamProperties codestreamP = this.multipleCodestreams.get(imageIndex);
        int maxAvailableQualityLayers = codestreamP.getMaxAvailableQualityLayers();
        int[] componentIndexes = codestreamP.getComponentIndexes();
        int nComponents = codestreamP.getNumComponents();
        int maxBitDepth = codestreamP.getMaxBitDepth();
        int height = codestreamP.getHeight();
        int width = codestreamP.getWidth();
        ColorModel cm = codestreamP.getColorModel();
        SampleModel sm = codestreamP.getSampleModel();
        Kdu_simple_file_source localRawSource = null;
        Jp2_family_src localFamilySource = null;
        Jpx_source localWrappedSource = null;
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        Rectangle destinationRegion = new Rectangle(0, 0, -1, -1);
        Rectangle sourceRegion = new Rectangle(0, 0, -1, -1);
        Rectangle requiredRegion = new Rectangle(0, 0, -1, -1);
        int xSubsamplingFactor = -1;
        int ySubsamplingFactor = -1;
        boolean resamplingIsRequired = false;
        if (!(param instanceof JP2KKakaduImageReadParam)) {
            JP2KKakaduImageReadParam jp2kParam = (JP2KKakaduImageReadParam)((Object)this.getDefaultReadParam());
            jp2kParam.initialize((ImageReadParam)param);
            param = jp2kParam;
        }
        int interpolationType = ((JP2KKakaduImageReadParam)((Object)param)).getInterpolationType();
        int qualityLayers = ((JP2KKakaduImageReadParam)((Object)param)).getQualityLayers();
        if (qualityLayers != -1) {
            if (qualityLayers > maxAvailableQualityLayers) {
                qualityLayers = maxAvailableQualityLayers;
            }
        } else {
            qualityLayers = 0;
        }
        xSubsamplingFactor = ((IIOParam)param).getSourceXSubsampling();
        ySubsamplingFactor = ((IIOParam)param).getSourceYSubsampling();
        JP2KKakaduImageReader.computeRegions(width, height, (ImageReadParam)param, sourceRegion, destinationRegion);
        int[] resolutionInfo = new int[2];
        resamplingIsRequired = this.getRequiredRegionsAndResolutions(codestreamP, xSubsamplingFactor, ySubsamplingFactor, sourceRegion, destinationRegion, requiredRegion, resolutionInfo);
        int nDiscardLevels = resolutionInfo[1];
        BufferedImage bi = null;
        try {
            Object[] bufferValues;
            DataBuffer imageBuffer = null;
            Kdu_codestream codestream = new Kdu_codestream();
            if (!this.isRawSource) {
                localFamilySource = new Jp2_family_src();
                localWrappedSource = new Jpx_source();
                localFamilySource.Open(this.fileName);
                localWrappedSource.Open(localFamilySource, true);
                Jpx_codestream_source stream = localWrappedSource.Access_codestream(imageIndex);
                Jpx_input_box inputbox = stream.Open_stream();
                codestream.Create((Kdu_compressed_source)inputbox);
            } else {
                localRawSource = new Kdu_simple_file_source(this.fileName);
                codestream.Create((Kdu_compressed_source)localRawSource);
            }
            Kdu_dims dims = new Kdu_dims();
            codestream.Apply_input_restrictions(0, nComponents, nDiscardLevels, qualityLayers, null, 0);
            if (LOGGER.isLoggable(Level.FINE)) {
                Kdu_dims original_dims = new Kdu_dims();
                codestream.Get_dims(-1, original_dims);
                StringBuilder sb = new StringBuilder("Original Hi-Res Image Region is: x=").append(original_dims.Access_pos().Get_x()).append("  y=").append(original_dims.Access_pos().Get_y()).append("  w=").append(original_dims.Access_size().Get_x()).append("  h=").append(original_dims.Access_size().Get_y());
                LOGGER.fine(sb.toString());
            }
            Kdu_dims dimsROI = new Kdu_dims();
            codestream.Get_dims(0, dims);
            if (LOGGER.isLoggable(Level.FINE)) {
                int mappedX = dims.Access_pos().Get_x();
                int mappedY = dims.Access_pos().Get_y();
                int mappedWidth = dims.Access_size().Get_x();
                int mappedHeight = dims.Access_size().Get_y();
                StringBuilder sb = new StringBuilder("Mapped Region is: x=").append(mappedX).append("  y=").append(mappedY).append("  w=").append(mappedWidth).append("  h=").append(mappedHeight);
                LOGGER.fine(sb.toString());
            }
            this.checkBounds(dims, requiredRegion);
            int destBufferSize = requiredRegion.height * requiredRegion.width * nComponents;
            this.setDimsForCrop(dims, requiredRegion);
            codestream.Map_region(0, dims, dimsROI);
            if (LOGGER.isLoggable(Level.FINE)) {
                int mappedROIWidth = dimsROI.Access_size().Get_x();
                int mappedROIHeight = dimsROI.Access_size().Get_y();
                int mappedROIX = dimsROI.Access_pos().Get_x();
                int mappedROIY = dimsROI.Access_pos().Get_y();
                StringBuilder sb = new StringBuilder("ROI Region is: x=").append(mappedROIX).append("  y=").append(mappedROIY).append("  w=").append(mappedROIWidth).append("  h=").append(mappedROIHeight);
                LOGGER.fine(sb.toString());
            }
            codestream.Apply_input_restrictions(nComponents, componentIndexes, nDiscardLevels, qualityLayers, dimsROI, 0);
            int[] stripeHeights = new int[nComponents];
            int[] sampleGap = new int[nComponents];
            int[] rowGap = new int[nComponents];
            int[] sampleOffset = new int[nComponents];
            int[] precision = new int[nComponents];
            for (int component = 0; component < nComponents; ++component) {
                stripeHeights[component] = requiredRegion.height;
                sampleGap[component] = nComponents;
                rowGap[component] = requiredRegion.width * nComponents;
                sampleOffset[component] = component;
                precision[component] = codestream.Get_bit_depth(component);
            }
            Kdu_stripe_decompressor decompressor = new Kdu_stripe_decompressor();
            decompressor.Start(codestream);
            if (maxBitDepth <= 8) {
                bufferValues = new byte[destBufferSize];
                decompressor.Pull_stripe(bufferValues, stripeHeights, sampleOffset, sampleGap, rowGap, precision);
                imageBuffer = new DataBufferByte((byte[])bufferValues, destBufferSize);
            } else if (maxBitDepth > 8 && maxBitDepth <= 16) {
                boolean[] isSigned = new boolean[nComponents];
                for (int i = 0; i < isSigned.length; ++i) {
                    isSigned[i] = codestream.Get_signed(i);
                }
                short[] bufferValues2 = new short[destBufferSize];
                decompressor.Pull_stripe(bufferValues2, stripeHeights, sampleOffset, sampleGap, rowGap, precision, isSigned);
                imageBuffer = new DataBufferUShort(bufferValues2, destBufferSize);
            } else if (maxBitDepth > 16 && maxBitDepth <= 32) {
                bufferValues = new int[destBufferSize];
                decompressor.Pull_stripe((int[])bufferValues, stripeHeights, sampleOffset, sampleGap, rowGap, precision);
                imageBuffer = new DataBufferInt((int[])bufferValues, destBufferSize);
            }
            decompressor.Finish();
            decompressor.Native_destroy();
            codestream.Destroy();
            SampleModel sampleModel = sm.createCompatibleSampleModel(requiredRegion.width, requiredRegion.height);
            bi = new BufferedImage(cm, Raster.createWritableRaster(sampleModel, imageBuffer, null), false, null);
        }
        catch (KduException e) {
            throw new RuntimeException("Error caused by a Kakadu exception during creation of key objects! ", e);
        }
        catch (RasterFormatException rfe) {
            throw new RuntimeException("Error during raster creation", rfe);
        }
        finally {
            if (!this.isRawSource) {
                try {
                    if (localWrappedSource.Exists()) {
                        localWrappedSource.Close();
                    }
                }
                catch (KduException e) {}
                localWrappedSource.Native_destroy();
                try {
                    if (localFamilySource.Exists()) {
                        localFamilySource.Close();
                    }
                }
                catch (KduException e) {}
                localFamilySource.Native_destroy();
            } else {
                localRawSource.Native_destroy();
            }
            if (this.deleteInputFile && this.inputFile.exists()) {
                this.inputFile.delete();
            }
        }
        if (resamplingIsRequired && bi != null) {
            return KakaduUtilities.subsampleImage(codestreamP.getColorModel(), bi, destinationRegion.width, destinationRegion.height, interpolationType);
        }
        return bi;
    }

    private void checkBounds(Kdu_dims dims, Rectangle requiredRegion) throws KduException {
        if (dims == null) {
            throw new IllegalArgumentException("Provided Kdu_dims object is null");
        }
        if (requiredRegion == null) {
            throw new IllegalArgumentException("Provided region is null");
        }
        int mappedWidth = dims.Access_size().Get_x();
        int mappedHeight = dims.Access_size().Get_y();
        if (requiredRegion.y + requiredRegion.height > mappedHeight) {
            --requiredRegion.height;
        }
        if (requiredRegion.x + requiredRegion.width > mappedWidth) {
            --requiredRegion.width;
        }
    }

    private void setDimsForCrop(Kdu_dims dims, Rectangle requiredRegion) throws KduException {
        if (dims == null) {
            throw new IllegalArgumentException("Provided Kdu_dims object is null");
        }
        if (requiredRegion == null) {
            throw new IllegalArgumentException("Provided region is null");
        }
        dims.Access_pos().Set_x(dims.Access_pos().Get_x() + requiredRegion.x);
        dims.Access_pos().Set_y(dims.Access_pos().Get_y() + requiredRegion.y);
        dims.Access_size().Set_x(requiredRegion.width);
        dims.Access_size().Set_y(requiredRegion.height);
    }

    private static void computeRegions(int width, int height, ImageReadParam param, Rectangle sourceRegion, Rectangle destinationRegion) {
        Rectangle paramRegion = param.getSourceRegion();
        int xSubsamplingFactor = param.getSourceXSubsampling();
        int ySubsamplingFactor = param.getSourceYSubsampling();
        if (paramRegion != null) {
            sourceRegion.setBounds(paramRegion);
            if (sourceRegion.x < 0) {
                sourceRegion.x = 0;
            }
            if (sourceRegion.y < 0) {
                sourceRegion.y = 0;
            }
            destinationRegion.x = sourceRegion.x;
            if (sourceRegion.x + sourceRegion.width > width) {
                sourceRegion.width = width - sourceRegion.x;
            }
            destinationRegion.width = sourceRegion.width;
            destinationRegion.y = sourceRegion.y;
            if (sourceRegion.y + sourceRegion.height > height) {
                sourceRegion.height = height - sourceRegion.y;
            }
            destinationRegion.height = sourceRegion.height;
        } else {
            destinationRegion.setBounds(0, 0, width, height);
            sourceRegion.setBounds(0, 0, width, height);
        }
        destinationRegion.width = (destinationRegion.width - 1) / xSubsamplingFactor + 1;
        destinationRegion.height = (destinationRegion.height - 1) / ySubsamplingFactor + 1;
        if (sourceRegion.x != 0) {
            destinationRegion.x = sourceRegion.x / xSubsamplingFactor;
        }
        if (sourceRegion.y != 0) {
            destinationRegion.y = sourceRegion.y / ySubsamplingFactor;
        }
    }

    private boolean getRequiredRegionsAndResolutions(JP2KCodestreamProperties codestreamP, int xSubsamplingFactor, int ySubsamplingFactor, Rectangle sourceRegion, Rectangle destinationRegion, Rectangle requiredRegion, int[] resolutionInfo) {
        boolean changedSubSamplingFactors;
        boolean resamplingIsRequired = false;
        int newSubSamplingFactor = 0;
        int maxSupportedSubSamplingFactor = codestreamP.getMaxSupportedSubSamplingFactor();
        boolean subSamplingFactorsAreDifferent = xSubsamplingFactor != ySubsamplingFactor;
        newSubSamplingFactor = xSubsamplingFactor <= ySubsamplingFactor ? xSubsamplingFactor : ySubsamplingFactor;
        boolean bl = changedSubSamplingFactors = newSubSamplingFactor > maxSupportedSubSamplingFactor;
        if (newSubSamplingFactor > maxSupportedSubSamplingFactor) {
            newSubSamplingFactor = maxSupportedSubSamplingFactor;
        }
        int[] info = KakaduUtilities.findOptimalResolutionInfo(codestreamP.getSourceDWTLevels(), newSubSamplingFactor);
        boolean bl2 = resamplingIsRequired = subSamplingFactorsAreDifferent || changedSubSamplingFactors || info[0] != newSubSamplingFactor;
        if (!resamplingIsRequired) {
            requiredRegion.setBounds(destinationRegion);
        } else {
            newSubSamplingFactor = info[0];
            requiredRegion.width = (sourceRegion.width - 1) / newSubSamplingFactor + 1;
            requiredRegion.height = (sourceRegion.height - 1) / newSubSamplingFactor + 1;
            if (sourceRegion.x != 0) {
                requiredRegion.x = sourceRegion.x / newSubSamplingFactor;
            }
            if (sourceRegion.y != 0) {
                requiredRegion.y = sourceRegion.y / newSubSamplingFactor;
            }
        }
        resolutionInfo[0] = newSubSamplingFactor;
        resolutionInfo[1] = info[1];
        return resamplingIsRequired;
    }

    /*
     * Loose catch block
     */
    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        block63: {
            Jpx_source wrappedSource;
            Jp2_family_src familySource;
            Kdu_simple_file_source rawSource;
            block59: {
                this.reset();
                if (input == null) {
                    throw new NullPointerException("The provided input is null!");
                }
                if (input instanceof File) {
                    this.inputFile = (File)input;
                } else if (input instanceof FileImageInputStreamExt) {
                    this.inputFile = ((FileImageInputStreamExt)input).getFile();
                } else if (input instanceof URL) {
                    URL tempURL = (URL)input;
                    if (tempURL.getProtocol().equalsIgnoreCase("file")) {
                        this.inputFile = Utilities.urlToFile((URL)tempURL);
                    }
                } else if (input instanceof ImageInputStream) {
                    try {
                        this.inputFile = File.createTempFile("buffer", ".j2c");
                        FileOutputStream fos = new FileOutputStream(this.inputFile);
                        byte[] buff = new byte[65536];
                        int bytesRead = 0;
                        while ((bytesRead = ((ImageInputStream)input).read(buff)) != -1) {
                            fos.write(buff, 0, bytesRead);
                        }
                        fos.close();
                        input = this.inputFile;
                        this.deleteInputFile = true;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("Unable to create a temp file", ioe);
                    }
                }
                if (this.inputFile == null) {
                    throw new IllegalArgumentException("Invalid source provided.");
                }
                this.fileName = this.inputFile.getAbsolutePath();
                rawSource = null;
                familySource = new Jp2_family_src();
                wrappedSource = new Jpx_source();
                Kdu_codestream codestream = new Kdu_codestream();
                familySource.Open(this.fileName);
                int success = wrappedSource.Open(familySource, true);
                if (success < 0) {
                    familySource.Close();
                    wrappedSource.Close();
                    rawSource = new Kdu_simple_file_source(this.fileName);
                    if (rawSource != null) {
                        if (this.fileName != null) {
                            FileInputStream fis = new FileInputStream(new File(this.fileName));
                            byte[] jp2SocMarker = new byte[2];
                            fis.read(jp2SocMarker);
                            if (jp2SocMarker[0] != -1 || jp2SocMarker[1] != 79) {
                                throw new IllegalArgumentException("Not a JP2K source.");
                            }
                            fis.close();
                        }
                        this.isRawSource = true;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Detected raw source");
                        }
                        this.numImages = 1;
                    }
                } else {
                    this.isRawSource = false;
                    int[] count = new int[1];
                    this.numImages = wrappedSource.Count_codestreams(count) ? count[0] : 0;
                }
                if (!this.isRawSource) {
                    this.fileWalker = new JP2KFileWalker(this.fileName);
                }
                for (int cs = 0; cs < this.numImages; ++cs) {
                    if (this.isRawSource) {
                        codestream.Create((Kdu_compressed_source)rawSource);
                    } else {
                        Jpx_codestream_source stream = wrappedSource.Access_codestream(cs);
                        Jpx_input_box inputbox = stream.Open_stream();
                        codestream.Create((Kdu_compressed_source)inputbox);
                    }
                    JP2KCodestreamProperties codestreamP = new JP2KCodestreamProperties();
                    Kdu_dims imageDims = new Kdu_dims();
                    codestream.Access_siz().Finalize_all();
                    codestream.Get_dims(-1, imageDims, false);
                    Kdu_dims tileSize = new Kdu_dims();
                    codestream.Get_tile_dims(new Kdu_coords(0, 0), -1, tileSize);
                    int tileWidth = tileSize.Access_size().Get_x();
                    int tileHeight = tileSize.Access_size().Get_y();
                    if ((float)tileWidth * (float)tileHeight >= 2.1474836E9f) {
                        tileHeight = 1024;
                        tileWidth = 1024;
                    }
                    codestreamP.setTileWidth(tileWidth);
                    codestreamP.setTileHeight(tileHeight);
                    codestreamP.setWidth(imageDims.Access_size().Get_x());
                    codestreamP.setHeight(imageDims.Access_size().Get_y());
                    int nComponents = codestream.Get_num_components();
                    int maxBitDepth = -1;
                    int[] componentIndexes = new int[nComponents];
                    int[] bitsPerComponent = new int[nComponents];
                    boolean isSigned = false;
                    for (int i = 0; i < nComponents; ++i) {
                        bitsPerComponent[i] = codestream.Get_bit_depth(i);
                        if (maxBitDepth < bitsPerComponent[i]) {
                            maxBitDepth = bitsPerComponent[i];
                        }
                        isSigned |= codestream.Get_signed(i);
                        componentIndexes[i] = i;
                    }
                    codestreamP.setNumComponents(nComponents);
                    codestreamP.setBitsPerComponent(bitsPerComponent);
                    codestreamP.setComponentIndexes(componentIndexes);
                    codestreamP.setMaxBitDepth(maxBitDepth);
                    codestreamP.setSigned(isSigned);
                    int sourceDWTLevels = codestream.Get_min_dwt_levels();
                    codestreamP.setSourceDWTLevels(sourceDWTLevels);
                    codestreamP.setMaxSupportedSubSamplingFactor(1 << sourceDWTLevels);
                    Kdu_coords tileCoords = new Kdu_coords();
                    tileCoords.Set_x(0);
                    tileCoords.Set_y(0);
                    codestream.Open_tile(tileCoords);
                    codestreamP.setMaxAvailableQualityLayers(codestream.Get_max_tile_layers());
                    this.initializeSampleModelAndColorModel(codestreamP);
                    codestream.Destroy();
                    this.multipleCodestreams.add(codestreamP);
                    if (this.isRawSource) break;
                }
                Object var23_28 = null;
                if (this.isRawSource || wrappedSource == null) break block59;
                try {
                    if (wrappedSource.Exists()) {
                        wrappedSource.Close();
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    wrappedSource.Native_destroy();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (familySource != null) {
                    try {
                        if (familySource.Exists()) {
                            familySource.Close();
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        familySource.Native_destroy();
                    }
                    catch (Throwable e) {}
                }
                break block63;
            }
            if (this.isRawSource && rawSource != null) {
                try {
                    if (wrappedSource.Exists()) {
                        wrappedSource.Close();
                    }
                    break block63;
                }
                catch (Throwable e) {}
            }
            break block63;
            {
                catch (KduException e) {
                    throw new RuntimeException("Error caused by a Kakadu exception during creation of key objects!", e);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Exception occurred during kakadu reader initialization", e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception occurred during kakadu reader initialization", e);
                }
            }
            catch (Throwable throwable) {
                Object var23_29 = null;
                if (!this.isRawSource && wrappedSource != null) {
                    try {
                        if (wrappedSource.Exists()) {
                            wrappedSource.Close();
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        wrappedSource.Native_destroy();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (familySource != null) {
                        try {
                            if (familySource.Exists()) {
                                familySource.Close();
                            }
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        try {
                            familySource.Native_destroy();
                        }
                        catch (Throwable e) {}
                    }
                } else if (this.isRawSource && rawSource != null) {
                    try {
                        if (wrappedSource.Exists()) {
                            wrappedSource.Close();
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        super.setInput(input, seekForwardOnly, ignoreMetadata);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.multipleCodestreams != null) {
            this.multipleCodestreams.clear();
        }
        this.numImages = 1;
        this.fileWalker = null;
    }

    @Override
    public int getTileHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        int tileHeight = this.multipleCodestreams.get(imageIndex).getTileHeight();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("tileHeight:").append(Integer.toString(tileHeight)).toString());
        }
        return tileHeight;
    }

    @Override
    public int getTileWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        int tileWidth = this.multipleCodestreams.get(imageIndex).getTileWidth();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("tileWidth:").append(Integer.toString(tileWidth)).toString());
        }
        return tileWidth;
    }

    private synchronized void initializeSampleModelAndColorModel(JP2KCodestreamProperties codestreamP) throws KduException {
        if (codestreamP.getSampleModel() != null && codestreamP.getColorModel() != null) {
            return;
        }
        this.parseBoxes(codestreamP);
        if (codestreamP.getColorModel() == null) {
            codestreamP.setColorModel(JP2KKakaduImageReader.getColorModel(codestreamP));
        }
        if (codestreamP.getSampleModel() == null) {
            codestreamP.setSampleModel(JP2KKakaduImageReader.getSampleModel(codestreamP));
        }
    }

    private static ColorModel getColorModel(JP2KCodestreamProperties codestreamP) throws KduException {
        if (codestreamP.getColorModel() != null) {
            return codestreamP.getColorModel();
        }
        if (codestreamP.getColorModel() != null) {
            return codestreamP.getColorModel();
        }
        int nComponents = codestreamP.getNumComponents();
        if (nComponents <= 4) {
            ColorSpace cs = nComponents > 2 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003);
            boolean hasAlpha = nComponents % 2 == 0;
            int maxBitDepth = codestreamP.getMaxBitDepth();
            if (maxBitDepth <= 8) {
                codestreamP.setDataBufferType(0);
            } else if (maxBitDepth <= 16) {
                if (codestreamP.isSigned()) {
                    codestreamP.setDataBufferType(2);
                } else {
                    codestreamP.setDataBufferType(1);
                }
            } else if (maxBitDepth <= 32) {
                codestreamP.setDataBufferType(3);
            }
            int dataBufferType = codestreamP.getDataBufferType();
            if (dataBufferType != -1) {
                if (nComponents == 1 && (maxBitDepth == 1 || maxBitDepth == 2 || maxBitDepth == 4)) {
                    codestreamP.setColorModel(ImageUtil.createColorModel((SampleModel)JP2KKakaduImageReader.getSampleModel(codestreamP)));
                } else {
                    codestreamP.setColorModel(new ComponentColorModel(cs, codestreamP.getBitsPerComponent(), hasAlpha, false, hasAlpha ? 3 : 1, dataBufferType));
                }
                return codestreamP.getColorModel();
            }
        }
        if (codestreamP.getSampleModel() == null) {
            codestreamP.setSampleModel(JP2KKakaduImageReader.getSampleModel(codestreamP));
        }
        if (codestreamP.getSampleModel() == null) {
            return null;
        }
        return ImageUtil.createColorModel((SampleModel)codestreamP.getSampleModel());
    }

    private void parseBoxes(JP2KCodestreamProperties codestreamP) {
        ChannelDefinitionBox chBox;
        BitsPerComponentBox bpcBox;
        byte[][] lookUpTable;
        PaletteBox palBox;
        ComponentMappingBox cmBox;
        ColorSpecificationBox csBox;
        if (this.isRawSource) {
            return;
        }
        int numComp = 1;
        byte[] bitDepths = null;
        byte[] maps = null;
        int bitDepth = -1;
        ICC_Profile profile = null;
        int colorSpaceType = -1;
        ImageHeaderBox ihBox = (ImageHeaderBox)this.getJp2Box(1768449138);
        if (ihBox != null) {
            numComp = ihBox.getNumComponents();
            bitDepth = ihBox.getBitDepth();
        }
        if ((csBox = (ColorSpecificationBox)this.getJp2Box(1668246642)) != null) {
            profile = csBox.getICCProfile();
            colorSpaceType = csBox.getEnumeratedColorSpace();
        }
        if ((cmBox = (ComponentMappingBox)this.getJp2Box(1668112752)) != null) {
            maps = cmBox.getComponentAssociation();
        }
        if ((palBox = (PaletteBox)this.getJp2Box(1885564018)) != null && (lookUpTable = palBox.getLUT()) != null && numComp == 1) {
            int tableComps = lookUpTable.length;
            int maxDepth = 1 + (bitDepth & 0x7F);
            if (maps == null) {
                maps = new byte[tableComps];
                for (int i = 0; i < tableComps; ++i) {
                    maps[i] = (byte)i;
                }
            }
            if (tableComps == 3) {
                codestreamP.setColorModel(new IndexColorModel(maxDepth, lookUpTable[0].length, lookUpTable[maps[0]], lookUpTable[maps[1]], lookUpTable[maps[2]]));
                return;
            }
            if (tableComps == 4) {
                codestreamP.setColorModel(new IndexColorModel(maxDepth, lookUpTable[0].length, lookUpTable[maps[0]], lookUpTable[maps[1]], lookUpTable[maps[2]], lookUpTable[maps[3]]));
                return;
            }
        }
        if ((bpcBox = (BitsPerComponentBox)this.getJp2Box(1651532643)) != null) {
            bitDepths = bpcBox.getBitDepth();
        }
        if ((chBox = (ChannelDefinitionBox)this.getJp2Box(1667523942)) != null) {
            boolean isSigned;
            short[] channels = chBox.getChannel();
            short[] associations = chBox.getAssociation();
            int[] cType = chBox.getTypes();
            boolean hasAlpha = false;
            int alphaChannel = numComp - 1;
            for (int i = 0; i < channels.length; ++i) {
                if (cType[i] != 1 || channels[i] != alphaChannel) continue;
                hasAlpha = true;
            }
            boolean[] isPremultiplied = new boolean[]{false};
            if (hasAlpha) {
                int i;
                isPremultiplied = new boolean[alphaChannel];
                for (i = 0; i < alphaChannel; ++i) {
                    isPremultiplied[i] = false;
                }
                for (i = 0; i < channels.length; ++i) {
                    if (cType[i] != 2) continue;
                    isPremultiplied[associations[i] - 1] = true;
                }
                for (i = 1; i < alphaChannel; ++i) {
                    isPremultiplied[0] = isPremultiplied[0] & isPremultiplied[i];
                }
            }
            ColorSpace cs = null;
            if (associations.length == 4) {
                cs = ColorSpace.getInstance(1000);
                hasAlpha = true;
            } else if (profile != null) {
                cs = new ICC_ColorSpace(profile);
            } else if (colorSpaceType == 16) {
                cs = ColorSpace.getInstance(1000);
            } else if (colorSpaceType == 17) {
                cs = ColorSpace.getInstance(1003);
            } else if (colorSpaceType == 18) {
                cs = ColorSpace.getInstance(1002);
            } else {
                LOGGER.warning("JP2 type only handle sRGB, GRAY and YCC Profiles");
            }
            int[] bits = new int[numComp];
            for (int i = 0; i < numComp; ++i) {
                bits[i] = bitDepths != null ? (bitDepths[i] & 0x7F) + 1 : (bitDepth & 0x7F) + 1;
            }
            int maxBitDepth = 1 + (bitDepth & 0x7F);
            boolean bl = isSigned = (bitDepth & 0x80) == 128;
            if (bitDepths != null) {
                boolean bl2 = isSigned = (bitDepths[0] & 0x80) == 128;
            }
            if (bitDepths != null) {
                for (int i = 0; i < numComp; ++i) {
                    if (bits[i] <= maxBitDepth) continue;
                    maxBitDepth = bits[i];
                }
            }
            int type = -1;
            if (maxBitDepth <= 8) {
                type = 0;
            } else if (maxBitDepth <= 16) {
                type = isSigned ? 2 : 1;
            } else if (maxBitDepth <= 32) {
                type = 3;
            }
            if (type == -1) {
                return;
            }
            if (cs != null) {
                codestreamP.setColorModel(new ComponentColorModel(cs, bits, hasAlpha, isPremultiplied[0], hasAlpha ? 3 : 1, type));
            }
        }
    }

    private static SampleModel getSampleModel(JP2KCodestreamProperties codestreamP) {
        if (codestreamP == null) {
            throw new IllegalArgumentException("null codestream properties provided");
        }
        if (codestreamP.getSampleModel() != null) {
            return codestreamP.getSampleModel();
        }
        int nComponents = codestreamP.getNumComponents();
        int maxBitDepth = codestreamP.getMaxBitDepth();
        int tileWidth = codestreamP.getTileWidth();
        int tileHeight = codestreamP.getTileHeight();
        if (nComponents == 1 && (maxBitDepth == 1 || maxBitDepth == 2 || maxBitDepth == 4)) {
            codestreamP.setSampleModel(new MultiPixelPackedSampleModel(0, tileWidth, tileHeight, maxBitDepth));
        } else if (maxBitDepth <= 8) {
            codestreamP.setSampleModel(new PixelInterleavedSampleModel(0, tileWidth, tileHeight, nComponents, tileWidth * nComponents, codestreamP.getComponentIndexes()));
        } else if (maxBitDepth <= 16) {
            codestreamP.setSampleModel(new PixelInterleavedSampleModel(codestreamP.isSigned() ? 2 : 1, tileWidth, tileHeight, nComponents, tileWidth * nComponents, codestreamP.getComponentIndexes()));
        } else if (maxBitDepth <= 32) {
            codestreamP.setSampleModel(new PixelInterleavedSampleModel(3, tileWidth, tileHeight, nComponents, tileWidth * nComponents, codestreamP.getComponentIndexes()));
        } else {
            throw new IllegalArgumentException("Unhandled sample model");
        }
        return codestreamP.getSampleModel();
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new JP2KKakaduImageReadParam();
    }

    public int getSourceDWTLevels(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.multipleCodestreams.get(imageIndex).getSourceDWTLevels();
    }

    private JP2KBox getJp2Box(String boxType) {
        TreeModel boxesTree = this.fileWalker.getJP2KBoxesTree();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)boxesTree.getRoot();
        DefaultMutableTreeNode node = null;
        if (root != null) {
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
                JP2KBox box = (JP2KBox)((Object)current);
                if (box == null || BoxUtilities.getTypeInt(boxType) != box.getType()) continue;
                node = current;
                break;
            }
        }
        if (node != null) {
            return LazyJP2KBox.getAsOriginalBox((JP2KBox)((Object)node));
        }
        return null;
    }

    private JP2KBox getJp2Box(int boxType) {
        return this.getJp2Box(BoxUtilities.getBoxName(boxType));
    }

    @Override
    public void reset() {
        super.setInput(null, false, false);
        this.dispose();
        this.numImages = -1;
        this.isRawSource = false;
    }

    File getInputFile() {
        return this.inputFile;
    }

    String getFileName() {
        return this.fileName;
    }

    static {
        String level = System.getProperty("it.geosolutions.loggerlevel");
        if (level != null && level.equalsIgnoreCase("FINE")) {
            LOGGER.setLevel(Level.FINE);
        }
    }
}

