/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k;

import com.sun.media.imageioimpl.common.ImageUtil;
import it.geosolutions.imageio.plugins.jp2k.JP2KCodestreamProperties;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class JP2KImageMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "it_geosolutions_imageio_plugins_jp2k_ImageMetadata_1.0";
    public static final String NUM_COMPONENTS = "NumberOfComponents";
    public static final String MAX_BIT_DEPTH = "MaxBitDepth";
    public static final String WIDTH = "Width";
    public static final String HEIGHT = "Height";
    public static final String TILE_WIDTH = "TileWidth";
    public static final String TILE_HEIGHT = "TileHeight";
    public static final String MAX_QUALITY_LAYERS = "MaxAvailableQualityLayers";
    public static final String DWT_LEVELS = "SourceDWTLevels";
    public static final String IS_SIGNED = "IsSigned";
    public static final String BITS_PER_COMPONENT = "BitsPerComponent";
    public static final String COMPONENT_INDEXES = "ComponentIndexes";
    private int numComponents;
    private int width;
    private int height;
    private int tileWidth;
    private int tileHeight;
    private int maxAvailableQualityLayers = -1;
    private int sourceDWTLevels;
    private boolean isSigned;
    private int[] bitsPerComponent;
    private int[] componentIndexes;

    public JP2KImageMetadata(JP2KCodestreamProperties properties) {
        this.numComponents = properties.getNumComponents();
        this.bitsPerComponent = properties.getBitsPerComponent();
        this.componentIndexes = properties.getComponentIndexes();
        this.sourceDWTLevels = properties.getSourceDWTLevels();
        this.maxAvailableQualityLayers = properties.getMaxAvailableQualityLayers();
        this.tileHeight = properties.getTileHeight();
        this.tileWidth = properties.getTileWidth();
        this.isSigned = properties.isSigned();
        this.width = properties.getWidth();
        this.height = properties.getHeight();
    }

    public Node getAsTree(String formatName) {
        if (formatName.equalsIgnoreCase(nativeMetadataFormatName)) {
            return this.createNativeTree();
        }
        throw new IllegalArgumentException(formatName + " is not a supported format name");
    }

    private Node createNativeTree() {
        IIOMetadataNode rootNode = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode child = new IIOMetadataNode(HEIGHT);
        child.setUserObject(this.height);
        child.setNodeValue(Integer.toString(this.height));
        rootNode.appendChild(child);
        child = new IIOMetadataNode(WIDTH);
        child.setUserObject(this.width);
        child.setNodeValue(Integer.toString(this.width));
        rootNode.appendChild(child);
        child = new IIOMetadataNode(TILE_HEIGHT);
        child.setUserObject(this.tileHeight);
        child.setNodeValue(Integer.toString(this.tileHeight));
        rootNode.appendChild(child);
        child = new IIOMetadataNode(TILE_WIDTH);
        child.setUserObject(this.tileWidth);
        child.setNodeValue(Integer.toString(this.tileWidth));
        rootNode.appendChild(child);
        child = new IIOMetadataNode(NUM_COMPONENTS);
        child.setUserObject(this.numComponents);
        child.setNodeValue(Integer.toString(this.numComponents));
        rootNode.appendChild(child);
        child = new IIOMetadataNode(BITS_PER_COMPONENT);
        child.setUserObject(this.bitsPerComponent);
        child.setNodeValue(ImageUtil.convertObjectToString((Object)this.bitsPerComponent));
        rootNode.appendChild(child);
        child = new IIOMetadataNode(COMPONENT_INDEXES);
        child.setUserObject(this.componentIndexes);
        child.setNodeValue(ImageUtil.convertObjectToString((Object)this.componentIndexes));
        rootNode.appendChild(child);
        child = new IIOMetadataNode(IS_SIGNED);
        child.setUserObject(this.isSigned);
        child.setNodeValue(Boolean.toString(this.isSigned));
        rootNode.appendChild(child);
        child = new IIOMetadataNode(MAX_QUALITY_LAYERS);
        child.setUserObject(this.maxAvailableQualityLayers);
        child.setNodeValue(Integer.toString(this.maxAvailableQualityLayers));
        rootNode.appendChild(child);
        child = new IIOMetadataNode(DWT_LEVELS);
        child.setUserObject(this.sourceDWTLevels);
        child.setNodeValue(Integer.toString(this.sourceDWTLevels));
        rootNode.appendChild(child);
        return rootNode;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new UnsupportedOperationException("MergeTree is unsupported");
    }

    public void reset() {
    }
}

