/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k;

import it.geosolutions.imageio.plugins.jp2k.JP2KBox;
import it.geosolutions.imageio.plugins.jp2k.JP2KTreeController;
import it.geosolutions.imageio.plugins.jp2k.LazyJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import it.geosolutions.imageio.plugins.jp2k.box.JP2KFileBox;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import kdu_jni.Jp2_family_src;
import kdu_jni.Jp2_input_box;
import kdu_jni.Jp2_locator;
import kdu_jni.KduException;

class JP2KFileWalker {
    private static final Logger LOGGER = Logger.getLogger("JP2KFileWalker");
    private boolean initialized;
    private DefaultTreeModel tree;
    private String fileName;
    private Jp2_family_src familySource;

    public JP2KFileWalker(String fileName) {
        this.fileName = fileName;
    }

    /*
     * Loose catch block
     */
    private void init() {
        List exceptions;
        block17: {
            Exception e2;
            Jp2_input_box inputBox;
            block16: {
                if (this.initialized) {
                    return;
                }
                this.familySource = new Jp2_family_src();
                inputBox = new Jp2_input_box();
                Jp2_locator locator = new Jp2_locator();
                exceptions = Collections.emptyList();
                this.familySource.Open(this.fileName);
                JP2KFileBox box = new JP2KFileBox();
                this.tree = new DefaultTreeModel(box);
                JP2KTreeController controller = new JP2KTreeController(this.tree);
                this.tree.addTreeModelListener(controller);
                if (inputBox.Open(this.familySource, locator)) {
                    this.parse(inputBox, box, 0);
                }
                controller.checkTreeConsistency();
                inputBox.Close();
                Object var7_7 = null;
                try {
                    this.familySource.Close();
                }
                catch (Exception e2) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block16;
                    LOGGER.log(Level.FINEST, e2.getLocalizedMessage(), e2);
                }
            }
            try {
                if (inputBox != null) {
                    inputBox.Close();
                }
                break block17;
            }
            catch (Exception e2) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, e2.getLocalizedMessage(), e2);
                }
                break block17;
            }
            {
                catch (KduException e3) {
                    throw new RuntimeException("Error caused by a Kakadu exception during Box management! ", e3);
                }
            }
            catch (Throwable throwable) {
                block19: {
                    block18: {
                        Object var7_8 = null;
                        try {
                            this.familySource.Close();
                        }
                        catch (Exception e2) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block18;
                            LOGGER.log(Level.FINEST, e2.getLocalizedMessage(), e2);
                        }
                    }
                    try {
                        if (inputBox != null) {
                            inputBox.Close();
                        }
                    }
                    catch (Exception e2) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block19;
                        LOGGER.log(Level.FINEST, e2.getLocalizedMessage(), e2);
                    }
                }
                throw throwable;
            }
        }
        if (!exceptions.isEmpty()) {
            throw new IllegalStateException("Tree Check failed");
        }
    }

    /*
     * Loose catch block
     */
    private void parse(Jp2_input_box inputBox, JP2KBox parent, int index) throws KduException {
        block23: {
            Exception e2;
            Jp2_input_box childBox;
            block22: {
                block21: {
                    childBox = new Jp2_input_box();
                    int boxtype = (int)(0xFFFFFFFFFFFFFFFFL & inputBox.Get_box_type());
                    String typeString = BoxUtilities.getTypeString(boxtype);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Found box " + typeString);
                    }
                    LazyJP2KBox currentBox = null;
                    if (BoxUtilities.boxNames.containsKey(boxtype)) {
                        Jp2_locator locator = inputBox.Get_locator();
                        currentBox = new LazyJP2KBox(this.fileName, boxtype, locator);
                        parent.insert(currentBox, index++);
                        this.tree.nodesWereInserted(parent, new int[]{index - 1});
                    } else if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Box of type " + typeString + " cannot be handled by this file type reader");
                    }
                    if (BoxUtilities.SUPERBOX_NAMES.contains(typeString) && childBox.Open(inputBox)) {
                        if (childBox.Exists()) {
                            this.parse(childBox, currentBox, 0);
                        }
                        childBox.Close();
                    }
                    inputBox.Close();
                    if (!inputBox.Open_next() || !inputBox.Exists()) break block21;
                    this.parse(inputBox, parent, index);
                }
                Object var10_10 = null;
                try {
                    if (childBox != null) {
                        childBox.Close();
                    }
                }
                catch (Exception e2) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block22;
                    LOGGER.log(Level.FINEST, e2.getLocalizedMessage(), e2);
                }
            }
            try {
                if (inputBox != null) {
                    inputBox.Close();
                }
                break block23;
            }
            catch (Exception e2) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, e2.getLocalizedMessage(), e2);
                }
                break block23;
            }
            {
                catch (KduException e3) {
                    throw new RuntimeException("Error caused by a Kakadu exception during Box management! ", e3);
                }
            }
            catch (Throwable throwable) {
                block25: {
                    block24: {
                        Object var10_11 = null;
                        try {
                            if (childBox != null) {
                                childBox.Close();
                            }
                        }
                        catch (Exception e2) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block24;
                            LOGGER.log(Level.FINEST, e2.getLocalizedMessage(), e2);
                        }
                    }
                    try {
                        if (inputBox != null) {
                            inputBox.Close();
                        }
                    }
                    catch (Exception e2) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block25;
                        LOGGER.log(Level.FINEST, e2.getLocalizedMessage(), e2);
                    }
                }
                throw throwable;
            }
        }
    }

    public synchronized TreeModel getJP2KBoxesTree() {
        this.init();
        return this.tree;
    }
}

