/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc.custom;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Environment;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.DBDialect;
import org.geotools.gce.imagemosaic.jdbc.ImageMosaicJDBCReader;
import org.geotools.gce.imagemosaic.jdbc.custom.JDBCPGrasterConfigurationBean;
import org.geotools.referencing.factory.gridshift.DataUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class JDBCPGRasterConfigurationBuilder {
    private static final String RASTER2PGSQL_PATH_KEY = "RASTER2PGSQL_PATH";
    private static final String MOSAIC_KEY = "$MASTER_TABLE";
    private static final String COVERAGE_KEY = "$COVERAGE_NAME";
    private static final String OPTIONS_KEY = "$OPTIONS";
    private static final String SCHEMA_KEY = "$SCHEMA";
    private static final String EPSG_CODE_KEY = "$EPSG_CODE";
    private static final String TABLE_PREFIX_KEY = "$TABLE_PREFIX";
    private static final String SQL_FILE_KEY = "$SQL_FILE";
    private static final String DATABASE_KEY = "$DATABASE";
    private static final String PGUSER_KEY = "$USER";
    private static final String PASSWORD_KEY = "$PASSWORD";
    private static final String PORT_KEY = "$PORT";
    private static final String HOST_KEY = "$HOST";
    private static final String FILES_KEY = "$FILES";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String DEFAULT_OPTIONS = "-t 128x128";
    private static final String TABLE_CREATION_SQL = "create table $MASTER_TABLE (NAME varchar(254) not null,TileTable varchar(254)not null, minX FLOAT8, minY FLOAT8, maxX FLOAT8, maxY FLOAT8, resX FLOAT8, resY FLOAT8,primary key (NAME,TileTable))";
    private static final String TABLE_CHECK_SQL = "SELECT tiletable FROM $MASTER_TABLE";
    private static final String TILE_TABLE_CHECK_SQL = "SELECT COUNT(rid) FROM $MASTER_TABLE";
    private static final String TILETABLE_INSERTION_SQL = "insert into $MASTER_TABLE (NAME,TileTable) values (?,?)";
    private static final Logger LOGGER = Logging.getLogger((String)ImageMosaicJDBCReader.class.getPackage().getName());
    private static final String TEMPLATE_FILE_NAME = "coverage.pgraster.template.xml";
    private static String RASTER2PGSQL_COMMAND = "raster2pgsql";
    private static String EXECUTE = "execute";
    private static final int DEFAULT_EPSG_CODE = 4326;
    private static String IMPORT_COMMAND;
    private static String TEMPLATE;
    private static String PATH;
    private static String RASTER2PGSQL_PATH;
    private static boolean available;
    private static boolean init;
    private JDBCPGrasterConfigurationBean configBean;
    private URL configDir;

    public JDBCPGRasterConfigurationBuilder(JDBCPGrasterConfigurationBean configBean, URL configDir) {
        this.configBean = configBean;
        this.configDir = configDir;
    }

    public static boolean isRaster2PgsqlAvailable() {
        JDBCPGRasterConfigurationBuilder.checkRaster2Pgsql();
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkRaster2Pgsql() {
        if (!init) {
            Logger logger = LOGGER;
            synchronized (logger) {
                if (init) {
                    return;
                }
                PATH = System.getenv("PATH");
                RASTER2PGSQL_PATH = System.getProperty(RASTER2PGSQL_PATH_KEY);
                File file = null;
                try {
                    File dir;
                    String OS = System.getProperty("os.name").toLowerCase();
                    if (OS.indexOf("win") >= 0) {
                        EXECUTE = "execute.bat";
                        String executable = RASTER2PGSQL_COMMAND;
                        String executablePath = RASTER2PGSQL_PATH + File.separatorChar;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("RASTER2PGSQL_PATH = " + RASTER2PGSQL_PATH);
                        }
                        dir = new File(executablePath);
                        RASTER2PGSQL_COMMAND = executable = executablePath + executable + ".exe";
                    } else {
                        dir = new File(".");
                    }
                    IMPORT_COMMAND = RASTER2PGSQL_COMMAND + " " + OPTIONS_KEY + " -F " + FILES_KEY + " " + SCHEMA_KEY + "." + TABLE_PREFIX_KEY + " > " + SQL_FILE_KEY + LINE_SEPARATOR + "psql -d " + DATABASE_KEY + " -U " + PGUSER_KEY + " -h " + HOST_KEY + " -p " + PORT_KEY + " -f " + SQL_FILE_KEY;
                    ExecTask task = new ExecTask();
                    task.setExecutable(RASTER2PGSQL_COMMAND);
                    task.setDir(dir);
                    task.createArg().setValue("-G");
                    Environment.Variable variable = new Environment.Variable();
                    variable.setKey("PATH");
                    variable.setValue(PATH);
                    task.addEnv(variable);
                    file = File.createTempFile("r2pg", ".tmp");
                    task.setOutput(file);
                    task.execute();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("raster2pgsql script is available");
                    }
                    available = true;
                }
                catch (BuildException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Failed to invoke the raster2pgsql script. This is not a problem unless you need to use the raster2pgsql script to automatically configure pgrasters.\n" + e.toString());
                    }
                    available = false;
                }
                catch (IOException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Failed to invoke the raster2pgsql script. This is not a problem unless you need to use the raster2pgsql script to automatically configure pgrasters.\n" + e.toString());
                    }
                    available = false;
                }
                finally {
                    init = true;
                    if (file != null) {
                        file.delete();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTemplate() {
        InputStream stream = null;
        stream = JDBCPGRasterConfigurationBuilder.class.getResourceAsStream(TEMPLATE_FILE_NAME);
        InputStreamReader streamReader = null;
        BufferedReader reader = null;
        try {
            streamReader = new InputStreamReader(stream);
            reader = new BufferedReader(streamReader);
            String line = null;
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            TEMPLATE = stringBuilder.toString();
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(e.getLocalizedMessage());
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(e.getLocalizedMessage());
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ignored) {}
            }
            if (streamReader != null) {
                try {
                    streamReader.close();
                }
                catch (Exception ignored) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ignored) {}
            }
        }
    }

    public static URL createConfiguration(String url, Hints hints) {
        Utilities.ensureNonNull((String)"url", (Object)url);
        try {
            Object object;
            JDBCPGRasterConfigurationBuilder builder = null;
            JDBCPGrasterConfigurationBean config = null;
            if (url.startsWith("pgraster")) {
                config = JDBCPGRasterConfigurationBuilder.parseConfig(url);
                int fileURLIndex = url.indexOf("#");
                String dataUrl = url.substring(fileURLIndex + 1);
                String fileUrl = dataUrl.startsWith("file:/") ? dataUrl : "file://" + dataUrl;
                builder = new JDBCPGRasterConfigurationBuilder(config, new URL(fileUrl));
            } else if (hints != null && hints.containsKey((Object)JDBCPGrasterConfigurationBean.CONFIG_KEY) && (object = hints.get((Object)JDBCPGrasterConfigurationBean.CONFIG_KEY)) != null && object instanceof JDBCPGrasterConfigurationBean) {
                config = (JDBCPGrasterConfigurationBean)object;
                builder = new JDBCPGRasterConfigurationBuilder(config, new URL(url));
            }
            if (builder != null) {
                if (!JDBCPGRasterConfigurationBuilder.isRaster2PgsqlAvailable() && config != null && (config.getFileExtension() != null || config.getImportOptions() != null) && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("The specified URL refers to a pgraster but raster2pgsql script is unavailable.\nAutomatic configuration won't be performed. In case raster tiles have been manually imported, make sure to leave fileExtensions and importOptions parameters empty and repeat the coverage configuration.");
                    return null;
                }
                return super.buildConfiguration();
            }
            return new URL(url);
        }
        catch (MalformedURLException mfe) {
            throw new IllegalArgumentException(mfe);
        }
    }

    private static JDBCPGrasterConfigurationBean parseConfig(String pgrasterUrl) {
        if (pgrasterUrl != null && pgrasterUrl.startsWith("pgraster:/")) {
            int epsgStartIndex;
            int epsgCode;
            int tableEndIndex;
            String schema;
            int schemaEndIndex;
            String db;
            String port;
            String host;
            String password;
            String pguser;
            int fileURLIndex;
            block5: {
                fileURLIndex = pgrasterUrl.indexOf("#");
                if (fileURLIndex < 0) {
                    throw new IllegalArgumentException("The specified URL doesn't contain the data folder");
                }
                int prefix = pgrasterUrl.startsWith("pgraster://") ? 11 : 10;
                int pguserEndIndex = pgrasterUrl.indexOf(":", prefix);
                pguser = pgrasterUrl.substring(prefix, pguserEndIndex);
                int passwordEndIndex = pgrasterUrl.indexOf("@");
                password = pgrasterUrl.substring(pguserEndIndex + 1, passwordEndIndex);
                int hostEndIndex = pgrasterUrl.indexOf(":", passwordEndIndex + 1);
                host = pgrasterUrl.substring(passwordEndIndex + 1, hostEndIndex);
                int portEndIndex = pgrasterUrl.indexOf(":", hostEndIndex + 1);
                port = pgrasterUrl.substring(hostEndIndex + 1, portEndIndex);
                int dbEndIndex = pgrasterUrl.indexOf(".", portEndIndex + 1);
                db = pgrasterUrl.substring(portEndIndex + 1, dbEndIndex);
                schemaEndIndex = pgrasterUrl.indexOf(".", dbEndIndex + 1);
                schema = pgrasterUrl.substring(dbEndIndex + 1, schemaEndIndex);
                tableEndIndex = pgrasterUrl.indexOf(":", schemaEndIndex + 1);
                epsgCode = 4326;
                epsgStartIndex = pgrasterUrl.indexOf("@", schemaEndIndex + 1);
                if (epsgStartIndex != -1) {
                    try {
                        epsgCode = Integer.parseInt(pgrasterUrl.substring(epsgStartIndex + 1, tableEndIndex));
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                        LOGGER.severe("Unable to parse the specified EPSGCode. Proceeding with DEFAULT:4326 due to : " + nfe.getLocalizedMessage());
                    }
                }
            }
            String table = pgrasterUrl.substring(schemaEndIndex + 1, epsgStartIndex != -1 ? epsgStartIndex : tableEndIndex);
            int optionsStartIndex = pgrasterUrl.indexOf("?", tableEndIndex + 1);
            String options = optionsStartIndex != -1 ? pgrasterUrl.substring(optionsStartIndex + 1, fileURLIndex) : DEFAULT_OPTIONS;
            int fileExtensionEndIndex = optionsStartIndex != -1 ? optionsStartIndex : fileURLIndex;
            String fileExtension = pgrasterUrl.substring(tableEndIndex + 1, fileExtensionEndIndex);
            Properties datastoreProperties = new Properties();
            datastoreProperties.put(HOST_KEY.substring(1), host);
            datastoreProperties.put(PGUSER_KEY.substring(1), pguser);
            datastoreProperties.put(PORT_KEY.substring(1), port);
            datastoreProperties.put(PASSWORD_KEY.substring(1), password);
            datastoreProperties.put(DATABASE_KEY.substring(1), db);
            JDBCPGrasterConfigurationBean bean = new JDBCPGrasterConfigurationBean(datastoreProperties, table, "rt" + table, fileExtension, table, options, schema, epsgCode);
            return bean;
        }
        return null;
    }

    private URL buildConfiguration() {
        this.validateConfiguration();
        File configFile = new File(DataUtilities.urlToFile((URL)this.configDir).getAbsolutePath() + File.separatorChar + this.configBean.getCoverageName() + ".pgraster.xml");
        URL url = DataUtilities.fileToURL((File)configFile);
        Config config = null;
        Connection connection = null;
        ArrayList<File> filesToBeDeleted = new ArrayList<File>();
        if (!configFile.exists()) {
            try {
                this.createConfigFile(configFile);
                config = Config.readFrom(url);
                DBDialect dialect = DBDialect.getDBDialect(config);
                connection = dialect.getConnection();
                if (!this.isMosaicAlreadyInDB(connection)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Proceeding with raster tiles automatic import using raster2pgsql");
                    }
                    this.importTilesIntoDB(connection, filesToBeDeleted);
                } else if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Skipping raster tiles import since metadata tables and tile tables already exists into the DB");
                }
            }
            catch (Exception e) {
                if (configFile.exists()) {
                    configFile.delete();
                }
                throw new RuntimeException(e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable t) {}
                }
                for (File file : filesToBeDeleted) {
                    try {
                        file.delete();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Exception occurred while deleting temp file: " + file.getAbsolutePath() + "\n" + e.getLocalizedMessage());
                    }
                }
            }
        }
        return url;
    }

    private boolean isMosaicAlreadyInDB(Connection connection) {
        String selectMetadataTableQuery = TABLE_CHECK_SQL.replace(MOSAIC_KEY, this.configBean.getTableName());
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Looking for mosaic table already created");
            }
            PreparedStatement ps = connection.prepareStatement(selectMetadataTableQuery);
            ResultSet set = ps.executeQuery();
            boolean allTablesArePresent = this.checkTileTables(set, connection);
            connection.commit();
            return allTablesArePresent;
        }
        catch (SQLException e) {
            block6: {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(e.getLocalizedMessage());
                }
                try {
                    connection.rollback();
                }
                catch (SQLException ex) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block6;
                    LOGGER.fine("Exception occurred while doing rollback:\n" + e.getLocalizedMessage());
                }
            }
            return false;
        }
    }

    private boolean checkTileTables(ResultSet set, Connection connection) throws SQLException {
        boolean proceed = true;
        boolean found = false;
        while (set.next() && proceed) {
            String tileTableName = set.getString("tiletable");
            String selectMetadataTableQuery = TILE_TABLE_CHECK_SQL.replace(MOSAIC_KEY, tileTableName);
            try {
                PreparedStatement ps;
                ResultSet tileSet;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Looking for mosaic table already created");
                }
                if (!(tileSet = (ps = connection.prepareStatement(selectMetadataTableQuery)).executeQuery()).next()) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("tile table " + tileTableName + " has been found");
                }
                if (!set.isLast()) continue;
                proceed = false;
                found = true;
            }
            catch (SQLException sqle) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(sqle.getLocalizedMessage());
                }
                String message = "Database contains the metadata table but some referred tile tables are missing. \nPlease, cleanup your database and retry the configuration";
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Database contains the metadata table but some referred tile tables are missing. \nPlease, cleanup your database and retry the configuration");
                }
                throw new IllegalArgumentException("Database contains the metadata table but some referred tile tables are missing. \nPlease, cleanup your database and retry the configuration");
            }
        }
        return found;
    }

    private void validateConfiguration() {
        Utilities.ensureNonNull((String)"configBean", (Object)this.configBean);
        Properties properties = this.configBean.getDatastoreProperties();
        Utilities.ensureNonNull((String)"datastoreProperties", (Object)properties);
        String schema = this.configBean.getSchema();
        Utilities.ensureNonNull((String)"schema", (Object)schema);
        String tileTablePrefix = this.configBean.getTileTablePrefix();
        Utilities.ensureNonNull((String)"tileTablePrefix", (Object)tileTablePrefix);
        String coverageName = this.configBean.getCoverageName();
        Utilities.ensureNonNull((String)"coverageName", (Object)coverageName);
        String tableName = this.configBean.getTableName();
        Utilities.ensureNonNull((String)"tableName", (Object)tableName);
    }

    private void createMetadataTable(Connection connection, String tableName, String coverageName, List<String> tileTables) {
        block8: {
            String createMetadataTableQuery = TABLE_CREATION_SQL.replace(MOSAIC_KEY, tableName);
            String insertTileQuery = TILETABLE_INSERTION_SQL.replace(MOSAIC_KEY, tableName);
            boolean created = false;
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Creating mosaic table");
                }
                connection.prepareStatement(createMetadataTableQuery).execute();
                created = true;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("updating mosaic table");
                }
                PreparedStatement ps = connection.prepareStatement(insertTileQuery);
                for (String tileTable : tileTables) {
                    ps.setString(1, coverageName);
                    ps.setString(2, tileTable);
                    ps.execute();
                }
                connection.commit();
            }
            catch (SQLException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Exception occurred while " + (created ? "updating" : "creating") + " metadata tables. Proceeding with rollback\n" + e.getLocalizedMessage());
                }
                try {
                    connection.rollback();
                }
                catch (SQLException ex) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block8;
                    LOGGER.fine("Exception occurred while doing rollback:\n" + e.getLocalizedMessage());
                }
            }
        }
    }

    private void importTilesIntoDB(Connection connection, List<File> filesToBeDeleted) throws SQLException, IOException {
        File configDirectory = DataUtilities.urlToFile((URL)this.configDir);
        if (!configDirectory.exists()) {
            throw new IllegalArgumentException("Specified URL doesn't exist: " + this.configDir);
        }
        if (!configDirectory.isDirectory()) {
            throw new IllegalArgumentException("Specified URL doesn't refer to a directory: " + this.configDir);
        }
        String tablePrefix = this.configBean.getTileTablePrefix();
        String importOptions = this.configBean.getImportOptions();
        String fileExtension = this.configBean.getFileExtension();
        String schema = this.configBean.getSchema();
        Properties datastoreProperties = this.configBean.getDatastoreProperties();
        String database = (String)datastoreProperties.get(DATABASE_KEY.substring(1));
        String pguser = (String)datastoreProperties.get(PGUSER_KEY.substring(1));
        String password = (String)datastoreProperties.get(PASSWORD_KEY.substring(1));
        String port = (String)datastoreProperties.get(PORT_KEY.substring(1));
        String host = (String)datastoreProperties.get(HOST_KEY.substring(1));
        ArrayList<String> tileTables = new ArrayList<String>();
        File dataDir = DataUtilities.urlToFile((URL)this.configDir);
        String script = JDBCPGRasterConfigurationBuilder.createScript(dataDir, database, schema, host, port, pguser, tablePrefix, fileExtension, tileTables, importOptions, filesToBeDeleted);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Executing the script");
        }
        this.executeScript(dataDir, script, password, filesToBeDeleted);
        String tableName = this.configBean.getTableName();
        String coverageName = this.configBean.getCoverageName();
        this.createMetadataTable(connection, tableName, coverageName, tileTables);
    }

    private static String createScript(File dataDir, String database, String schema, String host, String port, String pguser, String tablePrefix, String fileExtension, List<String> tileTables, String importOptions, List<File> filesToBeDeleted) {
        File[] files;
        String mainCommand = JDBCPGRasterConfigurationBuilder.prepareMainCommand(importOptions, fileExtension, database, pguser, schema, host, port);
        StringBuilder commands = new StringBuilder();
        for (File file : files = dataDir.listFiles()) {
            if (!file.isDirectory()) continue;
            String importCommand = JDBCPGRasterConfigurationBuilder.updateCommand(file, mainCommand, tablePrefix, fileExtension, tileTables, filesToBeDeleted);
            commands.append(importCommand).append(LINE_SEPARATOR);
        }
        String importCommand = JDBCPGRasterConfigurationBuilder.updateCommand(dataDir, mainCommand, tablePrefix, fileExtension, tileTables, filesToBeDeleted);
        commands.append(importCommand).append(LINE_SEPARATOR);
        return commands.toString();
    }

    private void executeScript(File dataDir, String script, String password, List<File> filesToBeDeleted) throws IOException {
        File scriptFile = new File(dataDir, EXECUTE);
        filesToBeDeleted.add(scriptFile);
        JDBCPGRasterConfigurationBuilder.writeToFile(scriptFile, script);
        ExecTask task = new ExecTask();
        task.setExecutable(scriptFile.getAbsolutePath());
        task.setDir(dataDir);
        Environment.Variable variable = new Environment.Variable();
        variable.setKey("PGPASSWORD");
        variable.setValue(password);
        task.addEnv(variable);
        Environment.Variable varPath = new Environment.Variable();
        varPath.setKey("PATH");
        varPath.setValue(PATH);
        task.addEnv(variable);
        task.execute();
    }

    private static String updateCommand(File file, String mainCommand, String tablePrefix, String fileExtension, List<String> tileTables, List<File> filesToBeDeleted) {
        String folderName = file.getName();
        String tileTable = tablePrefix + folderName;
        tileTables.add(tileTable);
        String command = mainCommand.replace(TABLE_PREFIX_KEY, tileTable);
        command = command.replace(FILES_KEY, file.getAbsolutePath() + File.separatorChar + fileExtension);
        String fileToBeDeleted = file.getAbsolutePath() + File.separatorChar + tileTable + ".sql";
        filesToBeDeleted.add(new File(fileToBeDeleted));
        command = command.replace(SQL_FILE_KEY, fileToBeDeleted);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Import Script to be executed: " + command);
        }
        return command;
    }

    private static String prepareMainCommand(String importOptions, String fileExtension, String database, String pguser, String schema, String host, String port) {
        String mainCommand = IMPORT_COMMAND;
        if (importOptions == null) {
            importOptions = DEFAULT_OPTIONS;
        }
        mainCommand = mainCommand.replace(OPTIONS_KEY, importOptions);
        mainCommand = mainCommand.replace(SCHEMA_KEY, schema);
        mainCommand = mainCommand.replace(DATABASE_KEY, database);
        mainCommand = mainCommand.replace(PGUSER_KEY, pguser);
        mainCommand = mainCommand.replace(HOST_KEY, host);
        mainCommand = mainCommand.replace(PORT_KEY, port);
        return mainCommand;
    }

    private void createConfigFile(File configFile) throws IOException {
        String config = this.updateValues(this.configBean);
        this.storeConfig(configFile, config);
    }

    private String updateValues(JDBCPGrasterConfigurationBean configBean) {
        Properties datastoreProperties = configBean.getDatastoreProperties();
        String config = TEMPLATE.replace(MOSAIC_KEY, configBean.getTableName()).replace(COVERAGE_KEY, configBean.getCoverageName()).replace(PGUSER_KEY, datastoreProperties.getProperty(PGUSER_KEY.substring(1))).replace(DATABASE_KEY, datastoreProperties.getProperty(DATABASE_KEY.substring(1))).replace(PASSWORD_KEY, datastoreProperties.getProperty(PASSWORD_KEY.substring(1))).replace(PORT_KEY, datastoreProperties.getProperty(PORT_KEY.substring(1))).replace(HOST_KEY, datastoreProperties.getProperty(HOST_KEY.substring(1))).replace(EPSG_CODE_KEY, Integer.toString(configBean.getEpsgCode()));
        return config;
    }

    private void storeConfig(File configFile, String config) throws IOException {
        JDBCPGRasterConfigurationBuilder.writeToFile(configFile, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(File file, String content) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            ((OutputStream)outputStream).write(content.getBytes());
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static {
        init = false;
        JDBCPGRasterConfigurationBuilder.initTemplate();
        JDBCPGRasterConfigurationBuilder.checkRaster2Pgsql();
    }
}

