/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessBase;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class JDBCAccessOracle
extends JDBCAccessBase {
    static String SRSSelect = "select srid from ALL_SDO_GEOM_METADATA where owner = ? and table_name=? and column_name = ?";
    static String SRSSelectCurrentSchema = "select srid from USER_SDO_GEOM_METADATA where table_name=? and column_name = ?";
    private String CRSSelect = "select wktext from mdsys.cs_srs where srid=?";
    private String extentSelect = null;
    private String allSelect = null;
    private String allSelectJoined = null;
    private String gridSelect = null;
    private String gridSelectJoined = null;

    JDBCAccessOracle(Config config) throws IOException {
        super(config);
        this.initStatementStrings(config);
    }

    private void initStatementStrings(Config config) {
        String geomAttr = config.getGeomAttributeNameInSpatialTable();
        this.extentSelect = "select min(sdo_geom.sdo_min_mbr_ordinate(" + geomAttr + ",1))," + "min(sdo_geom.sdo_min_mbr_ordinate(" + geomAttr + ",2))," + "max(sdo_geom.sdo_max_mbr_ordinate(" + geomAttr + ",1))," + "max(sdo_geom.sdo_max_mbr_ordinate(" + geomAttr + ",2)) from {0}";
        String spatialSelectClause = "select s." + config.getKeyAttributeNameInSpatialTable() + "," + "sdo_geom.sdo_min_mbr_ordinate(s." + geomAttr + ",1)," + "sdo_geom.sdo_min_mbr_ordinate(s." + geomAttr + ",2)," + "sdo_geom.sdo_max_mbr_ordinate(s." + geomAttr + ",1)," + "sdo_geom.sdo_max_mbr_ordinate(s." + geomAttr + ",2)";
        this.allSelect = spatialSelectClause + ",s." + config.getBlobAttributeNameInTileTable() + " from {0} s";
        this.allSelectJoined = spatialSelectClause + ",t." + config.getBlobAttributeNameInTileTable() + " from {0} s, {1} t  WHERE ";
        this.allSelectJoined = this.allSelectJoined + " s." + config.getKeyAttributeNameInSpatialTable() + " = t." + config.getKeyAttributeNameInTileTable();
        String whereClause = " SDO_FILTER(s." + geomAttr + "," + "SDO_GEOMETRY(2003, ?, NULL,SDO_ELEM_INFO_ARRAY(1,1003,3),SDO_ORDINATE_ARRAY(?,?, ?,?))" + ") = 'TRUE'";
        this.gridSelect = this.allSelect + " WHERE " + whereClause;
        this.gridSelectJoined = this.allSelectJoined + " AND " + whereClause;
    }

    @Override
    protected String getRandomTileStatement(ImageLevelInfo li) {
        if (li.isImplementedAsTableSplit()) {
            return MessageFormat.format(this.allSelectJoined, li.getSpatialTableName(), li.getTileTableName());
        }
        return MessageFormat.format(this.allSelect, li.getSpatialTableName());
    }

    @Override
    protected String getGridSelectStatement(ImageLevelInfo li) {
        String stmt = null;
        stmt = li.isImplementedAsTableSplit() ? MessageFormat.format(this.gridSelectJoined, li.getSpatialTableName(), li.getTileTableName()) : MessageFormat.format(this.gridSelect, li.getSpatialTableName());
        if (stmt.indexOf("'") == -1) {
            stmt = stmt.replace("TRUE", "'TRUE'");
        }
        return stmt;
    }

    @Override
    protected String getExtentSelectStatment(ImageLevelInfo li) {
        return MessageFormat.format(this.extentSelect, li.getSpatialTableName());
    }

    @Override
    protected Integer getSRSID(ImageLevelInfo li, Connection con) throws IOException {
        Number result = null;
        String schema = null;
        try {
            schema = this.getSchemaFromSpatialTable(li.getSpatialTableName());
            PreparedStatement s = null;
            if (schema == null) {
                s = con.prepareStatement(SRSSelectCurrentSchema);
                s.setString(1, li.getSpatialTableName());
                s.setString(2, this.config.getGeomAttributeNameInSpatialTable());
            } else {
                s = con.prepareStatement(SRSSelect);
                s.setString(1, schema);
                s.setString(2, li.getSpatialTableName());
                s.setString(3, this.config.getGeomAttributeNameInSpatialTable());
            }
            ResultSet r = s.executeQuery();
            if (r.next()) {
                result = (Number)r.getObject(1);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException(e);
        }
        if (result == null) {
            String msg = null;
            msg = schema != null ? MessageFormat.format("No entry in ALL_SDO_GEOM_METADATA where for {0},{1},{2}", schema, li.getSpatialTableName(), this.config.getGeomAttributeNameInSpatialTable()) : MessageFormat.format("No entry in USER_SDO_GEOM_METADATA where for {0},{1}", li.getSpatialTableName(), this.config.getGeomAttributeNameInSpatialTable());
            LOGGER.log(Level.SEVERE, msg);
            throw new IOException(msg);
        }
        return result.intValue();
    }

    @Override
    protected CoordinateReferenceSystem getCRS(ImageLevelInfo li, Connection con) throws IOException {
        CoordinateReferenceSystem result = null;
        try {
            PreparedStatement s = con.prepareStatement(this.CRSSelect);
            s.setInt(1, li.getSrsId());
            ResultSet r = s.executeQuery();
            if (r.next()) {
                String definition = r.getString(1);
                result = CRS.parseWKT((String)definition);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            LOGGER.warning("Cannot parse WKT defintion from db, srsid: " + li.getSrsId() + " : " + e.getMessage());
        }
        return result;
    }

    @Override
    protected void setGridSelectParams(PreparedStatement s, GeneralEnvelope envelope, ImageLevelInfo li) throws SQLException {
        s.setDouble(1, li.getSrsId().intValue());
        s.setDouble(2, envelope.getMinimum(0));
        s.setDouble(3, envelope.getMinimum(1));
        s.setDouble(4, envelope.getMaximum(0));
        s.setDouble(5, envelope.getMaximum(1));
    }
}

