/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.PlanarImage;
import javax.sql.DataSource;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.jdbc.datasource.DataSourceFinder;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageDecoderThread;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccess;
import org.geotools.gce.imagemosaic.jdbc.TileQueueElement;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

abstract class JDBCAccessBase
implements JDBCAccess {
    protected static final Logger LOGGER = Logging.getLogger((String)JDBCAccessBase.class.getPackage().getName());
    private List<ImageLevelInfo> levelInfos = new ArrayList<ImageLevelInfo>();
    protected Config config;
    protected DataSource dataSource = null;

    JDBCAccessBase(Config config) throws IOException {
        this.config = config;
        this.dataSource = DataSourceFinder.getDataSource(config.getDataSourceParams());
    }

    protected String getSchemaFromSpatialTable(String tn) {
        int index = tn.indexOf(46);
        if (index == -1) {
            return null;
        }
        return tn.substring(0, index);
    }

    @Override
    public void initialize() throws IOException {
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
            this.initFromDB(this.config.getCoverageName(), con);
            this.calculateExtentsFromDB(this.config.getCoverageName(), con);
            this.calculateResolutionsFromDB(this.config.getCoverageName(), con);
            con.close();
            for (ImageLevelInfo levelInfo : this.levelInfos) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info(levelInfo.infoString());
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            LOGGER.severe(e.getMessage());
            throw new IOException(e);
        }
        if (this.levelInfos.isEmpty()) {
            String msg = "No level available for " + this.config.getCoverageName();
            LOGGER.severe(msg);
            throw new IOException(msg);
        }
        TreeSet<ImageLevelInfo> sortColl = new TreeSet<ImageLevelInfo>();
        sortColl.addAll(this.levelInfos);
        this.levelInfos = new ArrayList<ImageLevelInfo>();
        this.levelInfos.addAll(sortColl);
    }

    protected void initFromDB(String coverageName, Connection con) throws SQLException, IOException {
        Statement s = null;
        ResultSet res = null;
        try {
            String stmt = this.config.getSqlSelectCoverageStatement();
            stmt = stmt.replace("?", "'" + coverageName + "'");
            s = con.prepareStatement(stmt);
            res = s.executeQuery();
            while (res.next()) {
                ImageLevelInfo imageLevelInfo = new ImageLevelInfo();
                imageLevelInfo.setCoverageName(coverageName);
                imageLevelInfo.setSpatialTableName(res.getString(this.config.getSpatialTableNameAtribute()));
                imageLevelInfo.setTileTableName(res.getString(this.config.getTileTableNameAtribute()));
                if (this.config.getVerifyCardinality().booleanValue()) {
                    imageLevelInfo.setCountFeature(new Integer(this.getRowCount(imageLevelInfo.getSpatialTableName(), con)));
                    if (imageLevelInfo.getSpatialTableName().equals(imageLevelInfo.getTileTableName())) {
                        imageLevelInfo.setCountTiles(imageLevelInfo.getCountFeature());
                    } else {
                        imageLevelInfo.setCountTiles(new Integer(this.getRowCount(imageLevelInfo.getTileTableName(), con)));
                    }
                    if (imageLevelInfo.getCountFeature() == 0) {
                        LOGGER.severe("Table " + imageLevelInfo.getSpatialTableName() + " has no entries");
                    } else if (imageLevelInfo.getCountTiles() == 0) {
                        LOGGER.severe("Table " + imageLevelInfo.getTileTableName() + " has no entries");
                    } else if (imageLevelInfo.getCountFeature().intValue() != imageLevelInfo.getCountTiles().intValue()) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, "Consistency warning: number of features: " + imageLevelInfo.getCountFeature() + " number tiles: " + imageLevelInfo.getCountTiles());
                        }
                    } else if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Number of features: " + imageLevelInfo.getCountFeature() + " number tiles: " + imageLevelInfo.getCountTiles());
                    }
                }
                imageLevelInfo.setExtentMaxX(new Double(res.getDouble(this.config.getMaxXAttribute())));
                if (res.wasNull()) {
                    imageLevelInfo.setExtentMaxX(null);
                }
                imageLevelInfo.setExtentMaxY(new Double(res.getDouble(this.config.getMaxYAttribute())));
                if (res.wasNull()) {
                    imageLevelInfo.setExtentMaxY(null);
                }
                imageLevelInfo.setExtentMinX(new Double(res.getDouble(this.config.getMinXAttribute())));
                if (res.wasNull()) {
                    imageLevelInfo.setExtentMinX(null);
                }
                imageLevelInfo.setExtentMinY(new Double(res.getDouble(this.config.getMinYAttribute())));
                if (res.wasNull()) {
                    imageLevelInfo.setExtentMinY(null);
                }
                imageLevelInfo.setResX(new Double(res.getDouble(this.config.getResXAttribute())));
                if (res.wasNull()) {
                    imageLevelInfo.setResX(null);
                }
                imageLevelInfo.setResY(new Double(res.getDouble(this.config.getResYAttribute())));
                if (res.wasNull()) {
                    imageLevelInfo.setResY(null);
                }
                if (this.config.getVerifyCardinality().booleanValue()) {
                    if (imageLevelInfo.getCountFeature() > 0 && imageLevelInfo.getCountTiles() > 0) {
                        this.levelInfos.add(imageLevelInfo);
                    }
                } else {
                    this.levelInfos.add(imageLevelInfo);
                }
                imageLevelInfo.setSrsId(this.getSRSID(imageLevelInfo, con));
                imageLevelInfo.setCrs(this.getCRS(imageLevelInfo, con));
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (IOException e1) {
            throw e1;
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (s != null) {
                s.close();
            }
        }
    }

    protected abstract CoordinateReferenceSystem getCRS(ImageLevelInfo var1, Connection var2) throws IOException;

    protected Integer getSRSID(ImageLevelInfo li, Connection con) throws IOException {
        return null;
    }

    protected abstract String getExtentSelectStatment(ImageLevelInfo var1);

    protected Envelope getExtent(ImageLevelInfo li, Connection con) throws SQLException, IOException {
        String statementString = this.getExtentSelectStatment(li);
        Envelope extent = null;
        PreparedStatement s = con.prepareStatement(statementString);
        ResultSet r = s.executeQuery();
        if (r.next()) {
            extent = new Envelope(new Coordinate(r.getDouble(1), r.getDouble(2)), new Coordinate(r.getDouble(3), r.getDouble(4)));
        }
        r.close();
        s.close();
        return extent;
    }

    void calculateExtentsFromDB(String coverageName, Connection con) throws SQLException, IOException {
        PreparedStatement stmt = con.prepareStatement(this.config.getSqlUpdateMosaicStatement());
        ArrayList<ImageLevelInfo> toBeRemoved = new ArrayList<ImageLevelInfo>();
        for (ImageLevelInfo li : this.levelInfos) {
            Envelope env;
            if (!li.getCoverageName().equals(coverageName) || !li.calculateExtentsNeeded()) continue;
            Date start = new Date();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Calculate extent for " + li.toString());
            }
            if ((env = this.getExtent(li, con)) == null) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "No extent, removing this level");
                }
                toBeRemoved.add(li);
                continue;
            }
            li.setExtentMaxX(new Double(env.getMaxX()));
            li.setExtentMaxY(new Double(env.getMaxY()));
            li.setExtentMinX(new Double(env.getMinX()));
            li.setExtentMinY(new Double(env.getMinY()));
            stmt.setDouble(1, li.getExtentMaxX());
            stmt.setDouble(2, li.getExtentMaxY());
            stmt.setDouble(3, li.getExtentMinX());
            stmt.setDouble(4, li.getExtentMinY());
            stmt.setString(5, li.getCoverageName());
            stmt.setString(6, li.getTileTableName());
            stmt.setString(7, li.getSpatialTableName());
            stmt.execute();
            long msecs = new Date().getTime() - start.getTime();
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.info("Calculate extent for " + li.toString() + " finished in " + msecs + " ms ");
        }
        this.levelInfos.removeAll(toBeRemoved);
        if (stmt != null) {
            stmt.close();
        }
    }

    void calculateResolutionsFromDB(String coverageName, Connection con) throws SQLException, IOException {
        PreparedStatement stmt = null;
        stmt = con.prepareStatement(this.config.getSqlUpdateResStatement());
        ArrayList<ImageLevelInfo> toBeRemoved = new ArrayList<ImageLevelInfo>();
        for (ImageLevelInfo li : this.levelInfos) {
            double[] resolutions;
            if (!li.getCoverageName().equals(coverageName) || !li.calculateResolutionNeeded()) continue;
            Date start = new Date();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Calculate resolutions for " + li.toString());
            }
            if ((resolutions = this.getPixelResolution(li, con)) == null) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "No image found, removing " + li.toString());
                }
                toBeRemoved.add(li);
                continue;
            }
            li.setResX(resolutions[0]);
            li.setResY(resolutions[1]);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("ResX: " + li.getResX() + " ResY: " + li.getResY());
            }
            stmt.setDouble(1, li.getResX());
            stmt.setDouble(2, li.getResY());
            stmt.setString(3, li.getCoverageName());
            stmt.setString(4, li.getTileTableName());
            stmt.setString(5, li.getSpatialTableName());
            stmt.execute();
            long msecs = new Date().getTime() - start.getTime();
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.info("Calculate resolutions for " + li.toString() + " finished in " + msecs + " ms ");
        }
        this.levelInfos.removeAll(toBeRemoved);
        if (stmt != null) {
            stmt.close();
        }
    }

    protected abstract String getGridSelectStatement(ImageLevelInfo var1);

    protected abstract void setGridSelectParams(PreparedStatement var1, GeneralEnvelope var2, ImageLevelInfo var3) throws SQLException;

    Envelope getBounds(int level) throws IOException {
        ImageLevelInfo li = this.levelInfos.get(level);
        return li.getEnvelope();
    }

    @Override
    public void startTileDecoders(Rectangle pixelDimension, GeneralEnvelope requestEnvelope, ImageLevelInfo levelInfo, LinkedBlockingQueue<TileQueueElement> tileQueue, GridCoverageFactory coverageFactory) throws IOException {
        Date start = new Date();
        Connection con = null;
        ArrayList<ImageDecoderThread> threads = new ArrayList<ImageDecoderThread>();
        ExecutorService pool = this.getExecutorServivicePool();
        String statementString = this.getGridSelectStatement(levelInfo);
        try {
            con = this.dataSource.getConnection();
            PreparedStatement s = con.prepareStatement(statementString);
            this.setGridSelectParams(s, requestEnvelope, levelInfo);
            ResultSet r = s.executeQuery();
            while (r.next()) {
                byte[] tileBytes = this.getTileBytes(r);
                Envelope env = this.getEnvelopeFromResultSet(r);
                String location = r.getString(this.config.getKeyAttributeNameInSpatialTable());
                Rectangle2D.Double tmp = new Rectangle2D.Double(env.getMinX(), env.getMinY(), env.getWidth(), env.getHeight());
                GeneralEnvelope tileGeneralEnvelope = new GeneralEnvelope((Rectangle2D)tmp);
                tileGeneralEnvelope.setCoordinateReferenceSystem(requestEnvelope.getCoordinateReferenceSystem());
                ImageDecoderThread thread = new ImageDecoderThread(tileBytes, location, tileGeneralEnvelope, pixelDimension, requestEnvelope, levelInfo, tileQueue, this.config);
                threads.add(thread);
                pool.execute(thread);
            }
            r.close();
            s.close();
            con.close();
        }
        catch (SQLException e) {
            try {
                con.close();
            }
            catch (SQLException e1) {
                // empty catch block
            }
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException(e);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Getting " + threads.size() + " Tiles needs " + (new Date().getTime() - start.getTime()) + " millisecs");
        }
        pool.shutdown();
        try {
            pool.awaitTermination(3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        tileQueue.add(TileQueueElement.ENDELEMENT);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Getting and decoding  " + threads.size() + " Tiles needs " + (new Date().getTime() - start.getTime()) + " millisecs");
        }
    }

    protected byte[] getTileBytes(ResultSet resultSet) throws SQLException {
        byte[] buffer = new byte[16384];
        InputStream in = resultSet.getBinaryStream(this.config.getBlobAttributeNameInTileTable());
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            while (in.read(buffer) > 0) {
                out.write(buffer);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return out.toByteArray();
    }

    private int getRowCount(String tableName, Connection con) throws SQLException {
        PreparedStatement s = con.prepareStatement("select count(*) from " + tableName);
        ResultSet res = s.executeQuery();
        res.next();
        int count = res.getInt(1);
        res.close();
        s.close();
        return count;
    }

    @Override
    public ImageLevelInfo getLevelInfo(int level) {
        return this.levelInfos.get(level);
    }

    @Override
    public int getNumOverviews() {
        return this.levelInfos.size() - 1;
    }

    protected Polygon polyFromEnvelope(GeneralEnvelope env) {
        GeometryFactory factory = new GeometryFactory();
        Coordinate[] coords = new Coordinate[]{new Coordinate(env.getMinimum(0), env.getMinimum(1)), new Coordinate(env.getMinimum(0), env.getMaximum(1)), new Coordinate(env.getMaximum(0), env.getMaximum(1)), new Coordinate(env.getMaximum(0), env.getMinimum(1)), new Coordinate(env.getMinimum(0), env.getMinimum(1))};
        return factory.createPolygon(factory.createLinearRing(coords), new LinearRing[0]);
    }

    protected abstract String getRandomTileStatement(ImageLevelInfo var1);

    protected Envelope getEnvelopeFromResultSet(ResultSet r) throws SQLException {
        Envelope result = new Envelope(new Coordinate(r.getDouble(2), r.getDouble(3)), new Coordinate(r.getDouble(4), r.getDouble(5)));
        return result;
    }

    protected double[] getPixelResolution(ImageLevelInfo li, Connection con) throws SQLException, IOException {
        double[] result = null;
        String statementString = this.getRandomTileStatement(li);
        PreparedStatement s = con.prepareStatement(statementString);
        ResultSet r = s.executeQuery();
        while (r.next()) {
            byte[] tileBytes = this.getTileBytes(r);
            if (tileBytes == null) continue;
            BufferedImage buffImage = null;
            li.setCanImageIOReadFromInputStream(true);
            try {
                buffImage = ImageIO.read(new ByteArrayInputStream(tileBytes));
            }
            catch (IOException e) {
                // empty catch block
            }
            if (buffImage == null) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Image IO cannot read from ByteInputStream,use less efficient jai methods");
                }
                li.setCanImageIOReadFromInputStream(false);
                ByteArraySeekableStream stream = new ByteArraySeekableStream(tileBytes);
                String decoderName = null;
                String[] arr$ = ImageCodec.getDecoderNames((SeekableStream)stream);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    String dn;
                    decoderName = dn = arr$[i$];
                }
                ImageDecoder decoder = ImageCodec.createImageDecoder(decoderName, (SeekableStream)stream, null);
                PlanarImage img = PlanarImage.wrapRenderedImage((RenderedImage)decoder.decodeAsRenderedImage());
                buffImage = img.getAsBufferedImage();
            }
            Envelope env = this.getEnvelopeFromResultSet(r);
            result = new double[]{env.getWidth() / (double)buffImage.getWidth(), env.getHeight() / (double)buffImage.getHeight()};
            break;
        }
        r.close();
        s.close();
        return result;
    }

    public ExecutorService getExecutorServivicePool() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        LOGGER.info("Using " + availableProcessors + " CPU(s)");
        return Executors.newFixedThreadPool(availableProcessors);
    }
}

