/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.imagemosaic.jdbc.AbstractThread;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.ImageMosaicJDBCReader;
import org.geotools.gce.imagemosaic.jdbc.TileQueueElement;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.Envelope;

public class ImageComposerThread
extends AbstractThread {
    protected static final Logger LOGGER = Logging.getLogger((String)ImageComposerThread.class.getPackage().getName());
    protected GridCoverageFactory coverageFactory;
    private GridCoverage2D gridCoverage2D;
    private Color outputTransparentColor;
    private Color backgroundColor;
    private boolean xAxisSwitch;

    public ImageComposerThread(Color backgroundColor, Color outputTransparentColor, Rectangle pixelDimension, GeneralEnvelope requestEnvelope, ImageLevelInfo levelInfo, LinkedBlockingQueue<TileQueueElement> tileQueue, Config config, boolean xAxisSwitch, GridCoverageFactory coverageFactory) {
        super(pixelDimension, requestEnvelope, levelInfo, tileQueue, config);
        this.outputTransparentColor = outputTransparentColor;
        this.backgroundColor = backgroundColor;
        this.xAxisSwitch = xAxisSwitch;
        this.coverageFactory = coverageFactory;
    }

    private Dimension getStartDimension() {
        double width = this.pixelDimension.getWidth() / this.rescaleX;
        double height = this.pixelDimension.getHeight() / this.rescaleY;
        return new Dimension((int)Math.round(width), (int)Math.round(height));
    }

    private BufferedImage getStartImage(BufferedImage copyFrom) {
        Dimension dim = this.getStartDimension();
        Hashtable<String, Object> properties = null;
        if (copyFrom.getPropertyNames() != null) {
            properties = new Hashtable<String, Object>();
            for (String name : copyFrom.getPropertyNames()) {
                properties.put(name, copyFrom.getProperty(name));
            }
        }
        SampleModel sm = copyFrom.getSampleModel().createCompatibleSampleModel((int)dim.getWidth(), (int)dim.getHeight());
        WritableRaster raster = Raster.createWritableRaster(sm, null);
        ColorModel colorModel = copyFrom.getColorModel();
        boolean alphaPremultiplied = copyFrom.isAlphaPremultiplied();
        DataBuffer dataBuffer = this.createDataBufferFilledWithNoDataValues(raster, colorModel.getPixelSize());
        raster = Raster.createWritableRaster(sm, dataBuffer, null);
        BufferedImage image = new BufferedImage(colorModel, raster, alphaPremultiplied, properties);
        if (this.levelInfo.getNoDataValue() == null) {
            Graphics2D g2D = (Graphics2D)image.getGraphics();
            Color save = g2D.getColor();
            g2D.setColor(this.backgroundColor);
            g2D.fillRect(0, 0, image.getWidth(), image.getHeight());
            g2D.setColor(save);
        }
        return image;
    }

    private BufferedImage getStartImage(int imageType) {
        Dimension dim = this.getStartDimension();
        if (imageType == 0) {
            imageType = ImageMosaicJDBCReader.DEFAULT_IMAGE_TYPE;
        }
        BufferedImage image = new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), imageType);
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        Color save = g2D.getColor();
        g2D.setColor(this.backgroundColor);
        g2D.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2D.setColor(save);
        return image;
    }

    @Override
    public void run() {
        BufferedImage image = null;
        TileQueueElement queueObject = null;
        try {
            while (!(queueObject = (TileQueueElement)this.tileQueue.take()).isEndElement()) {
                if (image == null) {
                    image = this.getStartImage(queueObject.getTileImage());
                }
                int posx = (int)((queueObject.getEnvelope().getMinimum(0) - this.requestEnvelope.getMinimum(0)) / this.levelInfo.getResX());
                int posy = (int)((this.requestEnvelope.getMaximum(1) - queueObject.getEnvelope().getMaximum(1)) / this.levelInfo.getResY());
                image.getRaster().setRect(posx, posy, queueObject.getTileImage().getRaster());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (image == null) {
            image = this.getStartImage(ImageMosaicJDBCReader.DEFAULT_IMAGE_TYPE);
        }
        GeneralEnvelope resultEnvelope = null;
        if (this.xAxisSwitch) {
            Rectangle2D.Double tmp = new Rectangle2D.Double(this.requestEnvelope.getMinimum(1), this.requestEnvelope.getMinimum(0), this.requestEnvelope.getSpan(1), this.requestEnvelope.getSpan(0));
            resultEnvelope = new GeneralEnvelope((Rectangle2D)tmp);
            resultEnvelope.setCoordinateReferenceSystem(this.requestEnvelope.getCoordinateReferenceSystem());
        } else {
            resultEnvelope = this.requestEnvelope;
        }
        image = this.rescaleImageViaPlanarImage(image);
        if (this.outputTransparentColor == null) {
            this.gridCoverage2D = this.coverageFactory.create((CharSequence)this.config.getCoverageName(), image, (Envelope)resultEnvelope);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on final mosaic");
            }
            RenderedImage result = ImageUtilities.maskColor(this.outputTransparentColor, image);
            this.gridCoverage2D = this.coverageFactory.create((CharSequence)this.config.getCoverageName(), result, (Envelope)resultEnvelope);
        }
    }

    GridCoverage2D getGridCoverage2D() {
        return this.gridCoverage2D;
    }

    private DataBuffer createDataBufferFilledWithNoDataValues(WritableRaster raster, int pixelSize) {
        DataBuffer dataBuffer;
        int dataType = raster.getDataBuffer().getDataType();
        Number noDataValue = this.levelInfo.getNoDataValue();
        int dataBufferSize = raster.getDataBuffer().getSize();
        int nrBanks = raster.getDataBuffer().getNumBanks();
        switch (dataType) {
            case 3: {
                int[][] intDataArray = new int[nrBanks][dataBufferSize];
                if (noDataValue != null) {
                    for (int i = 0; i < nrBanks; ++i) {
                        Arrays.fill(intDataArray[i], noDataValue.intValue());
                    }
                }
                dataBuffer = new DataBufferInt(intDataArray, dataBufferSize);
                break;
            }
            case 4: {
                float[][] floatDataArray = new float[nrBanks][dataBufferSize];
                if (noDataValue != null) {
                    for (int i = 0; i < nrBanks; ++i) {
                        Arrays.fill(floatDataArray[i], noDataValue.floatValue());
                    }
                }
                dataBuffer = new DataBufferFloat(floatDataArray, dataBufferSize);
                break;
            }
            case 5: {
                double[][] doubleDataArray = new double[nrBanks][dataBufferSize];
                if (noDataValue != null) {
                    for (int i = 0; i < nrBanks; ++i) {
                        Arrays.fill(doubleDataArray[i], noDataValue.doubleValue());
                    }
                }
                dataBuffer = new DataBufferDouble(doubleDataArray, dataBufferSize);
                break;
            }
            case 2: {
                short[][] shortDataArray = new short[nrBanks][dataBufferSize];
                if (noDataValue != null) {
                    for (int i = 0; i < nrBanks; ++i) {
                        Arrays.fill(shortDataArray[i], noDataValue.shortValue());
                    }
                }
                dataBuffer = new DataBufferShort(shortDataArray, dataBufferSize);
                break;
            }
            case 0: {
                byte[][] byteDataArray = new byte[nrBanks][dataBufferSize];
                if (noDataValue != null) {
                    for (int i = 0; i < nrBanks; ++i) {
                        Arrays.fill(byteDataArray[i], noDataValue.byteValue());
                    }
                }
                dataBuffer = new DataBufferByte(byteDataArray, dataBufferSize);
                break;
            }
            case 1: {
                short[][] ushortDataArray = new short[nrBanks][dataBufferSize];
                if (noDataValue != null) {
                    for (int i = 0; i < nrBanks; ++i) {
                        Arrays.fill(ushortDataArray[i], noDataValue.shortValue());
                    }
                }
                dataBuffer = new DataBufferUShort(ushortDataArray, dataBufferSize);
                break;
            }
            default: {
                throw new IllegalStateException("Couldn't create DataBuffer for  data type " + dataType + " and " + pixelSize + " pixel size");
            }
        }
        return dataBuffer;
    }
}

