/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.DBDialect;

public class DB2Dialect
extends DBDialect {
    public DB2Dialect(Config config) {
        super(config);
    }

    @Override
    protected String getRegisterSpatialStatement(String tn, String srs) {
        return "call db2gse.ST_register_spatial_column(null,'" + tn + "','" + this.config.getGeomAttributeNameInSpatialTable() + "','" + srs + "',?,?)";
    }

    @Override
    protected String getUnregisterSpatialStatement(String tn) {
        return "call db2gse.ST_unregister_spatial_column(null,'" + tn + "','" + this.config.getGeomAttributeNameInSpatialTable() + "',?,?)";
    }

    @Override
    protected String getBLOBSQLType() {
        return "BLOB";
    }

    @Override
    protected String getMultiPolygonSQLType() {
        return "db2gse.st_multipolygon";
    }

    @Override
    protected String getCreateIndexStatement(String tn) throws Exception {
        return "CREATE  INDEX IX_" + tn + " ON " + tn + "(" + this.getConfig().getGeomAttributeNameInSpatialTable() + ") " + " EXTEND USING db2gse.spatial_index (10000.0, 100000.0, 1000000.0)";
    }
}

