/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geotools.data.jdbc.datasource.DBCPDataSourceFactory;
import org.geotools.data.jdbc.datasource.JNDIDataSourceFactory;
import org.geotools.gce.imagemosaic.jdbc.SpatialExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Config {
    private static Map<String, Config> ConfigMap = new Hashtable<String, Config>();
    private String xmlUrl;
    private String coverageName;
    private String geoRasterAttribute;
    private String coordsys;
    private SpatialExtension spatialExtension;
    private String dstype;
    private String username;
    private String password;
    private String jdbcUrl;
    private String driverClassName;
    private Integer maxActive;
    private Integer maxIdle;
    private String jndiReferenceName;
    private String coverageNameAttribute;
    private String blobAttributeNameInTileTable;
    private String keyAttributeNameInTileTable;
    private String keyAttributeNameInSpatialTable;
    private String geomAttributeNameInSpatialTable;
    private String maxXAttribute;
    private String maxYAttribute;
    private String minXAttribute;
    private String minYAttribute;
    private String masterTable;
    private String resXAttribute;
    private String resYAttribute;
    private String tileTableNameAtribute;
    private String spatialTableNameAtribute;
    private String sqlUpdateMosaicStatement;
    private String sqlSelectCoverageStatement;
    private String sqlUpdateResStatement;
    private Boolean verifyCardinality;
    private Boolean ignoreAxisOrder;
    private Integer interpolation;
    private String tileMaxXAttribute;
    private String tileMaxYAttribute;
    private String tileMinXAttribute;
    private String tileMinYAttribute;
    private String jdbcAccessClassName;

    protected Config() {
    }

    public static Config readFrom(URL xmlURL) throws Exception {
        Config result = ConfigMap.get(xmlURL.toString());
        if (result != null) {
            return result;
        }
        InputStream in = xmlURL.openStream();
        InputSource input = new InputSource(xmlURL.toString());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(input);
        in.close();
        result = new Config();
        result.xmlUrl = xmlURL.toString();
        result.dstype = Config.readValueString(dom, "dstype");
        result.username = Config.readValueString(dom, "username");
        result.password = Config.readValueString(dom, "password");
        result.jdbcUrl = Config.readValueString(dom, "jdbcUrl");
        result.driverClassName = Config.readValueString(dom, "driverClassName");
        result.jndiReferenceName = Config.readValueString(dom, "jndiReferenceName");
        result.maxActive = Config.readValueInteger(dom, "maxActive");
        result.maxIdle = Config.readValueInteger(dom, "maxIdle");
        result.coordsys = Config.readNameString(dom.getDocumentElement(), "coordsys");
        result.coverageName = Config.readNameString(dom.getDocumentElement(), "coverageName");
        Node tmp = dom.getElementsByTagName("scaleop").item(0);
        NamedNodeMap map = tmp.getAttributes();
        String s = map.getNamedItem("interpolation").getNodeValue();
        result.interpolation = new Integer(s);
        result.ignoreAxisOrder = Boolean.FALSE;
        tmp = dom.getElementsByTagName("axisOrder").item(0);
        if (tmp != null) {
            map = tmp.getAttributes();
            s = map.getNamedItem("ignore").getNodeValue();
            result.ignoreAxisOrder = new Boolean(s);
        }
        result.spatialExtension = SpatialExtension.fromString(Config.readNameString(dom.getDocumentElement(), "spatialExtension"));
        if (SpatialExtension.GEORASTER.equals((Object)result.spatialExtension)) {
            Config.readForOracleGeoRaster(result, dom);
        } else if (SpatialExtension.CUSTOM.equals((Object)result.spatialExtension)) {
            Config.readForCustom(result, dom);
        } else {
            Config.readMapping(result, dom);
            result.initStatements();
        }
        ConfigMap.put(xmlURL.toString(), result);
        return result;
    }

    static void readMapping(Config result, Document dom) {
        Element spatialTableElem;
        result.masterTable = Config.readNameString(dom.getDocumentElement(), "masterTable");
        Element masterTableElem = (Element)dom.getElementsByTagName("masterTable").item(0);
        result.coverageNameAttribute = Config.readNameString(masterTableElem, "coverageNameAttribute");
        result.maxXAttribute = Config.readNameString(masterTableElem, "maxXAttribute");
        result.maxYAttribute = Config.readNameString(masterTableElem, "maxYAttribute");
        result.minXAttribute = Config.readNameString(masterTableElem, "minXAttribute");
        result.minYAttribute = Config.readNameString(masterTableElem, "minYAttribute");
        result.resXAttribute = Config.readNameString(masterTableElem, "resXAttribute");
        result.resYAttribute = Config.readNameString(masterTableElem, "resYAttribute");
        result.tileTableNameAtribute = Config.readNameString(masterTableElem, "tileTableNameAtribute");
        result.spatialTableNameAtribute = Config.readNameString(masterTableElem, "spatialTableNameAtribute");
        Element tileTableElem = (Element)dom.getElementsByTagName("tileTable").item(0);
        if (tileTableElem != null) {
            result.blobAttributeNameInTileTable = Config.readNameString(tileTableElem, "blobAttributeName");
            result.keyAttributeNameInTileTable = Config.readNameString(tileTableElem, "keyAttributeName");
        }
        if ((spatialTableElem = (Element)dom.getElementsByTagName("spatialTable").item(0)) != null) {
            result.keyAttributeNameInSpatialTable = Config.readNameString(spatialTableElem, "keyAttributeName");
            result.geomAttributeNameInSpatialTable = Config.readNameString(spatialTableElem, "geomAttributeName");
            result.tileMaxXAttribute = Config.readNameString(spatialTableElem, "tileMaxXAttribute");
            result.tileMaxYAttribute = Config.readNameString(spatialTableElem, "tileMaxYAttribute");
            result.tileMinXAttribute = Config.readNameString(spatialTableElem, "tileMinXAttribute");
            result.tileMinYAttribute = Config.readNameString(spatialTableElem, "tileMinYAttribute");
        }
        result.verifyCardinality = Boolean.FALSE;
        Node tmp = dom.getElementsByTagName("verify").item(0);
        if (tmp != null) {
            NamedNodeMap map = tmp.getAttributes();
            String s = map.getNamedItem("cardinality").getNodeValue();
            result.verifyCardinality = new Boolean(s);
        }
    }

    static void readForOracleGeoRaster(Config result, Document dom) {
        result.masterTable = Config.readNameString(dom.getDocumentElement(), "masterTable");
        Element masterTableElem = (Element)dom.getElementsByTagName("masterTable").item(0);
        result.coverageNameAttribute = Config.readNameString(masterTableElem, "coverageNameAttribute");
        result.geoRasterAttribute = Config.readNameString(masterTableElem, "geoRasterAttribute");
    }

    static void readForCustom(Config result, Document dom) {
        result.jdbcAccessClassName = Config.readNameString(dom.getDocumentElement(), "jdbcAccessClassName");
    }

    private void initStatements() {
        StringBuffer buff = null;
        buff = new StringBuffer("update ").append(this.masterTable).append(" set ");
        buff.append(this.maxXAttribute).append(" = ?,");
        buff.append(this.maxYAttribute).append(" = ?,");
        buff.append(this.minXAttribute).append(" = ?,");
        buff.append(this.minYAttribute).append(" = ?");
        buff.append(" where ").append(this.coverageNameAttribute).append(" = ? ");
        if (this.tileTableNameAtribute != null) {
            buff.append(" and ").append(this.tileTableNameAtribute).append(" = ? ");
        }
        if (this.spatialTableNameAtribute != null) {
            buff.append(" and ").append(this.spatialTableNameAtribute).append(" = ? ");
        }
        this.sqlUpdateMosaicStatement = buff.toString();
        buff = new StringBuffer("select * from ").append(this.masterTable).append(" where ").append(this.coverageNameAttribute).append(" = ? ");
        this.sqlSelectCoverageStatement = buff.toString();
        buff = new StringBuffer("update ").append(this.masterTable).append(" set ");
        buff.append(this.resXAttribute).append(" = ?,");
        buff.append(this.resYAttribute).append(" = ? ");
        buff.append(" where ").append(this.coverageNameAttribute).append(" = ? ");
        if (this.tileTableNameAtribute != null) {
            buff.append(" and ").append(this.tileTableNameAtribute).append(" = ? ");
        }
        if (this.spatialTableNameAtribute != null) {
            buff.append(" and ").append(this.spatialTableNameAtribute).append(" = ? ");
        }
        this.sqlUpdateResStatement = buff.toString();
    }

    private static String readValueString(Document dom, String elemName) {
        Node n = Config.readValueAttribute(dom, elemName);
        if (n == null) {
            return null;
        }
        return n.getNodeValue();
    }

    private static String readNameString(Element elem, String elemName) {
        Node n = Config.readNameAttribute(elem, elemName);
        if (n == null) {
            return null;
        }
        return n.getNodeValue();
    }

    private static Integer readValueInteger(Document dom, String elemName) {
        Node n = Config.readValueAttribute(dom, elemName);
        if (n == null) {
            return null;
        }
        return new Integer(n.getNodeValue());
    }

    private static Node readValueAttribute(Document dom, String elemName) {
        NodeList list = dom.getElementsByTagName(elemName);
        Node n = list.item(0);
        if (n == null) {
            return null;
        }
        return n.getAttributes().getNamedItem("value");
    }

    private static Node readNameAttribute(Element elem, String elemName) {
        NodeList list = elem.getElementsByTagName(elemName);
        Node n = list.item(0);
        if (n == null) {
            return null;
        }
        return n.getAttributes().getNamedItem("name");
    }

    public Map<String, Object> getDataSourceParams() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if ("DBCP".equals(this.dstype)) {
            result.put(DBCPDataSourceFactory.DSTYPE.key, this.dstype);
            result.put(DBCPDataSourceFactory.USERNAME.key, this.username);
            result.put(DBCPDataSourceFactory.PASSWORD.key, this.password);
            result.put(DBCPDataSourceFactory.JDBC_URL.key, this.jdbcUrl);
            result.put(DBCPDataSourceFactory.DRIVERCLASS.key, this.driverClassName);
            result.put(DBCPDataSourceFactory.MAXACTIVE.key, this.maxActive);
            result.put(DBCPDataSourceFactory.MAXIDLE.key, this.maxIdle);
        }
        if ("JNDI".equals(this.dstype)) {
            result.put(JNDIDataSourceFactory.DSTYPE.key, this.dstype);
            result.put(JNDIDataSourceFactory.JNDI_REFNAME.key, this.jndiReferenceName);
        }
        return result;
    }

    public String getBlobAttributeNameInTileTable() {
        return this.blobAttributeNameInTileTable;
    }

    public String getKeyAttributeNameInSpatialTable() {
        return this.keyAttributeNameInSpatialTable;
    }

    public String getKeyAttributeNameInTileTable() {
        return this.keyAttributeNameInTileTable;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getJndiReferenceName() {
        return this.jndiReferenceName;
    }

    public String getSqlUpdateMosaicStatement() {
        return this.sqlUpdateMosaicStatement;
    }

    public String getSqlSelectCoverageStatement() {
        return this.sqlSelectCoverageStatement;
    }

    public String getSpatialTableNameAtribute() {
        return this.spatialTableNameAtribute;
    }

    public String getTileTableNameAtribute() {
        return this.tileTableNameAtribute;
    }

    public String getSqlUpdateResStatement() {
        return this.sqlUpdateResStatement;
    }

    public String getMaxXAttribute() {
        return this.maxXAttribute;
    }

    public String getMaxYAttribute() {
        return this.maxYAttribute;
    }

    public String getMinXAttribute() {
        return this.minXAttribute;
    }

    public String getMinYAttribute() {
        return this.minYAttribute;
    }

    public String getResXAttribute() {
        return this.resXAttribute;
    }

    public String getResYAttribute() {
        return this.resYAttribute;
    }

    public String getCoordsys() {
        return this.coordsys;
    }

    public String getCoverageName() {
        return this.coverageName;
    }

    public Integer getInterpolation() {
        return this.interpolation;
    }

    public String getXmlUrl() {
        return this.xmlUrl;
    }

    public Boolean getVerifyCardinality() {
        return this.verifyCardinality;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getMasterTable() {
        return this.masterTable;
    }

    public String getCoverageNameAttribute() {
        return this.coverageNameAttribute;
    }

    public String getGeoRasterAttribute() {
        return this.geoRasterAttribute;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getTileMaxXAttribute() {
        return this.tileMaxXAttribute;
    }

    public String getTileMaxYAttribute() {
        return this.tileMaxYAttribute;
    }

    public String getTileMinXAttribute() {
        return this.tileMinXAttribute;
    }

    public String getTileMinYAttribute() {
        return this.tileMinYAttribute;
    }

    public String getGeomAttributeNameInSpatialTable() {
        return this.geomAttributeNameInSpatialTable;
    }

    public SpatialExtension getSpatialExtension() {
        return this.spatialExtension;
    }

    public String getJdbcAccessClassName() {
        return this.jdbcAccessClassName;
    }

    public Boolean getIgnoreAxisOrder() {
        return this.ignoreAxisOrder;
    }
}

