/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.concurrent.LinkedBlockingQueue;
import javax.media.jai.Interpolation;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.ScaleDescriptor;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.TileQueueElement;
import org.geotools.geometry.GeneralEnvelope;

abstract class AbstractThread
extends Thread {
    LinkedBlockingQueue<TileQueueElement> tileQueue;
    Config config;
    GeneralEnvelope requestEnvelope;
    Rectangle pixelDimension;
    ImageLevelInfo levelInfo;
    double rescaleX;
    double rescaleY;
    double resX;
    double resY;

    AbstractThread(Rectangle pixelDimenison, GeneralEnvelope requestEnvelope, ImageLevelInfo levelInfo, LinkedBlockingQueue<TileQueueElement> tileQueue, Config config) {
        this.config = config;
        this.tileQueue = tileQueue;
        this.requestEnvelope = requestEnvelope;
        this.levelInfo = levelInfo;
        this.pixelDimension = pixelDimenison;
        this.resX = requestEnvelope.getSpan(0) / pixelDimenison.getWidth();
        this.resY = requestEnvelope.getSpan(1) / pixelDimenison.getHeight();
        this.rescaleX = levelInfo.getResX() / this.resX;
        this.rescaleY = levelInfo.getResY() / this.resY;
    }

    protected BufferedImage rescaleImageViaPlanarImage(BufferedImage image) {
        TiledImage planarImage = new TiledImage((RenderedImage)image, image.getWidth(), image.getHeight());
        int interpolation = 0;
        if (this.config.getInterpolation() == 2) {
            interpolation = 1;
        }
        if (this.config.getInterpolation() == 3) {
            interpolation = 2;
        }
        RenderedOp result = ScaleDescriptor.create((RenderedImage)planarImage, (Float)new Float(this.rescaleX), (Float)new Float(this.rescaleY), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)Interpolation.getInstance((int)interpolation), null);
        WritableRaster scaledImageRaster = (WritableRaster)result.getData();
        ColorModel colorModel = image.getColorModel();
        BufferedImage scaledImage = new BufferedImage(colorModel, scaledImageRaster, image.isAlphaPremultiplied(), null);
        return scaledImage;
    }
}

