/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Date;
import java.util.Map;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.common.util.NamedList;

public class SolrUtils {
    public static Class<?> decodeSolrFieldType(String className) {
        if (className.equals("org.apache.solr.schema.TextField") || className.equals("org.apache.solr.schema.StrField")) {
            return String.class;
        }
        if (className.equals("org.apache.solr.schema.TrieLongField") || className.equals("org.apache.solr.schema.LongField")) {
            return Long.class;
        }
        if (className.equals("org.apache.solr.schema.BoolField")) {
            return Boolean.class;
        }
        if (className.equals("org.apache.solr.schema.SpatialRecursivePrefixTreeFieldType") || className.equals("org.apache.solr.schema.LatLonType") || className.equals("org.apache.solr.schema.BBoxField") || className.equals("org.apache.solr.spatial.pending.BBoxFieldType")) {
            return Geometry.class;
        }
        if (className.equals("org.apache.solr.schema.DateField") || className.equals("org.apache.solr.schema.TrieDateField")) {
            return Date.class;
        }
        if (className.equals("org.apache.solr.schema.IntField") || className.equals("org.apache.solr.schema.TrieIntField")) {
            return Integer.class;
        }
        if (className.equals("org.apache.solr.schema.FloatField") || className.equals("org.apache.solr.schema.TrieFloatField")) {
            return Float.class;
        }
        if (className.equals("org.apache.solr.schema.DoubleField") || className.equals("org.apache.solr.schema.TrieDoubleField")) {
            return Double.class;
        }
        return null;
    }

    public static class ExtendedFieldSchemaInfo {
        private Boolean uniqueKey = false;
        private Boolean multivalued = false;

        public ExtendedFieldSchemaInfo(LukeResponse processSchema, LukeResponse processField, String fieldName) {
            NamedList om;
            String fn;
            NamedList schema = (NamedList)processSchema.getResponse().get("schema");
            NamedList flds = (NamedList)schema.get("fields");
            for (Map.Entry entry : flds) {
                fn = (String)entry.getKey();
                if (!fn.equals(fieldName)) continue;
                om = (NamedList)entry.getValue();
                if (om.get("uniqueKey") != null) {
                    this.uniqueKey = new Boolean(om.get("uniqueKey").toString());
                    break;
                }
                this.uniqueKey = false;
                break;
            }
            flds = (NamedList)processField.getResponse().get("fields");
            for (Map.Entry entry : flds) {
                fn = (String)entry.getKey();
                if (!fn.equals(fieldName)) continue;
                om = (NamedList)entry.getValue();
                if (om.get("schema") != null && om.get("schema").toString().contains("M")) {
                    this.multivalued = true;
                    break;
                }
                this.multivalued = false;
                break;
            }
        }

        public Boolean getUniqueKey() {
            return this.uniqueKey;
        }

        public Boolean getMultivalued() {
            return this.multivalued;
        }
    }
}

