/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.util.Locale;
import org.geotools.geometry.jts.JTS;
import org.opengis.feature.type.GeometryDescriptor;

public abstract class SolrSpatialStrategy {
    static final SolrSpatialStrategy DEFAULT = new DefaultStrategy();
    static final SolrSpatialStrategy BBOX = new BBoxStrategy();

    static SolrSpatialStrategy createStrategy(GeometryDescriptor att) {
        String solrType = (String)att.getUserData().get("solr_type");
        if (solrType != null && solrType.contains("BBoxField")) {
            return BBOX;
        }
        return DEFAULT;
    }

    public abstract String encode(Geometry var1);

    public abstract Geometry decode(String var1) throws ParseException;

    public static class BBoxStrategy
    extends SolrSpatialStrategy {
        @Override
        public String encode(Geometry geometry) {
            Envelope env = geometry.getEnvelopeInternal();
            return String.format(Locale.ENGLISH, "%f %f %f %f", env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY());
        }

        @Override
        public Geometry decode(String str) throws ParseException {
            String[] bbox = str.split("\\s+");
            if (bbox.length != 4) {
                throw new ParseException("Illegal bounding box: " + str);
            }
            Envelope env = new Envelope(Double.parseDouble(bbox[0]), Double.parseDouble(bbox[2]), Double.parseDouble(bbox[1]), Double.parseDouble(bbox[3]));
            return JTS.toGeometry((Envelope)env);
        }
    }

    public static class DefaultStrategy
    extends SolrSpatialStrategy {
        @Override
        public String encode(Geometry geometry) {
            WKTWriter writer = new WKTWriter();
            return writer.write(geometry);
        }

        @Override
        public Geometry decode(String str) throws ParseException {
            return new WKTReader().read(str);
        }
    }
}

