/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.ResourceInfo;
import org.geotools.data.solr.SolrAttribute;
import org.geotools.data.solr.SolrDataStore;
import org.geotools.data.solr.SolrFeatureReader;
import org.geotools.data.solr.SolrLayerConfiguration;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;

public class SolrFeatureSource
extends ContentFeatureSource {
    static final String KEY_SOLR_TYPE = "solr_type";

    public SolrFeatureSource(ContentEntry entry) {
        super(entry, Query.ALL);
    }

    public SolrDataStore getDataStore() {
        return (SolrDataStore)super.getDataStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        SingleCRS flatCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.getSchema().getCoordinateReferenceSystem());
        ReferencedEnvelope bounds = new ReferencedEnvelope((CoordinateReferenceSystem)flatCRS);
        SolrDataStore store = this.getDataStore();
        Filter[] split = this.splitFilter(query.getFilter(), (FeatureSource)this);
        Filter preFilter = split[0];
        Filter postFilter = split[1];
        Query preQuery = new Query(query);
        preQuery.setFilter(preFilter);
        SolrQuery q = this.getDataStore().select(this.getSchema(), preQuery);
        if (this.getDataStore().getLogger().isLoggable(Level.FINE)) {
            this.getDataStore().getLogger().log(Level.FINE, q.toString());
        }
        try {
            SolrFeatureReader reader = new SolrFeatureReader(this.getSchema(), store.getSolrServer(), q, this.getDataStore());
            if (postFilter != null && postFilter != Filter.INCLUDE) {
                reader = new FilteringFeatureReader((FeatureReader)reader, postFilter);
            }
            try {
                if (reader.hasNext()) {
                    SimpleFeature f = (SimpleFeature)reader.next();
                    bounds.init(f.getBounds());
                    while (reader.hasNext()) {
                        f = (SimpleFeature)reader.next();
                        bounds.include(f.getBounds());
                    }
                }
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCountInternal(Query query) throws IOException {
        int count = 0;
        try {
            SolrDataStore store = this.getDataStore();
            Filter[] split = this.splitFilter(query.getFilter(), (FeatureSource)this);
            Filter preFilter = split[0];
            Filter postFilter = split[1];
            if (postFilter != null && postFilter != Filter.INCLUDE) {
                try (FeatureReader reader = this.getReader(query);){
                    while (reader.hasNext()) {
                        reader.next();
                        ++count;
                    }
                }
                return count;
            }
            Query preQuery = new Query(query);
            preQuery.setFilter(preFilter);
            SolrQuery q = store.count(this.getSchema(), preQuery);
            if (store.getLogger().isLoggable(Level.FINE)) {
                store.getLogger().log(Level.FINE, q.toString());
            }
            HttpSolrServer server = store.getSolrServer();
            QueryResponse rsp = server.query((SolrParams)q);
            count = new Long(rsp.getResults().getNumFound() - rsp.getResults().getStart()).intValue();
            if (query.getMaxFeatures() > 0 && query.getMaxFeatures() < Integer.MAX_VALUE && count > query.getMaxFeatures()) {
                count = query.getMaxFeatures();
            }
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (IOException)new IOException().initCause(e);
        }
        return count;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        SolrFeatureReader reader;
        try {
            SolrDataStore store = this.getDataStore();
            Filter[] split = this.splitFilter(query.getFilter(), (FeatureSource)this);
            Filter preFilter = split[0];
            Filter postFilter = split[1];
            Query preQuery = new Query(query);
            preQuery.setFilter(preFilter);
            SimpleFeatureType[] types = this.buildQueryAndReturnFeatureTypes(this.getSchema(), query.getPropertyNames(), postFilter);
            SimpleFeatureType querySchema = types[0];
            SimpleFeatureType returnedSchema = types[1];
            SolrQuery q = store.select(querySchema, preQuery);
            if (store.getLogger().isLoggable(Level.FINE)) {
                store.getLogger().log(Level.FINE, q.toString());
            }
            reader = new SolrFeatureReader(querySchema, store.getSolrServer(), q, store);
            if (postFilter != null && postFilter != Filter.INCLUDE) {
                reader = new FilteringFeatureReader((FeatureReader)reader, postFilter);
                if (!returnedSchema.equals(querySchema)) {
                    reader = new ReTypeFeatureReader((FeatureReader)reader, returnedSchema);
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (IOException)new IOException().initCause(e);
        }
        return reader;
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        tb.setName(this.entry.getName());
        SolrLayerConfiguration layerConfiguration = this.getDataStore().getSolrConfigurations().get(this.entry.getTypeName());
        String pkField = null;
        if (layerConfiguration != null) {
            String defaultGeometryName = null;
            for (SolrAttribute attribute : layerConfiguration.getAttributes()) {
                AttributeDescriptor att;
                block10: {
                    if (!attribute.isUse().booleanValue()) continue;
                    att = null;
                    if (attribute.isPk().booleanValue()) {
                        pkField = attribute.getName();
                    }
                    if (Geometry.class.isAssignableFrom(attribute.getType())) {
                        Integer srid = attribute.getSrid();
                        try {
                            if (srid == null) break block10;
                            ab.setCRS(CRS.decode((String)("EPSG:" + srid)));
                            ab.setName(attribute.getName());
                            ab.setBinding(attribute.getType());
                            att = ab.buildDescriptor(attribute.getName(), ab.buildGeometryType());
                            if (attribute.isDefaultGeometry() != null && attribute.isDefaultGeometry().booleanValue()) {
                                defaultGeometryName = attribute.getName();
                            }
                        }
                        catch (Exception e) {
                            String msg = "Error occured determing srid for " + attribute.getName();
                            this.getDataStore().getLogger().log(Level.WARNING, msg, e);
                        }
                    } else {
                        ab.setName(attribute.getName());
                        ab.setBinding(attribute.getType());
                        att = ab.buildDescriptor(attribute.getName(), ab.buildType());
                    }
                }
                if (att == null) continue;
                att.getUserData().put(KEY_SOLR_TYPE, attribute.getSolrType());
                tb.add(att);
            }
            if (defaultGeometryName != null) {
                tb.setDefaultGeometry(defaultGeometryName);
            }
        }
        SimpleFeatureType ft = tb.buildFeatureType();
        if (pkField != null) {
            ft.getUserData().put("id_field", pkField);
        }
        return ft;
    }

    protected boolean canFilter() {
        return true;
    }

    protected boolean canRetype() {
        return true;
    }

    protected boolean canOffset() {
        return true;
    }

    protected boolean canSort() {
        return true;
    }

    protected boolean canLimit() {
        return true;
    }

    public ResourceInfo getInfo() {
        return super.getInfo();
    }

    private SimpleFeatureType[] buildQueryAndReturnFeatureTypes(SimpleFeatureType featureType, String[] propertyNames, Filter filter) {
        SimpleFeatureType returnedSchema;
        SimpleFeatureType[] types = null;
        if (propertyNames == Query.ALL_NAMES) {
            return new SimpleFeatureType[]{featureType, featureType};
        }
        SimpleFeatureType querySchema = returnedSchema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)featureType, (String[])propertyNames);
        if (filter != null && !filter.equals(Filter.INCLUDE)) {
            FilterAttributeExtractor extractor = new FilterAttributeExtractor(featureType);
            filter.accept((FilterVisitor)extractor, null);
            String[] extraAttributes = extractor.getAttributeNames();
            if (extraAttributes != null && extraAttributes.length > 0) {
                ArrayList<String> allAttributes = new ArrayList<String>(Arrays.asList(propertyNames));
                for (String extraAttribute : extraAttributes) {
                    if (allAttributes.contains(extraAttribute)) continue;
                    allAttributes.add(extraAttribute);
                }
                String[] allAttributeArray = allAttributes.toArray(new String[allAttributes.size()]);
                querySchema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), (String[])allAttributeArray);
            }
        }
        types = new SimpleFeatureType[]{querySchema, returnedSchema};
        return types;
    }

    private Filter[] splitFilter(Filter original, FeatureSource source) {
        Filter[] split = new Filter[2];
        if (original != null) {
            SolrFeatureSource featureSource = (SolrFeatureSource)source;
            PostPreProcessFilterSplittingVisitor splitter = new PostPreProcessFilterSplittingVisitor(this.getDataStore().getFilterCapabilities(), featureSource.getSchema(), null);
            original.accept((FilterVisitor)splitter, null);
            split[0] = splitter.getFilterPre();
            split[1] = splitter.getFilterPost();
        }
        return split;
    }
}

