/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.solr.SolrDataStore;
import org.geotools.data.solr.SolrLayerMapper;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.KVP;

public class SolrDataStoreFactory
extends AbstractDataStoreFactory {
    public static final DataAccessFactory.Param URL = new DataAccessFactory.Param("solr_url", URL.class, "Url to a SOLR server CORE", true, (Object)"http://localhost:8080/solr/collection1", (Map)new KVP(new Object[]{"level", "user"}));
    public static final DataAccessFactory.Param LAYER_MAPPER = new DataAccessFactory.Param("layer_mapper", String.class, "Controls how documents in the solr index are mapped to layers" + SolrLayerMapper.Type.values(), false, (Object)SolrLayerMapper.Type.FIELD.name(), (Map)new KVP(new Object[]{"level", "user"}));
    public static final DataAccessFactory.Param FIELD = new DataAccessFactory.Param("layer_name_field", String.class, "Field used in SOLR that holds the layer names", false, (Object)"layer_type", (Map)new KVP(new Object[]{"level", "user"}));
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "Namespace prefix", false, (Object)"solr");

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        URL url = (URL)URL.lookUp(params);
        String namespace = (String)NAMESPACE.lookUp(params);
        String mapperName = (String)LAYER_MAPPER.lookUp(params);
        SolrLayerMapper.Type mapperType = SolrLayerMapper.Type.FIELD;
        if (mapperName != null) {
            mapperType = SolrLayerMapper.Type.valueOf(mapperName.toUpperCase());
        }
        SolrLayerMapper mapper = mapperType.createMapper(params);
        SolrDataStore store = new SolrDataStore(url, mapper);
        store.setNamespaceURI(namespace);
        store.setFilterFactory(CommonFactoryFinder.getFilterFactory(null));
        return store;
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        return this.createDataStore(params);
    }

    public String getDescription() {
        return "Connect to SOLR server (HTTP) and extract features";
    }

    public String getDisplayName() {
        return "SOLR";
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{URL, LAYER_MAPPER, FIELD, NAMESPACE};
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean canProcess(Map params) {
        return super.canProcess(params);
    }
}

