/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.geotools.data.Query;
import org.geotools.data.solr.FieldLayerMapper;
import org.geotools.data.solr.FilterToSolr;
import org.geotools.data.solr.SolrAttribute;
import org.geotools.data.solr.SolrFeatureSource;
import org.geotools.data.solr.SolrLayerConfiguration;
import org.geotools.data.solr.SolrLayerMapper;
import org.geotools.data.solr.SolrUtils;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class SolrDataStore
extends ContentDataStore {
    private URL url;
    private SolrLayerMapper layerMapper;
    private List<Name> typeNames;
    private ArrayList<SolrAttribute> solrAttributes = new ArrayList();
    private SolrAttribute pk = null;
    private Map<String, SolrLayerConfiguration> solrConfigurations = new ConcurrentHashMap<String, SolrLayerConfiguration>();
    HttpSolrServer solrServer;

    public SolrDataStore(URL url, String field) {
        this(url, new FieldLayerMapper(field));
    }

    public SolrDataStore(URL url, SolrLayerMapper layerMapper) {
        this.url = url;
        this.layerMapper = layerMapper;
        this.solrServer = new HttpSolrServer(url.toString());
        this.solrServer.setAllowCompression(true);
        this.solrServer.setConnectionTimeout(10000);
        this.solrServer.setFollowRedirects(true);
        this.solrServer.setSoTimeout(10000);
    }

    public ArrayList<SolrAttribute> getSolrAttributes(String layerName) {
        if (this.solrAttributes.isEmpty()) {
            this.solrAttributes = new ArrayList();
            try {
                LukeRequest lq = new LukeRequest();
                lq.setShowSchema(true);
                LukeResponse processSchema = lq.process((SolrServer)this.solrServer);
                lq = new LukeRequest();
                lq.setShowSchema(false);
                LukeResponse processField = lq.process((SolrServer)this.solrServer);
                Map fis = processField.getFieldInfo();
                TreeSet keys = new TreeSet(fis.keySet());
                for (String k : keys) {
                    LukeResponse.FieldInfo fieldInfo = (LukeResponse.FieldInfo)fis.get(k);
                    String name = fieldInfo.getName();
                    String type = fieldInfo.getType();
                    LukeResponse.FieldTypeInfo fty = processSchema.getFieldTypeInfo(type);
                    if (fty == null) continue;
                    String solrTypeName = fty.getClassName();
                    Class<?> objType = SolrUtils.decodeSolrFieldType(solrTypeName);
                    if (objType != null) {
                        SolrUtils.ExtendedFieldSchemaInfo extendedFieldSchemaInfo = new SolrUtils.ExtendedFieldSchemaInfo(processSchema, processField, name);
                        SolrAttribute at = new SolrAttribute(name, objType);
                        at.setSolrType(solrTypeName);
                        if (extendedFieldSchemaInfo.getUniqueKey().booleanValue()) {
                            at.setPk(true);
                            at.setUse(true);
                        }
                        if (extendedFieldSchemaInfo.getMultivalued().booleanValue() && !Geometry.class.isAssignableFrom(at.getType())) {
                            at.setType(String.class);
                        }
                        at.setEmpty(fieldInfo.getDocs() == 0);
                        this.solrAttributes.add(at);
                        continue;
                    }
                    if (!this.LOGGER.isLoggable(Level.FINE)) continue;
                    this.LOGGER.log(Level.FINE, "Skipping attribute " + fty.getName() + " as we don't know how to map its type to a java object " + fty.getClassName());
                }
                List<BeanComparator> sortFields = Arrays.asList(new BeanComparator("empty"), new BeanComparator("name"));
                ComparatorChain multiSort = new ComparatorChain(sortFields);
                Collections.sort(this.solrAttributes, multiSort);
            }
            catch (Exception ex) {
                this.LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return this.solrAttributes;
    }

    protected List<Name> createTypeNames() throws IOException {
        try {
            if (this.typeNames == null || this.typeNames.isEmpty()) {
                ArrayList<Name> names = new ArrayList<Name>();
                for (String name : this.layerMapper.createTypeNames(this.solrServer)) {
                    names.add((Name)new NameImpl(this.namespaceURI, name));
                }
                this.typeNames = names;
            }
        }
        catch (Exception ex) {
            this.LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return this.typeNames;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        ContentEntry type = this.ensureEntry(entry.getName());
        return new SolrFeatureSource(type);
    }

    public FilterFactory getFilterFactory() {
        return CommonFactoryFinder.getFilterFactory2();
    }

    public FilterCapabilities getFilterCapabilities() {
        FilterToSolr f2s = new FilterToSolr(null);
        return f2s.getCapabilities();
    }

    public Map<String, SolrLayerConfiguration> getSolrConfigurations() {
        return this.solrConfigurations;
    }

    public void setSolrConfigurations(SolrLayerConfiguration configuration) {
        this.entries.remove(new NameImpl(this.namespaceURI, configuration.getLayerName()));
        this.solrConfigurations.put(configuration.getLayerName(), configuration);
    }

    public URL getUrl() {
        return this.url;
    }

    public String getField() {
        if (this.layerMapper instanceof FieldLayerMapper) {
            return ((FieldLayerMapper)this.layerMapper).getField();
        }
        throw new IllegalStateException("Layer mapper not instance of " + FieldLayerMapper.class.getName());
    }

    public SolrLayerMapper getLayerMapper() {
        return this.layerMapper;
    }

    public SolrAttribute getPrimaryKey(String layerName) {
        if (this.pk == null) {
            ArrayList<SolrAttribute> attributes = this.getSolrAttributes(layerName);
            for (SolrAttribute at : attributes) {
                if (!at.isPk().booleanValue()) continue;
                this.pk = at;
                break;
            }
        }
        return this.pk;
    }

    protected SolrQuery select(SimpleFeatureType featureType, Query q) {
        SolrQuery query = new SolrQuery();
        query.setParam("omitHeader", true);
        try {
            if (q.getPropertyNames() != null) {
                for (String prop : q.getPropertyNames()) {
                    query.addField(prop);
                }
            }
            query.setQuery("*:*");
            if (q.getStartIndex() != null && q.getStartIndex() >= 0) {
                query.setStart(q.getStartIndex());
            }
            if (q.getMaxFeatures() > 0) {
                query.setRows(Integer.valueOf(q.getMaxFeatures()));
            }
            SolrQuery.ORDER naturalSortOrder = SolrQuery.ORDER.asc;
            if (q.getSortBy() != null) {
                for (SortBy sort : q.getSortBy()) {
                    if (sort.getPropertyName() != null) {
                        query.addSort(sort.getPropertyName().getPropertyName(), sort.getSortOrder().equals((Object)SortOrder.ASCENDING) ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
                        continue;
                    }
                    naturalSortOrder = sort.getSortOrder().equals((Object)SortOrder.ASCENDING) ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc;
                }
            }
            query.addSort(this.getPrimaryKey(featureType.getTypeName()).getName(), naturalSortOrder);
            FilterToSolr f2s = this.initializeFilterToSolr(featureType);
            String fq = this.layerMapper.prepareFilterQuery(featureType);
            Filter simplified = SimplifyingFilterVisitor.simplify((Filter)q.getFilter(), (FeatureType)featureType);
            String ffq = f2s.encodeToString(simplified);
            if (ffq != null && !ffq.isEmpty()) {
                fq = fq != null ? fq + " AND " + ffq : ffq;
            }
            query.setFilterQueries(new String[]{fq});
            this.addViewparams(q, query);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return query;
    }

    protected SolrQuery count(SimpleFeatureType featureType, Query q) {
        SolrQuery query = new SolrQuery();
        query.setParam("omitHeader", true);
        query.setQuery("*:*");
        query.setFields(new String[]{this.getPrimaryKey(featureType.getName().getLocalPart()).getName()});
        try {
            if (q.getStartIndex() != null && q.getStartIndex() >= 0) {
                query.setStart(q.getStartIndex());
            }
            query.setRows(Integer.valueOf(0));
            FilterToSolr f2s = this.initializeFilterToSolr(featureType);
            String fq = this.layerMapper.prepareFilterQuery(featureType);
            String ffq = f2s.encodeToString(q.getFilter());
            if (ffq != null && !ffq.isEmpty()) {
                fq = fq != null ? fq + " AND " + ffq : ffq;
            }
            query.setFilterQueries(new String[]{fq});
            this.addViewparams(q, query);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return query;
    }

    private FilterToSolr initializeFilterToSolr(SimpleFeatureType featureType) {
        FilterToSolr f2s = new FilterToSolr(featureType);
        f2s.setPrimaryKey(this.getPrimaryKey(featureType.getName().getLocalPart()));
        f2s.setFeatureTypeName(featureType.getName().getLocalPart());
        return f2s;
    }

    private void addViewparams(Query q, SolrQuery query) {
        Map parameters;
        String qViewParamers = null;
        String fqViewParamers = null;
        Hints hints = q.getHints();
        if (hints != null && (parameters = (Map)hints.get((Object)Hints.VIRTUAL_TABLE_PARAMETERS)) != null) {
            for (String param : parameters.keySet()) {
                if (param.equalsIgnoreCase("q")) {
                    qViewParamers = (String)parameters.get(param);
                }
                if (!param.equalsIgnoreCase("fq")) continue;
                fqViewParamers = (String)parameters.get(param);
            }
        }
        if (qViewParamers != null && !qViewParamers.isEmpty()) {
            query.set("q", new String[]{query.get("q").concat(" AND ").concat(qViewParamers)});
        }
        if (fqViewParamers != null && !fqViewParamers.isEmpty()) {
            query.addFilterQuery(new String[]{fqViewParamers});
        }
    }

    HttpSolrServer getSolrServer() {
        return this.solrServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.solrServer.shutdown();
        }
        finally {
            super.dispose();
        }
    }
}

