/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.solr.ExpressionToSolr;
import org.geotools.data.solr.SolrAttribute;
import org.geotools.data.solr.SolrSpatialStrategy;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class FilterToSolr
implements FilterVisitor {
    private static Logger LOGGER = Logging.getLogger(FilterToSolr.class);
    private static final String[] LUCENE_SPECIAL_CHARACTERS = new String[]{"+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", ":"};
    protected static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    protected Writer out;
    protected FilterCapabilities capabilities = null;
    private SolrAttribute primaryKey;
    private String featureTypeName;
    private SimpleFeatureType featureType;

    public FilterToSolr(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public String encodeToString(Filter filter) throws Exception {
        StringWriter out = new StringWriter();
        this.out = out;
        this.encode(filter);
        return out.getBuffer().toString();
    }

    public void encode(Filter filter) throws Exception {
        if (this.out == null) {
            throw new Exception("Can't encode to a null writer.");
        }
        if (this.getCapabilities().fullySupports(filter)) {
            try {
                filter.accept((FilterVisitor)this, (Object)this.out);
            }
            catch (Exception ioe) {
                LOGGER.warning("Unable to export filter" + ioe);
                throw new Exception("Problem writing filter: ", ioe);
            }
        } else {
            throw new Exception("Filter type not supported");
        }
    }

    public FilterCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = this.createFilterCapabilities();
        }
        return this.capabilities;
    }

    protected FilterCapabilities createFilterCapabilities() {
        this.capabilities = new FilterCapabilities();
        this.capabilities.addAll(FilterCapabilities.LOGICAL_OPENGIS);
        this.capabilities.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        this.capabilities.addType(0x400000L);
        this.capabilities.addType(4096L);
        this.capabilities.addType(2048L);
        this.capabilities.addType(8192L);
        this.capabilities.addType(1L);
        this.capabilities.addType(4L);
        this.capabilities.addType(64L);
        this.capabilities.addType(8L);
        this.capabilities.addType(128L);
        this.capabilities.addType(After.class);
        this.capabilities.addType(Before.class);
        this.capabilities.addType(Begins.class);
        this.capabilities.addType(BegunBy.class);
        this.capabilities.addType(During.class);
        this.capabilities.addType(Ends.class);
        this.capabilities.addType(EndedBy.class);
        this.capabilities.addType(TContains.class);
        this.capabilities.addType(TEquals.class);
        return this.capabilities;
    }

    public Object visitNullFilter(Object extraData) {
        return extraData;
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        output.append("-*:*");
        return output;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        output.append("*:*");
        return output;
    }

    public Object visit(And filter, Object extraData) {
        return this.buildBinaryLogicalOperator("AND", this, (BinaryLogicOperator)filter, extraData);
    }

    public Object visit(Id filter, Object extraData) {
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        Set ids = filter.getIdentifiers();
        output.append(" (");
        Iterator i = ids.iterator();
        while (i.hasNext()) {
            Identifier id = (Identifier)i.next();
            String fid = this.decodeFID(id.toString());
            output.write(this.primaryKey.getName() + ":" + "\"" + fid + "\"");
            if (!i.hasNext()) continue;
            output.write(" OR ");
        }
        output.append(") ");
        return output;
    }

    public Object visit(Not filter, Object extraData) {
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        output.append("NOT (");
        filter.getFilter().accept((FilterVisitor)this, (Object)output);
        output.append(")");
        return output;
    }

    public Object visit(Or filter, Object extraData) {
        return this.buildBinaryLogicalOperator("OR", this, (BinaryLogicOperator)filter, extraData);
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        this.checkExpressionIsProperty(filter.getExpression());
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        ExpressionToSolr visitor = new ExpressionToSolr();
        PropertyName propertyName = (PropertyName)filter.getExpression();
        propertyName.accept((ExpressionVisitor)visitor, (Object)output);
        output.append(":[");
        filter.getLowerBoundary().accept((ExpressionVisitor)visitor, (Object)output);
        output.append(" TO ");
        filter.getUpperBoundary().accept((ExpressionVisitor)visitor, (Object)output);
        output.append("]");
        return output;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.buildComparison((BinaryComparisonOperator)filter, extraData);
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.buildComparison((BinaryComparisonOperator)filter, extraData);
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        Expression[] expr = this.binaryFilterVisitorNormalizer(filter.getExpression1(), filter.getExpression2());
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        ExpressionToSolr visitor = new ExpressionToSolr();
        PropertyName propertyName = (PropertyName)expr[0];
        propertyName.accept((ExpressionVisitor)visitor, (Object)output);
        output.append(":{");
        expr[1].accept((ExpressionVisitor)visitor, (Object)output);
        output.append(" TO *}");
        return output;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        Expression[] expr = this.binaryFilterVisitorNormalizer(filter.getExpression1(), filter.getExpression2());
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        ExpressionToSolr visitor = new ExpressionToSolr();
        PropertyName propertyName = (PropertyName)expr[0];
        propertyName.accept((ExpressionVisitor)visitor, (Object)output);
        output.append(":[");
        expr[1].accept((ExpressionVisitor)visitor, (Object)output);
        output.append(" TO *]");
        return output;
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        Expression[] expr = this.binaryFilterVisitorNormalizer(filter.getExpression1(), filter.getExpression2());
        this.checkExpressionIsProperty(filter.getExpression1());
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        ExpressionToSolr visitor = new ExpressionToSolr();
        PropertyName propertyName = (PropertyName)expr[0];
        propertyName.accept((ExpressionVisitor)visitor, (Object)output);
        output.append(":{* TO ");
        expr[1].accept((ExpressionVisitor)visitor, (Object)output);
        output.append("}");
        return output;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        Expression[] expr = this.binaryFilterVisitorNormalizer(filter.getExpression1(), filter.getExpression2());
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        ExpressionToSolr visitor = new ExpressionToSolr();
        PropertyName propertyName = (PropertyName)expr[0];
        propertyName.accept((ExpressionVisitor)visitor, (Object)output);
        output.append(":[* TO ");
        expr[1].accept((ExpressionVisitor)visitor, (Object)output);
        output.append("]");
        return output;
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        this.checkExpressionIsProperty(filter.getExpression());
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        String pattern = FilterToSolr.escapeSpecialCharacters(filter.getLiteral(), filter.getEscape());
        pattern = pattern.replace(filter.getWildCard(), ".*");
        pattern = pattern.replace(filter.getSingleChar(), ".{1,1}");
        Expression expr = filter.getExpression();
        ExpressionToSolr visitor = new ExpressionToSolr();
        expr.accept((ExpressionVisitor)visitor, (Object)output);
        output.append(":/");
        output.append(pattern);
        output.append("/ ");
        return output;
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        this.checkExpressionIsProperty(filter.getExpression());
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        ExpressionToSolr visitor = new ExpressionToSolr();
        PropertyName propertyName = (PropertyName)filter.getExpression();
        output.append("-");
        propertyName.accept((ExpressionVisitor)visitor, (Object)output);
        output.append(":[* TO *]");
        return output;
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException("PropertyIsNil filter not supported");
    }

    public Object visit(BBOX filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Equals filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Within filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(After after, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)after, extraData);
    }

    public Object visit(Before before, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)before, extraData);
    }

    public Object visit(Begins begins, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)begins, extraData);
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)begunBy, extraData);
    }

    public Object visit(Ends ends, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)ends, extraData);
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)endedBy, extraData);
    }

    public Object visit(During during, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)during, extraData);
    }

    public Object visit(TContains contains, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)contains, extraData);
    }

    public Object visit(TEquals equals, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)equals, extraData);
    }

    public Object visit(Beyond filter, Object extraData) {
        throw new UnsupportedOperationException("Beyond filter not supported");
    }

    public Object visit(Crosses filter, Object extraData) {
        throw new UnsupportedOperationException("Crosses filter not supported");
    }

    public Object visit(DWithin filter, Object extraData) {
        throw new UnsupportedOperationException("DWithin filter not supported");
    }

    public Object visit(Overlaps filter, Object extraData) {
        throw new UnsupportedOperationException("Overlaps filter not supported");
    }

    public Object visit(Touches filter, Object extraData) {
        throw new UnsupportedOperationException("Touches filter not supported");
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        throw new UnsupportedOperationException("AnyInteracts filter not supported");
    }

    public Object visit(Meets meets, Object extraData) {
        throw new UnsupportedOperationException("Meets filter not supported");
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw new UnsupportedOperationException("MetBy filter not supported");
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw new UnsupportedOperationException("OverlappedBy filter not supported");
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw new UnsupportedOperationException("TOverlaps filter not supported");
    }

    public void setFeatureTypeName(String featureTypeName) {
        this.featureTypeName = featureTypeName;
    }

    public void setPrimaryKey(SolrAttribute primaryKey) {
        this.primaryKey = primaryKey;
    }

    protected static StringWriter asStringWriter(Object extraData) {
        if (extraData instanceof StringWriter) {
            return (StringWriter)extraData;
        }
        return new StringWriter();
    }

    protected static String escapeSpecialCharacters(String searchPhrase, String ... otherEscapes) {
        for (int i = 0; i < LUCENE_SPECIAL_CHARACTERS.length; ++i) {
            searchPhrase = searchPhrase.replace(LUCENE_SPECIAL_CHARACTERS[i], "\\" + LUCENE_SPECIAL_CHARACTERS[i]);
        }
        for (String e : otherEscapes) {
            searchPhrase = searchPhrase.replace(e, "\\" + e);
        }
        return searchPhrase;
    }

    private void checkExpressionIsProperty(Expression expr) {
        if (!(expr instanceof PropertyName)) {
            throw new RuntimeException("SOLR requires a PropertyName");
        }
    }

    private void checkExpressionIsLiteral(Expression expr) {
        if (!(expr instanceof Literal)) {
            throw new RuntimeException("SOLR requires a Literal");
        }
    }

    private Object buildComparison(BinaryComparisonOperator filter, Object extraData) {
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        if (filter instanceof PropertyIsNotEqualTo) {
            output.append("-");
        }
        Expression[] expr = this.binaryFilterVisitorNormalizer(filter.getExpression1(), filter.getExpression2());
        ExpressionToSolr visitor = new ExpressionToSolr();
        expr[0].accept((ExpressionVisitor)visitor, (Object)output);
        output.append(":");
        expr[1].accept((ExpressionVisitor)visitor, (Object)output);
        return output;
    }

    private Object buildBinaryLogicalOperator(String operator, FilterVisitor visitor, BinaryLogicOperator filter, Object extraData) {
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        List children = filter.getChildren();
        if (children != null) {
            Iterator i = children.iterator();
            while (i.hasNext()) {
                Filter child = (Filter)i.next();
                if (child instanceof BinaryLogicOperator) {
                    output.append("(");
                }
                child.accept(visitor, (Object)output);
                if (child instanceof BinaryLogicOperator) {
                    output.append(")");
                }
                if (!i.hasNext()) continue;
                output.append(" ").append(operator).append(" ");
            }
        }
        return output;
    }

    private Object visitBinaryTemporalOperator(BinaryTemporalOperator filter, Object extraData) {
        PropertyName propertyName;
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        Expression e1 = filter.getExpression1();
        Expression e2 = filter.getExpression2();
        ExpressionToSolr visitor = new ExpressionToSolr((Filter)filter);
        if (filter instanceof After) {
            this.checkExpressionIsProperty(e1);
            this.checkExpressionIsLiteral(e2);
            propertyName = (PropertyName)e1;
            propertyName.accept((ExpressionVisitor)visitor, (Object)output);
            output.append(":{");
            e2.accept((ExpressionVisitor)visitor, (Object)output);
            output.append(" TO *}");
        }
        if (filter instanceof Before) {
            this.checkExpressionIsProperty(e1);
            this.checkExpressionIsLiteral(e2);
            propertyName = (PropertyName)e1;
            propertyName.accept((ExpressionVisitor)visitor, (Object)output);
            output.append(":{* TO ");
            e2.accept((ExpressionVisitor)visitor, (Object)output);
            output.append("}");
        }
        if (filter instanceof Begins || filter instanceof Ends || filter instanceof TEquals) {
            this.checkExpressionIsProperty(e1);
            this.checkExpressionIsLiteral(e2);
            propertyName = (PropertyName)e1;
            propertyName.accept((ExpressionVisitor)visitor, (Object)output);
            output.append(":");
            e2.accept((ExpressionVisitor)visitor, (Object)output);
        }
        if (filter instanceof BegunBy || filter instanceof EndedBy) {
            this.checkExpressionIsProperty(e2);
            this.checkExpressionIsLiteral(e1);
            propertyName = (PropertyName)e2;
            propertyName.accept((ExpressionVisitor)visitor, (Object)output);
            output.append(":");
            e1.accept((ExpressionVisitor)visitor, (Object)output);
        }
        if (filter instanceof During) {
            this.checkExpressionIsProperty(e1);
            this.checkExpressionIsLiteral(e2);
            propertyName = (PropertyName)e1;
            propertyName.accept((ExpressionVisitor)visitor, (Object)output);
            output.append(":{");
            e2.accept((ExpressionVisitor)visitor, (Object)output);
            output.append("}");
        }
        if (filter instanceof TContains) {
            this.checkExpressionIsProperty(e2);
            this.checkExpressionIsLiteral(e1);
            propertyName = (PropertyName)e2;
            propertyName.accept((ExpressionVisitor)visitor, (Object)output);
            output.append(":{");
            e1.accept((ExpressionVisitor)visitor, (Object)output);
            output.append("}");
        }
        return output;
    }

    private Object visitBinarySpatialOperator(BinarySpatialOperator filter, Object extraData) {
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        Expression e1 = filter.getExpression1();
        this.checkExpressionIsProperty(e1);
        Expression e2 = filter.getExpression2();
        this.checkExpressionIsLiteral(e2);
        ExpressionToSolr visitor = new ExpressionToSolr();
        AttributeDescriptor spatialAtt = (AttributeDescriptor)e1.evaluate((Object)this.featureType);
        if (spatialAtt != null && spatialAtt instanceof GeometryDescriptor) {
            visitor.setSpatialStrategy(SolrSpatialStrategy.createStrategy((GeometryDescriptor)spatialAtt));
        } else {
            LOGGER.warning("Spatial field: " + e1.toString() + " resolved to null or non-spatial");
        }
        e1.accept((ExpressionVisitor)visitor, extraData);
        if (filter instanceof BBOX) {
            output.append(":\"Intersects(");
            e2.accept((ExpressionVisitor)visitor, extraData);
            output.append(")\"");
        } else if (filter instanceof Disjoint) {
            output.append(":\"IsDisjointTo(");
            e2.accept((ExpressionVisitor)visitor, extraData);
            output.append(")\"");
        } else if (filter instanceof Within) {
            output.append(":\"IsWithin(");
            e2.accept((ExpressionVisitor)visitor, extraData);
            output.append(")\"");
        } else if (filter instanceof Intersects) {
            output.append(":\"Intersects(");
            e2.accept((ExpressionVisitor)visitor, extraData);
            output.append(")\"");
        } else if (filter instanceof Contains) {
            output.append(":\"Contains(");
            e2.accept((ExpressionVisitor)visitor, extraData);
            output.append(")\"");
        } else {
            throw new RuntimeException("Unsupported filter type " + filter.getClass());
        }
        return output;
    }

    private String decodeFID(String FID) {
        if (FID.startsWith(this.featureTypeName + ".")) {
            FID = FID.substring(this.featureTypeName.length() + 1);
        }
        try {
            FID = URLDecoder.decode(FID, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return FID;
    }

    private Expression[] binaryFilterVisitorNormalizer(Expression expr1, Expression expr2) {
        Expression e1 = null;
        Expression e2 = null;
        if (expr1 instanceof PropertyName && expr2 instanceof Literal) {
            e1 = expr1;
            e2 = expr2;
        } else if (expr2 instanceof Literal && expr2 instanceof PropertyName) {
            e1 = expr2;
            e2 = expr1;
        } else {
            throw new UnsupportedOperationException("Expressions must be one PropertyName and one Literal");
        }
        return new Expression[]{e1, e2};
    }
}

