/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import com.vividsolutions.jts.densify.Densifier;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.solr.FilterToSolr;
import org.geotools.data.solr.SolrSpatialStrategy;
import org.geotools.geometry.jts.JTS;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.TContains;
import org.opengis.temporal.Period;

public class ExpressionToSolr
implements ExpressionVisitor {
    private static Logger LOGGER = Logging.getLogger(ExpressionToSolr.class);
    private static final Envelope WORLD = new Envelope(-180.0, 180.0, -90.0, 90.0);
    private static final double SOLR_DISTANCE_TOLERANCE = 180.0;
    protected SimpleDateFormat dateFormatUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private Filter filter;
    private SolrSpatialStrategy spatialStrategy;

    public ExpressionToSolr() {
        this.dateFormatUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public ExpressionToSolr(Filter filter) {
        this();
        this.filter = filter;
    }

    public void setSpatialStrategy(SolrSpatialStrategy spatialStrategy) {
        this.spatialStrategy = spatialStrategy;
    }

    public Object visit(NilExpression expression, Object extraData) {
        throw new UnsupportedOperationException("Nil expression not supported");
    }

    public Object visit(Add expression, Object extraData) {
        throw new UnsupportedOperationException("Add expression not supported");
    }

    public Object visit(Divide expression, Object extraData) {
        throw new UnsupportedOperationException("Divide expression not supported");
    }

    public Object visit(Function expression, Object extraData) {
        throw new UnsupportedOperationException("Function expression not supported");
    }

    public Object visit(Multiply expression, Object extraData) {
        throw new UnsupportedOperationException("Multiply expression not supported");
    }

    public Object visit(Subtract expression, Object extraData) {
        throw new UnsupportedOperationException("Subtract expression not supported");
    }

    public Object visit(Literal expression, Object extraData) {
        StringBuffer temp = new StringBuffer("");
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        Object literal = expression.getValue();
        if (literal instanceof Geometry) {
            Envelope env;
            if (this.spatialStrategy == null) {
                throw new IllegalStateException("Attempt to encode geometry literal but spatialStrategy is null");
            }
            Geometry geometry = (Geometry)literal;
            if (!WORLD.contains(geometry.getEnvelopeInternal()) && !WORLD.equals((Object)geometry.getEnvelopeInternal())) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("SOLR cannot deal with filters using geometries that span beyond the whole world, clip feature geometry to world");
                }
                geometry = geometry.intersection((Geometry)JTS.toGeometry((Envelope)WORLD));
            }
            if ((env = geometry.getEnvelopeInternal()).getWidth() > 180.0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Split segment exceeds the 180 degree longitude limit to conform to SOLR WKT manager specification");
                }
                Densifier densifier = new Densifier(geometry);
                densifier.setDistanceTolerance(180.0);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Original geometry: " + geometry.toText());
                }
                geometry = densifier.getResultGeometry();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Densified geometry: " + geometry.toText());
                }
            }
            temp.append(this.spatialStrategy.encode(geometry));
        } else if (literal instanceof Number) {
            temp.append(literal.toString());
        } else if (literal instanceof Date) {
            temp.append("\"" + this.dateFormatUTC.format(literal) + "\"");
        } else if (literal instanceof Period) {
            Period period;
            if (this.filter instanceof After) {
                period = (Period)literal;
                temp.append(this.dateFormatUTC.format(period.getEnding().getPosition().getDate()));
            }
            if (this.filter instanceof Before || this.filter instanceof Begins || this.filter instanceof BegunBy) {
                period = (Period)literal;
                temp.append("\"" + this.dateFormatUTC.format(period.getBeginning().getPosition().getDate()) + "\"");
            }
            if (this.filter instanceof Ends || this.filter instanceof EndedBy) {
                period = (Period)literal;
                temp.append("\"" + this.dateFormatUTC.format(period.getEnding().getPosition().getDate()) + "\"");
            }
            if (this.filter instanceof During || this.filter instanceof TContains) {
                period = (Period)literal;
                temp.append("\"" + this.dateFormatUTC.format(period.getBeginning().getPosition().getDate()) + "\"");
                temp.append(" TO ");
                temp.append("\"" + this.dateFormatUTC.format(period.getEnding().getPosition().getDate()) + "\"");
            }
        } else {
            String escaped = FilterToSolr.escapeSpecialCharacters(literal.toString(), new String[0]);
            escaped = "\"" + escaped + "\"";
            temp.append(escaped);
        }
        output.append(temp);
        return temp;
    }

    public Object visit(PropertyName expression, Object extraData) {
        StringBuffer temp = new StringBuffer("");
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        temp.append(expression.getPropertyName());
        output.append(temp);
        return temp;
    }
}

