/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv.parse;

import com.csvreader.CsvReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.csv.CSVFileState;
import org.geotools.data.csv.parse.CSVIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class CSVStrategy {
    protected final CSVFileState csvFileState;
    protected volatile SimpleFeatureType featureType = null;

    public CSVStrategy(CSVFileState csvFileState) {
        this.csvFileState = csvFileState;
    }

    public CSVIterator iterator() throws IOException {
        return new CSVIterator(this.csvFileState, this);
    }

    protected abstract SimpleFeatureType buildFeatureType();

    public abstract void createSchema(SimpleFeatureType var1) throws IOException;

    public abstract SimpleFeature decode(String var1, String[] var2);

    public abstract String[] encode(SimpleFeature var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeatureType getFeatureType() {
        if (this.featureType == null) {
            CSVStrategy cSVStrategy = this;
            synchronized (cSVStrategy) {
                if (this.featureType == null) {
                    this.featureType = this.buildFeatureType();
                }
            }
        }
        return this.featureType;
    }

    public static SimpleFeatureTypeBuilder createBuilder(CSVFileState csvFileState) {
        CsvReader csvReader = null;
        Map<String, Class<?>> typesFromData = null;
        String[] headers = null;
        try {
            csvReader = csvFileState.openCSVReader();
            headers = csvReader.getHeaders();
            typesFromData = CSVStrategy.findMostSpecificTypesFromData(csvReader, headers);
        }
        catch (IOException e) {
            throw new RuntimeException("Failure reading csv file", e);
        }
        finally {
            if (csvReader != null) {
                csvReader.close();
            }
        }
        return CSVStrategy.createBuilder(csvFileState, headers, typesFromData);
    }

    public static SimpleFeatureTypeBuilder createBuilder(CSVFileState csvFileState, String[] headers, Map<String, Class<?>> typesFromData) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(csvFileState.getTypeName());
        builder.setCRS(csvFileState.getCrs());
        if (csvFileState.getNamespace() != null) {
            builder.setNamespaceURI(csvFileState.getNamespace());
        }
        for (String col : headers) {
            Class<?> type = typesFromData.get(col);
            builder.add(col, type);
        }
        return builder;
    }

    protected static Map<String, Class<?>> findMostSpecificTypesFromData(CsvReader csvReader, String[] headers) throws IOException {
        HashMap result = new HashMap();
        for (String header : headers) {
            result.put(header, Integer.class);
        }
        while (csvReader.readRecord()) {
            String[] record = csvReader.getValues();
            List<String> values = Arrays.asList(record);
            if (record.length >= headers.length) {
                values = values.subList(0, headers.length);
            }
            int i = 0;
            for (String value : values) {
                String header = headers[i];
                Class type = (Class<String>)result.get(header);
                if (type == Integer.class) {
                    try {
                        Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        try {
                            Double.parseDouble(value);
                            type = Double.class;
                        }
                        catch (NumberFormatException ex) {
                            type = String.class;
                        }
                    }
                } else if (type == Double.class) {
                    try {
                        Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        type = String.class;
                    }
                } else {
                    type = String.class;
                }
                result.put(header, type);
                ++i;
            }
        }
        return result;
    }

    protected static boolean isNumeric(Class<?> clazz) {
        return clazz != null && (clazz == Double.class || clazz == Integer.class);
    }
}

