/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv.parse;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geotools.data.csv.CSVFileState;
import org.geotools.data.csv.parse.CSVStrategy;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CSVSpecifiedLatLngStrategy
extends CSVStrategy {
    private final String latField;
    private final String lngField;
    private final String pointField;

    public CSVSpecifiedLatLngStrategy(CSVFileState csvFileState, String latField, String lngField, String pointField) {
        super(csvFileState);
        this.latField = latField;
        this.lngField = lngField;
        this.pointField = pointField;
    }

    public CSVSpecifiedLatLngStrategy(CSVFileState csvFileState, String latField, String lngField) {
        this(csvFileState, latField, lngField, "location");
    }

    @Override
    protected SimpleFeatureType buildFeatureType() {
        Map<String, Class<?>> typesFromData;
        String[] headers;
        try (CsvReader csvReader = null;){
            csvReader = this.csvFileState.openCSVReader();
            headers = csvReader.getHeaders();
            typesFromData = CSVStrategy.findMostSpecificTypesFromData(csvReader, headers);
        }
        SimpleFeatureTypeBuilder builder = CSVStrategy.createBuilder(this.csvFileState, headers, typesFromData);
        Class<?> latClass = typesFromData.get(this.latField);
        Class<?> lngClass = typesFromData.get(this.lngField);
        if (CSVStrategy.isNumeric(latClass) && CSVStrategy.isNumeric(lngClass)) {
            List<String> csvHeaders = Arrays.asList(headers);
            int index = csvHeaders.indexOf(this.latField);
            AttributeTypeBuilder builder2 = new AttributeTypeBuilder();
            builder2.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            builder2.binding(Point.class);
            AttributeDescriptor descriptor = builder2.buildDescriptor(this.pointField);
            builder.add(index, descriptor);
            builder.remove(this.latField);
            builder.remove(this.lngField);
        }
        return builder.buildFeatureType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        ArrayList<String> header = new ArrayList<String>();
        GeometryDescriptor geometryDescrptor = featureType.getGeometryDescriptor();
        if (geometryDescrptor == null || !CRS.equalsIgnoreMetadata(DefaultGeographicCRS.WGS84, geometryDescrptor.getCoordinateReferenceSystem()) || !geometryDescrptor.getType().getBinding().isAssignableFrom(Point.class)) {
            throw new IOException("Unable use '" + this.latField + "' / '" + this.lngField + "' to represent " + geometryDescrptor);
        }
        header.add(this.latField);
        header.add(this.lngField);
        for (AttributeDescriptor descriptor : featureType.getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) continue;
            header.add(descriptor.getLocalName());
        }
        try (CsvWriter writer = new CsvWriter((Writer)new FileWriter(this.csvFileState.getFile()), ',');){
            writer.writeRecord(header.toArray(new String[header.size()]));
        }
    }

    @Override
    public String[] encode(SimpleFeature feature) {
        ArrayList<String> csvRecord = new ArrayList<String>();
        for (Property property : feature.getProperties()) {
            Object value = property.getValue();
            if (value == null) {
                csvRecord.add("");
                continue;
            }
            if (value instanceof Point) {
                Point point = (Point)value;
                csvRecord.add(Double.toString(point.getY()));
                csvRecord.add(Double.toString(point.getX()));
                continue;
            }
            String txt = value.toString();
            csvRecord.add(txt);
        }
        return csvRecord.toArray(new String[csvRecord.size() - 1]);
    }

    @Override
    public SimpleFeature decode(String recordId, String[] csvRecord) {
        SimpleFeatureType featureType = this.getFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        GeometryDescriptor geometryDescriptor = featureType.getGeometryDescriptor();
        GeometryFactory geometryFactory = new GeometryFactory();
        Double lat = null;
        Double lng = null;
        String[] headers = this.csvFileState.getCSVHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            if (i < csvRecord.length) {
                String value = csvRecord[i].trim();
                if (geometryDescriptor != null && header.equals(this.latField)) {
                    lat = Double.valueOf(value);
                    continue;
                }
                if (geometryDescriptor != null && header.equals(this.lngField)) {
                    lng = Double.valueOf(value);
                    continue;
                }
                builder.set(header, (Object)value);
                continue;
            }
            builder.set(header, null);
        }
        if (geometryDescriptor != null && lat != null && lng != null) {
            Coordinate coordinate = new Coordinate(lng, lat);
            Point point = geometryFactory.createPoint(coordinate);
            builder.set(geometryDescriptor.getLocalName(), (Object)point);
        }
        return builder.buildFeature(this.csvFileState.getTypeName() + "-" + recordId);
    }
}

