/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv.parse;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geotools.data.csv.CSVFileState;
import org.geotools.data.csv.parse.CSVStrategy;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CSVLatLonStrategy
extends CSVStrategy {
    private static final String GEOMETRY_COLUMN = "location";

    public CSVLatLonStrategy(CSVFileState csvFileState) {
        super(csvFileState);
    }

    @Override
    protected SimpleFeatureType buildFeatureType() {
        Map<String, Class<?>> typesFromData;
        String[] headers;
        try (CsvReader csvReader = null;){
            csvReader = this.csvFileState.openCSVReader();
            headers = csvReader.getHeaders();
            typesFromData = CSVStrategy.findMostSpecificTypesFromData(csvReader, headers);
        }
        SimpleFeatureTypeBuilder builder = CSVStrategy.createBuilder(this.csvFileState, headers, typesFromData);
        boolean validLat = false;
        boolean validLon = false;
        String latSpelling = null;
        String lonSpelling = null;
        for (String col : headers) {
            Class<?> type = typesFromData.get(col);
            if (this.isLatitude(col)) {
                latSpelling = col;
                if (!CSVStrategy.isNumeric(type)) continue;
                validLat = true;
                continue;
            }
            if (!this.isLongitude(col)) continue;
            lonSpelling = col;
            if (!CSVStrategy.isNumeric(type)) continue;
            validLon = true;
        }
        if (validLat && validLon) {
            List<String> csvHeaders = Arrays.asList(headers);
            int index = csvHeaders.indexOf(latSpelling);
            AttributeTypeBuilder builder2 = new AttributeTypeBuilder();
            builder2.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            builder2.binding(Point.class);
            AttributeDescriptor descriptor = builder2.buildDescriptor(GEOMETRY_COLUMN);
            builder.add(index, descriptor);
            builder.remove(latSpelling);
            builder.remove(lonSpelling);
        }
        return builder.buildFeatureType();
    }

    private boolean isLatitude(String s) {
        return "latitude".equalsIgnoreCase(s) || "lat".equalsIgnoreCase(s);
    }

    private boolean isLongitude(String s) {
        return "lon".equalsIgnoreCase(s) || "lng".equalsIgnoreCase(s) || "long".equalsIgnoreCase(s) || "longitude".equalsIgnoreCase(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        ArrayList<String> header = new ArrayList<String>();
        GeometryDescriptor geometryDescrptor = featureType.getGeometryDescriptor();
        if (geometryDescrptor == null || !CRS.equalsIgnoreMetadata(DefaultGeographicCRS.WGS84, geometryDescrptor.getCoordinateReferenceSystem()) || !geometryDescrptor.getType().getBinding().isAssignableFrom(Point.class)) {
            throw new IOException("Unable use LAT/LON to represent " + geometryDescrptor);
        }
        header.add("LAT");
        header.add("LON");
        for (AttributeDescriptor descriptor : featureType.getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) continue;
            header.add(descriptor.getLocalName());
        }
        try (CsvWriter writer = new CsvWriter((Writer)new FileWriter(this.csvFileState.getFile()), ',');){
            writer.writeRecord(header.toArray(new String[header.size()]));
        }
    }

    @Override
    public String[] encode(SimpleFeature feature) {
        ArrayList<String> csvRecord = new ArrayList<String>();
        for (Property property : feature.getProperties()) {
            Object value = property.getValue();
            if (value == null) {
                csvRecord.add("");
                continue;
            }
            if (value instanceof Point) {
                Point point = (Point)value;
                csvRecord.add(Double.toString(point.getY()));
                csvRecord.add(Double.toString(point.getX()));
                continue;
            }
            String txt = value.toString();
            csvRecord.add(txt);
        }
        return csvRecord.toArray(new String[csvRecord.size() - 1]);
    }

    @Override
    public SimpleFeature decode(String recordId, String[] csvRecord) {
        SimpleFeatureType featureType = this.getFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        GeometryDescriptor geometryDescriptor = featureType.getGeometryDescriptor();
        GeometryFactory geometryFactory = new GeometryFactory();
        Double x = null;
        Double y = null;
        String[] headers = this.csvFileState.getCSVHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            if (i < csvRecord.length) {
                String value = csvRecord[i].trim();
                if (geometryDescriptor != null && this.isLatitude(header)) {
                    y = Double.valueOf(value);
                    continue;
                }
                if (geometryDescriptor != null && this.isLongitude(header)) {
                    x = Double.valueOf(value);
                    continue;
                }
                builder.set(header, (Object)value);
                continue;
            }
            builder.set(header, null);
        }
        if (x != null && y != null && geometryDescriptor != null) {
            Coordinate coordinate = new Coordinate(x, y);
            Point point = geometryFactory.createPoint(coordinate);
            builder.set(geometryDescriptor.getLocalName(), (Object)point);
        }
        return builder.buildFeature(this.csvFileState.getTypeName() + "-" + recordId);
    }
}

