/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv;

import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.NoSuchElementException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.csv.CSVFileState;
import org.geotools.data.csv.parse.CSVIterator;
import org.geotools.data.csv.parse.CSVStrategy;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class CSVFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    private SimpleFeatureType featureType;
    private CSVStrategy csvStrategy;
    private CSVFileState csvFileState;
    private File temp;
    private CSVIterator iterator;
    private CsvWriter csvWriter;
    private boolean appending = false;
    int nextRow = 0;
    private SimpleFeature currentFeature;

    public CSVFeatureWriter(CSVFileState csvFileState, CSVStrategy csvStrategy) throws IOException {
        this(csvFileState, csvStrategy, Query.ALL);
    }

    public CSVFeatureWriter(CSVFileState csvFileState, CSVStrategy csvStrategy, Query query) throws IOException {
        this.csvFileState = csvFileState;
        File file = csvFileState.getFile();
        File directory = file.getParentFile();
        String typeName = query.getTypeName();
        this.temp = File.createTempFile(typeName + System.currentTimeMillis(), "csv", directory);
        this.featureType = csvStrategy.getFeatureType();
        this.iterator = csvStrategy.iterator();
        this.csvStrategy = csvStrategy;
        this.csvWriter = new CsvWriter((Writer)new FileWriter(this.temp), ',');
        this.csvWriter.writeRecord(this.csvFileState.getCSVHeaders());
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.csvWriter == null) {
            return false;
        }
        if (this.appending) {
            return false;
        }
        return this.iterator.hasNext();
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (this.csvWriter == null) {
            throw new IOException("Writer has been closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        try {
            if (!this.appending) {
                if (this.iterator.hasNext()) {
                    this.currentFeature = this.iterator.next();
                    return this.currentFeature;
                }
                this.appending = true;
            }
            String fid = this.featureType.getTypeName() + "." + this.nextRow;
            Object[] values = DataUtilities.defaultValues((SimpleFeatureType)this.featureType);
            this.currentFeature = SimpleFeatureBuilder.build((SimpleFeatureType)this.featureType, (Object[])values, (String)fid);
            return this.currentFeature;
        }
        catch (IllegalArgumentException invalid) {
            throw new IOException("Unable to create feature:" + invalid.getMessage(), invalid);
        }
    }

    @Override
    public void remove() throws IOException {
        this.currentFeature = null;
    }

    @Override
    public void write() throws IOException {
        if (this.currentFeature == null) {
            return;
        }
        this.csvWriter.writeRecord(this.csvStrategy.encode(this.currentFeature));
        ++this.nextRow;
        this.currentFeature = null;
    }

    @Override
    public void close() throws IOException {
        if (this.csvWriter == null) {
            throw new IOException("Writer alread closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        while (this.hasNext()) {
            this.next();
            this.write();
        }
        this.csvWriter.close();
        this.csvWriter = null;
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
        File file = this.csvFileState.getFile();
        Files.copy(this.temp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
}

