/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.teradata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.jdbc.AutoGeneratedPrimaryKeyColumn;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyFinder;
import org.geotools.util.logging.Logging;

class TeradataPrimaryKeyFinder
extends PrimaryKeyFinder {
    private static final Logger LOGGER = Logging.getLogger(TeradataPrimaryKeyFinder.class);

    TeradataPrimaryKeyFinder() {
    }

    @Override
    public PrimaryKey getPrimaryKey(JDBCDataStore store, String schema, String table, Connection cx) throws SQLException {
        List<PrimaryKeyColumn> columns = this.tryForPrimaryKey1(schema, table, cx);
        if (columns.isEmpty()) {
            columns = this.tryForPrimaryKey(schema, table, cx);
        }
        if (columns.isEmpty()) {
            columns = this.tryForSequence(schema, table, cx);
        }
        if (columns.isEmpty()) {
            columns = this.tryAsView(schema, table, cx);
        }
        if (columns.isEmpty()) {
            return null;
        }
        return new PrimaryKey(table, columns);
    }

    private List<PrimaryKeyColumn> tryAsView(String schema, String table, Connection cx) throws SQLException {
        ArrayList<PrimaryKeyColumn> columns = new ArrayList<PrimaryKeyColumn>();
        StringBuilder sql = new StringBuilder("SELECT RequestText FROM DBC.tables WHERE ");
        if (schema != null) {
            sql.append("DatabaseName = '").append(schema).append("' AND ");
        }
        sql.append("TableName = '").append(table).append("' AND TableKind='V'");
        Statement st = cx.createStatement();
        ResultSet result = st.executeQuery(sql.toString());
        if (result.next()) {
            String createViewSql = result.getString("RequestText");
            int as = createViewSql.toLowerCase().indexOf("as");
            String[] parts = new String[]{createViewSql.substring(0, as), createViewSql.substring(as + 2)};
            String select = parts[1].substring(parts[1].toLowerCase().indexOf("sel"));
            try {
                ResultSet viewResults = st.executeQuery(select);
                ResultSetMetaData md = viewResults.getMetaData();
                for (int i = 1; i <= md.getColumnCount(); ++i) {
                    Class columnType;
                    if (!md.isAutoIncrement(i)) continue;
                    String columnLabel = md.getColumnLabel(i);
                    try {
                        columnType = Thread.currentThread().getContextClassLoader().loadClass(md.getColumnClassName(i));
                    }
                    catch (ClassNotFoundException e) {
                        columnType = Object.class;
                    }
                    columns.add(new AutoGeneratedPrimaryKeyColumn(columnLabel, columnType));
                }
            }
            catch (SQLException e) {
                String from = "'" + table + "'";
                if (schema != null) {
                    from = "'" + schema + "'." + from;
                }
                LOGGER.warning("Unable to perform select used to create view " + from + ".\nSQL: " + select);
            }
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PrimaryKeyColumn> tryForSequence(String schema, String table, Connection cx) throws SQLException {
        ArrayList<PrimaryKeyColumn> columns = new ArrayList<PrimaryKeyColumn>();
        StringBuilder sql = new StringBuilder("SELECT DISTINCT ColumnName FROM DBC.columns WHERE ");
        if (schema != null) {
            sql.append("DatabaseName = '").append(schema).append("' AND ");
        }
        sql.append("TableName = '").append(table).append("' AND (IdColType='GA' or IdColType='GD')");
        Statement st = cx.createStatement();
        ResultSet result = st.executeQuery(sql.toString());
        boolean next = result.next();
        try {
            TableMetadata tableMetadata = new TableMetadata(st, schema, table);
            while (next) {
                String columnName = result.getString("ColumnName").trim();
                int ordinal = tableMetadata.ordinal(columnName);
                Class<?> columnClass = tableMetadata.columnClass(ordinal);
                if (tableMetadata.isAutoIncrement(ordinal)) {
                    columns.add(new AutoGeneratedPrimaryKeyColumn(columnName, columnClass));
                }
                next = result.next();
            }
        }
        catch (SQLException e) {
        }
        finally {
            st.close();
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PrimaryKeyColumn> tryForPrimaryKey(String schema, String table, Connection cx) throws SQLException {
        ArrayList<PrimaryKeyColumn> columns = new ArrayList<PrimaryKeyColumn>();
        StringBuilder sql = new StringBuilder("select ColumnName,ColumnPosition from dbc.indices WHERE ");
        if (schema != null) {
            sql.append("DatabaseName = '").append(schema).append("' AND ");
        }
        sql.append("TableName = '").append(table).append("' AND UniqueFlag = 'Y'");
        Statement st = cx.createStatement();
        ResultSet result = st.executeQuery(sql.toString());
        boolean next = result.next();
        try {
            TableMetadata tableMetadata = new TableMetadata(st, schema, table);
            while (next) {
                int ordinal = Integer.parseInt(result.getString("ColumnPosition").trim());
                String columnName = result.getString("ColumnName").trim();
                Class<?> columnClass = tableMetadata.columnClass(ordinal);
                if (tableMetadata.isAutoIncrement(ordinal)) {
                    columns.add(new AutoGeneratedPrimaryKeyColumn(columnName, columnClass));
                } else {
                    columns.add(new NonIncrementingPrimaryKeyColumn(columnName, columnClass));
                }
                next = result.next();
            }
        }
        catch (SQLException e) {
        }
        finally {
            st.close();
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PrimaryKeyColumn> tryForPrimaryKey1(String schema, String table, Connection cx) throws SQLException {
        ArrayList<PrimaryKeyColumn> columns = new ArrayList<PrimaryKeyColumn>();
        ResultSet md = cx.getMetaData().getPrimaryKeys(null, schema, table);
        boolean next = md.next();
        if (next) {
            try (Statement stmt = cx.createStatement();){
                TableMetadata tableMetadata = new TableMetadata(stmt, schema, table);
                while (next) {
                    String columnName = md.getString("COLUMN_NAME").trim();
                    int ordinal = tableMetadata.ordinal(columnName);
                    if (ordinal >= 0) {
                        Class<?> columnClass = tableMetadata.columnClass(ordinal);
                        if (tableMetadata.isAutoIncrement(ordinal)) {
                            columns.add(new AutoGeneratedPrimaryKeyColumn(columnName, columnClass));
                        } else {
                            columns.add(new NonIncrementingPrimaryKeyColumn(columnName, columnClass));
                        }
                    }
                    next = md.next();
                }
            }
        }
        return columns;
    }

    static class TableMetadata {
        final Statement stmt;
        final ResultSet resultSet;
        final ResultSetMetaData tableMetadata;

        private TableMetadata(Statement stmt, String schema, String table) throws SQLException {
            this.stmt = stmt;
            String from = "\"" + table + "\"";
            if (schema != null) {
                from = "\"" + schema + "\"." + from;
            }
            this.resultSet = stmt.executeQuery("select * from " + from + " where 1=2");
            this.tableMetadata = this.resultSet.getMetaData();
        }

        public int ordinal(String columnName) throws SQLException {
            return this.resultSet.findColumn(columnName);
        }

        public Class<?> columnClass(int ordinal) throws SQLException {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(this.tableMetadata.getColumnClassName(ordinal));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isAutoIncrement(int ordinal) throws SQLException {
            return this.tableMetadata.isAutoIncrement(ordinal);
        }
    }
}

