/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.teradata;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.jdbc.datasource.DBCPDataSource;
import org.geotools.data.teradata.TeradataDialect;
import org.geotools.data.teradata.TeradataPrimaryKeyFinder;
import org.geotools.jdbc.CompositePrimaryKeyFinder;
import org.geotools.jdbc.HeuristicPrimaryKeyFinder;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.MetadataTablePrimaryKeyFinder;
import org.geotools.jdbc.PrimaryKeyFinder;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.logging.Logging;

public class TeradataDataStoreFactory
extends JDBCDataStoreFactory {
    public static final Logger LOGGER = Logging.getLogger(TeradataDataStoreFactory.class);
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"teradata");
    public static final DataAccessFactory.Param LOBWORKAROUND = new DataAccessFactory.Param("Disable LOB Workaround", Boolean.class, "Disable LOB workaround", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param LOOSEBBOX = new DataAccessFactory.Param("Loose bbox", Boolean.class, "Perform only primary filter on bbox", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", true, (Object)1025);
    public static final DataAccessFactory.Param TMODE = new DataAccessFactory.Param("tmode", String.class, "tmode", false, (Object)"ANSI");
    public static final DataAccessFactory.Param CHARSET = new DataAccessFactory.Param("charset", String.class, "charset", false);
    public static final DataAccessFactory.Param TESSELLATION_TABLE = new DataAccessFactory.Param("tessellationTable", String.class, "Tessellation lookup table", false, (Object)"sysspatial.tessellation");
    public static final DataAccessFactory.Param ESTIMATED_BOUNDS = new DataAccessFactory.Param("estimatedBounds", Boolean.class, "Use estimated bounds from tessellation table", false, (Object)false);
    public static final DataAccessFactory.Param APPLICATION = new DataAccessFactory.Param("application", String.class, "ApplicationName query band", false, (Object)"GeoTools");
    private static final PrimaryKeyFinder KEY_FINDER = new CompositePrimaryKeyFinder(new MetadataTablePrimaryKeyFinder(), new TeradataPrimaryKeyFinder(), new HeuristicPrimaryKeyFinder());

    @Override
    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new TeradataDialect(dataStore);
    }

    @Override
    public String getDatabaseID() {
        return (String)TeradataDataStoreFactory.DBTYPE.sample;
    }

    @Override
    public String getDisplayName() {
        return "Teradata";
    }

    @Override
    public String getDescription() {
        return "Teradata Database";
    }

    @Override
    protected String getDriverClassName() {
        return "com.teradata.jdbc.TeraDriver";
    }

    @Override
    protected boolean checkDBType(Map params) {
        return this.checkDBType(params, "teradata");
    }

    @Override
    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        Boolean estimatedBounds;
        TeradataDialect dialect = (TeradataDialect)dataStore.getSQLDialect();
        Boolean lobWorkaround = (Boolean)LOBWORKAROUND.lookUp(params);
        if (lobWorkaround == null && params.containsKey("LOB Workaround")) {
            lobWorkaround = (Boolean)LOBWORKAROUND.handle((String)params.get("LOB Workaround"));
            params.put(TeradataDataStoreFactory.LOBWORKAROUND.key, lobWorkaround.toString());
        }
        dialect.setLobWorkaroundEnabled(lobWorkaround == null || lobWorkaround == false);
        Boolean loose = (Boolean)LOOSEBBOX.lookUp(params);
        dialect.setLooseBBOXEnabled(loose == null || Boolean.TRUE.equals(loose));
        if (!params.containsKey(TeradataDataStoreFactory.PK_METADATA_TABLE.key)) {
            dataStore.setPrimaryKeyFinder(KEY_FINDER);
        }
        if ((estimatedBounds = (Boolean)ESTIMATED_BOUNDS.lookUp(params)) != null && estimatedBounds.booleanValue()) {
            dialect.setEstimatedBounds(estimatedBounds);
        }
        if (params.containsKey(TeradataDataStoreFactory.APPLICATION.key)) {
            dialect.setApplication((String)APPLICATION.lookUp(params));
        }
        String username = null;
        if (params.containsKey(TeradataDataStoreFactory.USER.key)) {
            username = (String)USER.lookUp(params);
        } else if (params.containsKey(TeradataDataStoreFactory.DATASOURCE.key)) {
            DataSource dataSource = (DataSource)DATASOURCE.lookUp(params);
            if (dataSource instanceof BasicDataSource) {
                username = ((BasicDataSource)dataSource).getUsername();
            } else if (dataSource instanceof DBCPDataSource) {
                try {
                    username = ((BasicDataSource)((DBCPDataSource)dataSource).unwrap(DataSource.class)).getUsername();
                }
                catch (SQLException e) {
                    throw (IOException)new IOException().initCause(e);
                }
            }
        }
        if (params.containsKey(TeradataDataStoreFactory.SCHEMA.key)) {
            dataStore.setDatabaseSchema((String)SCHEMA.lookUp(params));
        } else {
            dataStore.setDatabaseSchema(username);
        }
        return dataStore;
    }

    @Override
    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(TeradataDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(TeradataDataStoreFactory.LOOSEBBOX.key, LOOSEBBOX);
        parameters.put(TeradataDataStoreFactory.LOBWORKAROUND.key, LOBWORKAROUND);
        parameters.put(TeradataDataStoreFactory.PORT.key, PORT);
        parameters.put(TeradataDataStoreFactory.TESSELLATION_TABLE.key, TESSELLATION_TABLE);
        parameters.put(TeradataDataStoreFactory.ESTIMATED_BOUNDS.key, ESTIMATED_BOUNDS);
        parameters.put(TeradataDataStoreFactory.MAX_OPEN_PREPARED_STATEMENTS.key, MAX_OPEN_PREPARED_STATEMENTS);
        parameters.put(TeradataDataStoreFactory.APPLICATION.key, APPLICATION);
    }

    @Override
    protected String getValidationQuery() {
        return "select current_timestamp;";
    }

    @Override
    protected String getJDBCUrl(Map params) throws IOException {
        String host = (String)HOST.lookUp(params);
        String db = (String)DATABASE.lookUp(params);
        int port = (Integer)PORT.lookUp(params);
        String mode = (String)TMODE.lookUp(params);
        if (mode == null) {
            mode = TeradataDataStoreFactory.TMODE.sample.toString();
        }
        String url = "jdbc:teradata://" + host + "/DATABASE=" + db + ",PORT=" + port + ",TMODE=" + mode;
        String charset = (String)CHARSET.lookUp(params);
        if (charset != null) {
            url = url + ",CHARSET=" + charset;
        }
        return url;
    }
}

