/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GroundControlPoints;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffMetadata2CRSAdapter;
import org.geotools.coverage.grid.io.imageio.geotiff.TiePoint;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.MapInfoFileReader;
import org.geotools.data.PrjFileReader;
import org.geotools.data.WorldFileReader;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.io.ImageIOExt;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeoTiffReader
extends AbstractGridCoverage2DReader
implements GridCoverage2DReader {
    private Logger LOGGER = Logging.getLogger((String)GeoTiffReader.class.toString());
    public static final String OVERRIDE_CRS_SWITCH = "org.geotools.gce.geotiff.override.crs";
    static boolean OVERRIDE_INNER_CRS = Boolean.valueOf(System.getProperty("org.geotools.gce.geotiff.override.crs", "True"));
    private static final TIFFImageReaderSpi READER_SPI = new TIFFImageReaderSpi();
    private GeoTiffMetadata2CRSAdapter gtcs;
    private double noData = Double.NaN;
    private File ovrSource;
    private ImageInputStreamSpi ovrInStreamSPI = null;
    private int extOvrImgChoice = -1;
    private GroundControlPoints gcps;

    public GeoTiffReader(Object input) throws DataSourceException {
        this(input, new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
    }

    public GeoTiffReader(Object input, Hints uHints) throws DataSourceException {
        super(input, uHints);
        try {
            if (input instanceof URL) {
                URL sourceURL = (URL)input;
                this.source = DataUtilities.urlToFile(sourceURL);
            }
            this.closeMe = true;
            if (this.source instanceof InputStream || this.source instanceof ImageInputStream) {
                this.closeMe = false;
            }
            if (this.source instanceof ImageInputStream) {
                this.inStream = (ImageInputStream)this.source;
            } else {
                this.inStreamSPI = ImageIOExt.getImageInputStreamSPI((Object)this.source);
                if (this.inStreamSPI == null) {
                    throw new IllegalArgumentException("No input stream for the provided source");
                }
                this.inStream = this.inStreamSPI.createInputStreamInstance(this.source, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            }
            if (this.inStream == null) {
                if (this.source instanceof File) {
                    File f = (File)this.source;
                    if (!f.exists()) {
                        throw new FileNotFoundException("File " + f.getAbsolutePath() + " does not exist.");
                    }
                    if (f.isDirectory()) {
                        throw new IOException("File " + f.getAbsolutePath() + " is a directory.");
                    }
                    if (!f.canRead()) {
                        throw new IOException("File " + f.getAbsolutePath() + " can not be read.");
                    }
                }
                throw new IllegalArgumentException("No input stream for the provided source");
            }
            this.checkForExternalOverviews();
            this.getHRInfo(this.hints);
            this.coverageName = this.source instanceof File ? ((File)this.source).getName() : "geotiff_coverage";
            int dotIndex = this.coverageName.lastIndexOf(46);
            if (dotIndex != -1 && dotIndex != this.coverageName.length()) {
                this.coverageName = this.coverageName.substring(0, dotIndex);
            }
        }
        catch (IOException e) {
            throw new DataSourceException(e);
        }
        finally {
            if (this.closeMe && this.inStream != null) {
                try {
                    this.inStream.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private void checkForExternalOverviews() {
        if (!(this.source instanceof File)) {
            return;
        }
        File src = (File)this.source;
        this.ovrSource = new File(src.getParent(), src.getName() + ".ovr");
        if (!this.ovrSource.exists()) {
            return;
        }
        this.ovrInStreamSPI = ImageIOExt.getImageInputStreamSPI((Object)this.ovrSource);
    }

    private void getHRInfo(Hints hints) throws DataSourceException {
        ImageReader reader = null;
        ImageReader ovrReader = null;
        ImageInputStream ovrStream = null;
        try {
            reader = READER_SPI.createReaderInstance();
            this.inStream.mark();
            reader.setInput(this.inStream);
            IIOMetadata iioMetadata = reader.getImageMetadata(0);
            GeoTiffIIOMetadataDecoder metadata = new GeoTiffIIOMetadataDecoder(iioMetadata);
            this.gtcs = new GeoTiffMetadata2CRSAdapter(hints);
            Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
            if (tempCRS != null) {
                this.crs = (CoordinateReferenceSystem)tempCRS;
                if (this.LOGGER.isLoggable(Level.FINE)) {
                    this.LOGGER.log(Level.FINE, "Using forced coordinate reference system");
                }
            } else {
                this.crs = this.getCRS(this.source);
                if ((!OVERRIDE_INNER_CRS || this.crs == null) && metadata.hasGeoKey() && this.gtcs != null) {
                    this.crs = this.gtcs.createCoordinateSystem(metadata);
                }
            }
            if (metadata.hasNoData()) {
                this.noData = metadata.getNoData();
            }
            this.setLayout(reader);
            this.numOverviews = reader.getNumImages(true) - 1;
            int hrWidth = reader.getWidth(0);
            int hrHeight = reader.getHeight(0);
            Rectangle actualDim = new Rectangle(0, 0, hrWidth, hrHeight);
            this.originalGridRange = new GridEnvelope2D(actualDim);
            if (this.gtcs != null && metadata != null && (metadata.hasModelTrasformation() || metadata.hasPixelScales() && metadata.hasTiePoints())) {
                this.raster2Model = GeoTiffMetadata2CRSAdapter.getRasterToModel((GeoTiffIIOMetadataDecoder)metadata);
            } else {
                MapInfoFileReader mifReader;
                this.raster2Model = GeoTiffReader.parseWorldFile(this.source);
                if (this.raster2Model == null && (mifReader = GeoTiffReader.parseMapInfoFile(this.source)) != null) {
                    this.raster2Model = mifReader.getTransform();
                    this.crs = mifReader.getCRS();
                }
            }
            if (this.crs == null) {
                if (this.LOGGER.isLoggable(Level.WARNING)) {
                    this.LOGGER.warning("Coordinate Reference System is not available");
                }
                this.crs = AbstractGridFormat.getDefaultCRS();
            }
            if (this.raster2Model == null) {
                TiePoint[] modelTiePoints = metadata.getModelTiePoints();
                if (modelTiePoints != null && modelTiePoints.length > 1) {
                    this.gcps = new GroundControlPoints(Arrays.asList(modelTiePoints), this.crs);
                    this.raster2Model = ProjectiveTransform.create((AffineTransform)new AffineTransform());
                    this.crs = AbstractGridFormat.getDefaultCRS();
                } else {
                    throw new DataSourceException("Raster to Model Transformation is not available");
                }
            }
            AffineTransform tempTransform = new AffineTransform((AffineTransform)this.raster2Model);
            tempTransform.concatenate(CoverageUtilities.CENTER_TO_CORNER);
            this.originalEnvelope = CRS.transform((MathTransform)ProjectiveTransform.create((AffineTransform)tempTransform), (Envelope)new GeneralEnvelope((Rectangle2D)actualDim));
            this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
            this.highestRes = new double[2];
            this.highestRes[0] = XAffineTransform.getScaleX0((AffineTransform)tempTransform);
            this.highestRes[1] = XAffineTransform.getScaleY0((AffineTransform)tempTransform);
            if (this.ovrInStreamSPI != null) {
                ovrReader = READER_SPI.createReaderInstance();
                ovrStream = this.ovrInStreamSPI.createInputStreamInstance(this.ovrSource, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
                ovrReader.setInput(ovrStream);
                this.extOvrImgChoice = this.numOverviews + 1;
                this.numOverviews += ovrReader.getNumImages(true);
                if (this.numOverviews < this.extOvrImgChoice) {
                    this.extOvrImgChoice = -1;
                }
            }
            if (this.numOverviews >= 1) {
                int i;
                this.overViewResolutions = new double[this.numOverviews][2];
                int firstExternalOverview = this.extOvrImgChoice == -1 ? this.numOverviews : this.extOvrImgChoice - 1;
                double spanRes0 = this.highestRes[0] * (double)this.originalGridRange.getSpan(0);
                double spanRes1 = this.highestRes[1] * (double)this.originalGridRange.getSpan(1);
                for (i = 0; i < firstExternalOverview; ++i) {
                    this.overViewResolutions[i][0] = spanRes0 / (double)reader.getWidth(i + 1);
                    this.overViewResolutions[i][1] = spanRes1 / (double)reader.getHeight(i + 1);
                }
                for (i = firstExternalOverview; i < this.numOverviews; ++i) {
                    this.overViewResolutions[i][0] = spanRes0 / (double)ovrReader.getWidth(i - firstExternalOverview);
                    this.overViewResolutions[i][1] = spanRes1 / (double)ovrReader.getHeight(i - firstExternalOverview);
                }
            } else {
                this.overViewResolutions = null;
            }
        }
        catch (Throwable e) {
            throw new DataSourceException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Throwable t) {}
            }
            if (ovrReader != null) {
                try {
                    ovrReader.dispose();
                }
                catch (Throwable t) {}
            }
            if (ovrStream != null) {
                try {
                    ovrStream.close();
                }
                catch (Throwable t) {}
            }
            if (this.inStream != null) {
                try {
                    this.inStream.reset();
                }
                catch (Throwable t) {}
            }
        }
    }

    public Format getFormat() {
        return new GeoTiffFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        Color inputTransparentColor = null;
        OverviewPolicy overviewPolicy = null;
        int[] suggestedTileSize = null;
        if (params != null && params != null) {
            for (int i = 0; i < params.length; ++i) {
                String suggestedTileSize_;
                ParameterValue param = (ParameterValue)params[i];
                ReferenceIdentifier name = param.getDescriptor().getName();
                if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    requestedEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                    dim = gg.getGridRange2D().getBounds();
                    continue;
                }
                if (name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName())) {
                    overviewPolicy = (OverviewPolicy)param.getValue();
                    continue;
                }
                if (name.equals(AbstractGridFormat.INPUT_TRANSPARENT_COLOR.getName())) {
                    inputTransparentColor = (Color)param.getValue();
                    continue;
                }
                if (!name.equals(AbstractGridFormat.SUGGESTED_TILE_SIZE.getName()) || (suggestedTileSize_ = (String)param.getValue()) == null || suggestedTileSize_.length() <= 0) continue;
                int commaPosition = (suggestedTileSize_ = suggestedTileSize_.trim()).indexOf(",");
                if (commaPosition < 0) {
                    int tileDim = Integer.parseInt(suggestedTileSize_);
                    suggestedTileSize = new int[]{tileDim, tileDim};
                    continue;
                }
                int tileW = Integer.parseInt(suggestedTileSize_.substring(0, commaPosition));
                int tileH = Integer.parseInt(suggestedTileSize_.substring(commaPosition + 1));
                suggestedTileSize = new int[]{tileW, tileH};
            }
        }
        Integer imageChoice = new Integer(0);
        ImageReadParam readP = new ImageReadParam();
        try {
            imageChoice = this.setReadParams(overviewPolicy, readP, requestedEnvelope, dim);
        }
        catch (TransformException e) {
            new DataSourceException(e);
        }
        Hints newHints = null;
        if (suggestedTileSize != null) {
            newHints = this.hints.clone();
            ImageLayout layout = new ImageLayout();
            layout.setTileGridXOffset(0);
            layout.setTileGridYOffset(0);
            layout.setTileHeight((int)suggestedTileSize[1]);
            layout.setTileWidth((int)suggestedTileSize[0]);
            newHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        }
        ParameterBlock pbjRead = new ParameterBlock();
        if (this.extOvrImgChoice >= 0 && imageChoice >= this.extOvrImgChoice) {
            pbjRead.add(this.ovrInStreamSPI.createInputStreamInstance(this.ovrSource, ImageIO.getUseCache(), ImageIO.getCacheDirectory()));
            pbjRead.add(imageChoice - this.extOvrImgChoice);
        } else {
            pbjRead.add(this.inStreamSPI != null ? this.inStreamSPI.createInputStreamInstance(this.source, ImageIO.getUseCache(), ImageIO.getCacheDirectory()) : ImageIO.createImageInputStream(this.source));
            pbjRead.add(imageChoice);
        }
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(null);
        pbjRead.add(null);
        pbjRead.add(readP);
        pbjRead.add(READER_SPI.createReaderInstance());
        RenderedOp coverageRaster = JAI.create((String)"ImageRead", (ParameterBlock)pbjRead, (RenderingHints)(newHints != null ? newHints : null));
        if (inputTransparentColor != null) {
            coverageRaster = new ImageWorker((RenderedImage)coverageRaster).setRenderingHints((RenderingHints)newHints).makeColorTransparent(inputTransparentColor).getRenderedOperation();
        }
        AffineTransform rasterToModel = this.getRescaledRasterToModel((RenderedImage)coverageRaster);
        try {
            return this.createCoverage((PlanarImage)coverageRaster, (MathTransform)ProjectiveTransform.create((AffineTransform)rasterToModel));
        }
        catch (Exception e) {
            ImageUtilities.disposePlanarImageChain((PlanarImage)coverageRaster);
            if (e instanceof DataSourceException) {
                throw (DataSourceException)e;
            }
            throw new DataSourceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoTiffIIOMetadataDecoder getMetadata() {
        GeoTiffIIOMetadataDecoder metadata = null;
        ImageReader reader = null;
        boolean closeMe = true;
        ImageInputStream stream = null;
        try {
            if (this.source instanceof InputStream || this.source instanceof ImageInputStream) {
                closeMe = false;
            }
            if (this.source instanceof ImageInputStream) {
                stream = (ImageInputStream)this.source;
            } else {
                this.inStreamSPI = ImageIOExt.getImageInputStreamSPI((Object)this.source);
                if (this.inStreamSPI == null) {
                    throw new IllegalArgumentException("No input stream for the provided source");
                }
                stream = this.inStreamSPI.createInputStreamInstance(this.source, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            }
            if (stream == null) {
                throw new IllegalArgumentException("No input stream for the provided source");
            }
            stream.mark();
            reader = READER_SPI.createReaderInstance();
            reader.setInput(stream);
            IIOMetadata iioMetadata = reader.getImageMetadata(0);
            metadata = new GeoTiffIIOMetadataDecoder(iioMetadata);
        }
        catch (IOException e) {
            if (this.LOGGER.isLoggable(Level.SEVERE)) {
                this.LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Throwable t) {}
            }
            if (stream != null) {
                try {
                    stream.reset();
                }
                catch (Throwable t) {}
                if (closeMe) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        return metadata;
    }

    protected final GridCoverage2D createCoverage(PlanarImage image, MathTransform raster2Model) throws IOException {
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        Category noDataCategory = null;
        HashMap<String, Double> properties = new HashMap<String, Double>();
        if (!Double.isNaN(this.noData)) {
            noDataCategory = new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create((double)this.noData, (double)this.noData), NumberRange.create((double)this.noData, (double)this.noData));
            properties.put("GC_NODATA", new Double(this.noData));
        }
        HashSet bandNames = new HashSet();
        for (int i = 0; i < numBands; ++i) {
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)i);
            if (colorInterpretation == null) {
                throw new IOException("Unrecognized sample dimension type");
            }
            Category[] categories = null;
            if (noDataCategory != null) {
                categories = new Category[]{noDataCategory};
            }
            String bandName = colorInterpretation.name();
            if (colorInterpretation == ColorInterpretation.UNDEFINED || bandNames.contains(bandName)) {
                bandName = "Band" + (i + 1);
            }
            bands[i] = new GridSampleDimension((CharSequence)bandName, categories, null).geophysics(true);
        }
        if (raster2Model != null) {
            return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, this.crs, raster2Model, bands, null, properties);
        }
        return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, (Envelope)new GeneralEnvelope((Envelope)this.originalEnvelope), bands, null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinateReferenceSystem getCRS(Object source) {
        CoordinateReferenceSystem crs = null;
        if (source instanceof File || source instanceof URL && ((URL)source).getProtocol() == "file") {
            String sourceAsString;
            if (source instanceof File) {
                sourceAsString = ((File)source).getAbsolutePath();
            } else {
                String auth = ((URL)source).getAuthority();
                String path = ((URL)source).getPath();
                sourceAsString = auth != null && !auth.equals("") ? "//" + auth + path : path;
            }
            int index = sourceAsString.lastIndexOf(".");
            String base = index > 0 ? sourceAsString.substring(0, index) + ".prj" : sourceAsString + ".prj";
            File prjFile = new File(base.toString());
            if (prjFile.exists()) {
                PrjFileReader projReader = null;
                FileInputStream instream = null;
                try {
                    instream = new FileInputStream(prjFile);
                    FileChannel channel = instream.getChannel();
                    projReader = new PrjFileReader(channel);
                    crs = projReader.getCoordinateReferenceSystem();
                }
                catch (FileNotFoundException e) {
                    this.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                }
                catch (FactoryException e) {
                    this.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                }
                finally {
                    if (projReader != null) {
                        try {
                            projReader.close();
                        }
                        catch (IOException e) {
                            this.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                    if (instream != null) {
                        try {
                            instream.close();
                        }
                        catch (IOException e) {
                            this.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                }
            }
        }
        return crs;
    }

    static MathTransform parseWorldFile(Object source) throws IOException {
        MathTransform raster2Model = null;
        if (source instanceof File) {
            File sourceFile = (File)source;
            String parentPath = sourceFile.getParent();
            String filename = sourceFile.getName();
            int i = filename.lastIndexOf(46);
            filename = i == -1 ? filename : filename.substring(0, i);
            String base = parentPath != null ? parentPath + File.separator + filename : filename;
            File file2Parse = new File(base + ".wld");
            if (file2Parse.exists()) {
                WorldFileReader reader = new WorldFileReader(file2Parse);
                raster2Model = reader.getTransform();
            } else {
                file2Parse = new File(base + ".tfw");
                if (file2Parse.exists()) {
                    WorldFileReader reader = new WorldFileReader(file2Parse);
                    raster2Model = reader.getTransform();
                }
            }
        }
        return raster2Model;
    }

    static MapInfoFileReader parseMapInfoFile(Object source) throws IOException {
        if (source instanceof File) {
            File sourceFile = (File)source;
            String parentPath = sourceFile.getParent();
            String filename = sourceFile.getName();
            int i = filename.lastIndexOf(46);
            filename = i == -1 ? filename : filename.substring(0, i);
            String base = parentPath != null ? parentPath + File.separator + filename : filename;
            File file2Parse = new File(base + ".tab");
            if (file2Parse.exists()) {
                MapInfoFileReader reader = new MapInfoFileReader(file2Parse);
                return reader;
            }
        }
        return null;
    }

    public int getGridCoverageCount() {
        return 1;
    }

    public GroundControlPoints getGroundControlPoints() {
        return this.gcps;
    }
}

