/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.NameImpl;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;

public class PreGeneralizedSimpleFeature
implements SimpleFeature {
    SimpleFeature feature;
    SimpleFeatureType featureTyp;
    String geomPropertyName;
    String backendGeomPropertyName;
    Name nameBackendGeomProperty;
    Map<Object, Object> userData;
    int[] indexMapping;

    public PreGeneralizedSimpleFeature(SimpleFeatureType featureTyp, int[] indexMapping, SimpleFeature feature, String geomPropertyName, String backendGeomPropertyName) {
        this.feature = feature;
        this.geomPropertyName = geomPropertyName;
        this.backendGeomPropertyName = backendGeomPropertyName;
        this.featureTyp = featureTyp;
        this.indexMapping = indexMapping;
        this.nameBackendGeomProperty = new NameImpl(backendGeomPropertyName);
    }

    private String getBackendAttributeName(String attrName) {
        if (this.geomPropertyName.equals(attrName)) {
            return this.backendGeomPropertyName;
        }
        return attrName;
    }

    private Name getNameBackendAttribute(Name name) {
        if (this.geomPropertyName.equals(name.getLocalPart())) {
            return this.nameBackendGeomProperty;
        }
        return name;
    }

    private Property createProperty(String name) {
        Object value = name.equals(this.geomPropertyName) ? this.feature.getAttribute(this.backendGeomPropertyName) : this.feature.getAttribute(name);
        AttributeDescriptor attrDescr = this.featureTyp.getDescriptor(name);
        if (attrDescr == null) {
            return null;
        }
        if (attrDescr instanceof GeometryDescriptor) {
            return new GeometryAttributeImpl(value, (GeometryDescriptor)attrDescr, null);
        }
        return new AttributeImpl(value, attrDescr, null);
    }

    private UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Cannot modify a pregeneralized feature");
    }

    public Object getAttribute(String attrName) {
        return this.feature.getAttribute(this.getBackendAttributeName(attrName));
    }

    public Object getAttribute(Name name) {
        return this.feature.getAttribute(this.getNameBackendAttribute(name));
    }

    public Object getAttribute(int index) throws IndexOutOfBoundsException {
        return this.feature.getAttribute(this.indexMapping[index]);
    }

    public int getAttributeCount() {
        return this.feature.getAttributeCount();
    }

    public List<Object> getAttributes() {
        return this.feature.getAttributes();
    }

    public Object getDefaultGeometry() {
        return this.feature.getAttribute(this.backendGeomPropertyName);
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureTyp;
    }

    public String getID() {
        return this.feature.getID();
    }

    public SimpleFeatureType getType() {
        return this.featureTyp;
    }

    public void setAttribute(String arg0, Object arg1) {
        throw this.unsupported();
    }

    public void setAttribute(Name arg0, Object arg1) {
        throw this.unsupported();
    }

    public void setAttribute(int arg0, Object arg1) throws IndexOutOfBoundsException {
        throw this.unsupported();
    }

    public void setAttributes(List<Object> arg0) {
        throw this.unsupported();
    }

    public void setAttributes(Object[] arg0) {
        throw this.unsupported();
    }

    public void setDefaultGeometry(Object arg0) {
        throw this.unsupported();
    }

    public BoundingBox getBounds() {
        return this.feature.getBounds();
    }

    public GeometryAttribute getDefaultGeometryProperty() {
        Object value = this.feature.getAttribute(this.backendGeomPropertyName);
        GeometryAttributeImpl attr = new GeometryAttributeImpl(value, this.featureTyp.getGeometryDescriptor(), null);
        return attr;
    }

    public FeatureId getIdentifier() {
        return this.feature.getIdentifier();
    }

    public void setDefaultGeometryProperty(GeometryAttribute arg0) {
        throw this.unsupported();
    }

    public Collection<Property> getProperties() {
        ArrayList<Property> result = new ArrayList<Property>();
        for (PropertyDescriptor descr : this.featureTyp.getDescriptors()) {
            result.add(this.createProperty(descr.getName().getLocalPart()));
        }
        return result;
    }

    public Collection<Property> getProperties(Name name) {
        return this.getProperties(name.getLocalPart());
    }

    public Collection<Property> getProperties(String name) {
        Property p = this.createProperty(name);
        if (p == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(p);
    }

    public Property getProperty(Name name) {
        return this.createProperty(name.getLocalPart());
    }

    public Property getProperty(String name) {
        return this.createProperty(name);
    }

    public Collection<? extends Property> getValue() {
        return this.getProperties();
    }

    public void setValue(Collection<Property> arg0) {
        throw this.unsupported();
    }

    public void validate() throws IllegalAttributeException {
        this.feature.validate();
    }

    public AttributeDescriptor getDescriptor() {
        return null;
    }

    public Name getName() {
        return null;
    }

    public Map<Object, Object> getUserData() {
        if (this.userData == null) {
            this.userData = new HashMap<Object, Object>();
        }
        return this.userData;
    }

    public boolean isNillable() {
        return false;
    }

    public void setValue(Object arg0) {
        throw this.unsupported();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PreGeneralizedSimpleFeature)) {
            return false;
        }
        PreGeneralizedSimpleFeature feat = (PreGeneralizedSimpleFeature)obj;
        if (!feat.geomPropertyName.equals(this.geomPropertyName)) {
            return false;
        }
        if (!feat.backendGeomPropertyName.equals(this.backendGeomPropertyName)) {
            return false;
        }
        if (!feat.featureTyp.equals(this.featureTyp)) {
            return false;
        }
        return feat.feature.equals(this.feature);
    }

    public int hashCode() {
        return this.featureTyp.hashCode() * this.geomPropertyName.hashCode() * this.backendGeomPropertyName.hashCode() * this.feature.hashCode();
    }
}

