/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.geotools.data.DataUtilities;
import org.geotools.data.gen.PreGeneralizedFeatureIterator;
import org.geotools.data.gen.PreGeneralizedSimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public class PreGeneralizedFeatureCollection
implements SimpleFeatureCollection {
    protected SimpleFeatureCollection backendCollection;
    protected SimpleFeatureType featureType;
    protected String geomPropertyName;
    protected String backendGeomPropertyName;
    protected int[] indexMapping;

    public PreGeneralizedFeatureCollection(SimpleFeatureCollection backendCollection, SimpleFeatureType featureType, int[] indexMapping, String geomPropertyName, String backendGeomPropertyName) {
        this.backendCollection = backendCollection;
        this.featureType = featureType;
        this.geomPropertyName = geomPropertyName;
        this.backendGeomPropertyName = backendGeomPropertyName;
        this.indexMapping = indexMapping;
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit(this, visitor, progress);
    }

    @Override
    public boolean contains(Object feature) {
        if (feature instanceof PreGeneralizedSimpleFeature) {
            return this.backendCollection.contains(((PreGeneralizedSimpleFeature)feature).feature);
        }
        return this.backendCollection.contains(feature);
    }

    @Override
    public boolean containsAll(Collection coll) {
        ArrayList<Object> searchColl = new ArrayList<Object>();
        for (Object feature : coll) {
            if (feature instanceof PreGeneralizedSimpleFeature) {
                searchColl.add(((PreGeneralizedSimpleFeature)feature).feature);
                continue;
            }
            searchColl.add(feature);
        }
        return this.backendCollection.containsAll(searchColl);
    }

    @Override
    public SimpleFeatureIterator features() {
        return new PreGeneralizedFeatureIterator(this.backendCollection.features(), this.featureType, this.indexMapping, this.geomPropertyName, this.backendGeomPropertyName);
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.backendCollection.getBounds();
    }

    @Override
    public String getID() {
        return "pregeneralizd featurecollection";
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    @Override
    public boolean isEmpty() {
        return this.backendCollection.isEmpty();
    }

    @Override
    public int size() {
        return this.backendCollection.size();
    }

    @Override
    public SimpleFeatureCollection sort(SortBy sortBy) {
        SimpleFeatureCollection fColl = this.backendCollection.sort(sortBy);
        if (fColl == null) {
            return null;
        }
        return new PreGeneralizedFeatureCollection(fColl, this.featureType, this.indexMapping, this.geomPropertyName, this.backendGeomPropertyName);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        SimpleFeatureCollection fColl = this.backendCollection.subCollection(filter);
        if (fColl == null) {
            return null;
        }
        return new PreGeneralizedFeatureCollection(fColl, this.featureType, this.indexMapping, this.geomPropertyName, this.backendGeomPropertyName);
    }

    @Override
    public Object[] toArray() {
        Object[] res = this.backendCollection.toArray();
        for (int i = 0; i < res.length; ++i) {
            res[i] = new PreGeneralizedSimpleFeature(this.getSchema(), this.indexMapping, (SimpleFeature)res[i], this.geomPropertyName, this.backendGeomPropertyName);
        }
        return res;
    }

    @Override
    public Object[] toArray(Object[] arg0) {
        Object[] res = this.backendCollection.toArray(arg0);
        for (int i = 0; i < res.length; ++i) {
            res[i] = new PreGeneralizedSimpleFeature(this.getSchema(), this.indexMapping, (SimpleFeature)res[i], this.geomPropertyName, this.backendGeomPropertyName);
        }
        return res;
    }
}

